/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ArchiveUtils {
    public static void unArchive(File inFile, File outDir) throws IOException {
        try {
            String name = inFile.getName().toLowerCase();
            if (name.endsWith(".zip")) {
                ArchiveUtils.unZip(inFile, outDir);
            } else if (name.endsWith(".jar")) {
                ArchiveUtils.unJar(inFile, outDir);
            } else if (name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
                ArchiveUtils.unGZip(inFile, outDir);
            } else if (name.endsWith(".tar")) {
                ArchiveUtils.unTar(inFile, outDir);
            }
        }
        catch (ArchiveException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unJar(File jarFile, File toDir) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                try (InputStream in = jar.getInputStream(entry);){
                    File file = new File(toDir, entry.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    try (FileOutputStream out = new FileOutputStream(file);){
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File inFile, File unzipDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(inFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                try (InputStream in = zipFile.getInputStream(entry);){
                    File file = new File(unzipDir, entry.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    try (FileOutputStream out = new FileOutputStream(file);){
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                }
            }
        }
    }

    public static void unTar(File inFile, File untarDir) throws IOException, ArchiveException {
        FileInputStream is = new FileInputStream(inFile);
        TarArchiveInputStream in = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
        TarArchiveEntry entry = null;
        untarDir.mkdirs();
        while ((entry = (TarArchiveEntry)in.getNextEntry()) != null) {
            byte[] content = new byte[(int)entry.getSize()];
            in.read(content);
            File entryFile = new File(untarDir, entry.getName());
            if (entry.isDirectory() && !entryFile.exists()) {
                if (entryFile.mkdirs()) continue;
                throw new IOException("Create directory failed: " + entryFile.getAbsolutePath());
            }
            FileOutputStream out = new FileOutputStream(entryFile);
            IOUtils.write((byte[])content, (OutputStream)out);
            ((OutputStream)out).close();
        }
        in.close();
    }

    public static void unGZip(File gzFile, File ungzipDir) throws IOException, ArchiveException {
        String gzFileName = gzFile.getName();
        String tarFileName = "";
        if (gzFileName.endsWith(".tar.gz")) {
            tarFileName = gzFileName.substring(0, gzFileName.length() - 3);
        } else if (gzFileName.endsWith(".tgz")) {
            tarFileName = gzFileName.substring(0, gzFileName.length() - 4) + ".tar";
        }
        File tarFile = new File(gzFile.getParentFile(), tarFileName);
        FileOutputStream tarOut = new FileOutputStream(tarFile);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(gzFile)));
        IOUtils.copy((InputStream)gzIn, (OutputStream)tarOut);
        tarOut.close();
        gzIn.close();
        ArchiveUtils.unTar(tarFile, ungzipDir);
        FileUtils.deleteQuietly((File)tarFile);
    }
}

