/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.ColumnOrConstant;
import com.aliyun.odps.local.common.DownloadMode;
import com.aliyun.odps.local.common.JobDirecotry;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.utils.DownloadUtils;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.local.common.utils.PartitionUtils;
import com.aliyun.odps.local.common.utils.SchemaUtils;
import com.aliyun.odps.local.common.utils.TypeConvertUtils;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.StringUtils;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WareHouse {
    private static final Log LOG = LogFactory.getLog(WareHouse.class);
    public static final Charset encoding = Charset.forName("UTF-8");
    private File warehouseDir;
    private static volatile WareHouse wareHouse;
    private ThreadLocal<Odps> odpsThreadLocal = new ThreadLocal();
    private ThreadLocal<Configuration> confThreadLocal = new ThreadLocal();
    private JobDirecotry jobDirecotry;

    private WareHouse() {
        this("warehouse");
    }

    private WareHouse(String dir) {
        this.warehouseDir = new File(dir);
        if (!this.warehouseDir.exists()) {
            this.warehouseDir.mkdirs();
        }
        this.jobDirecotry = new JobDirecotry();
    }

    public static synchronized WareHouse getInstance() {
        if (wareHouse == null) {
            wareHouse = new WareHouse();
        }
        return wareHouse;
    }

    public static synchronized WareHouse getInstance(String warehouseDir) {
        if (wareHouse == null) {
            wareHouse = new WareHouse(warehouseDir);
        }
        return wareHouse;
    }

    public static void init(Odps odps, Configuration conf) {
        WareHouse.getInstance().setOdps(odps);
        WareHouse.getInstance().setConfiguration(conf);
    }

    public File getWarehouseDir() {
        return this.warehouseDir;
    }

    public File getProjectDir(String projName) {
        return new File(this.warehouseDir, projName);
    }

    public File getResourceDir(String projName) {
        return new File(this.getProjectDir(projName), "__resources__");
    }

    public File getTableDir(String projName, String tblName) {
        File oldVersionDir;
        File tableDir = new File(this.getProjectDir(projName), "__tables__" + File.separator + tblName);
        if (!tableDir.exists() && (oldVersionDir = new File(this.getProjectDir(projName), tblName)).exists()) {
            return oldVersionDir;
        }
        return tableDir;
    }

    public File getPartitionDir(String projName, String tblName, PartitionSpec partSpec) {
        if (partSpec == null || partSpec.isEmpty()) {
            return this.getTableDir(projName, tblName);
        }
        Map<PartitionSpec, File> map = this.getPartitionToPathMap(projName, tblName);
        for (PartitionSpec key : map.keySet()) {
            if (!PartitionUtils.isEqual(key, partSpec)) continue;
            return map.get(key);
        }
        return null;
    }

    public PartitionSpec resolvePartition(String projName, String tblName, File dataFile) {
        if (StringUtils.isBlank((String)projName) || StringUtils.isBlank((String)tblName) || dataFile == null || !dataFile.exists()) {
            return null;
        }
        Map<PartitionSpec, File> partitionToPathMap = this.getPartitionToPathMap(projName, tblName);
        String dataFilePath = dataFile.getAbsolutePath().replaceAll("\\\\", "/");
        if (!dataFilePath.endsWith("/")) {
            dataFilePath = dataFilePath + "/";
        }
        for (PartitionSpec key : partitionToPathMap.keySet()) {
            String partitionPath = partitionToPathMap.get(key).getAbsolutePath().replaceAll("\\\\", "/");
            if (!dataFilePath.startsWith(partitionPath)) continue;
            return key;
        }
        return null;
    }

    public File getReourceFile(String projName, String resourceName) {
        return new File(this.warehouseDir, projName + File.separator + "__resources__" + File.separator + resourceName);
    }

    public File getTableReourceFile(String projName, String resourceName) {
        File tableResourceDir = this.getReourceFile(projName, resourceName);
        return tableResourceDir.listFiles()[0];
    }

    public File getTableSchemeFile(String projectName, String tableName) throws FileNotFoundException {
        if (!this.existsTableSchema(projectName, tableName)) {
            throw new FileNotFoundException("Table Directory :" + projectName + "." + tableName + " Not exists in warehouse!");
        }
        File tableDir = this.getTableDir(projectName, tableName);
        return new File(tableDir, "__schema__");
    }

    public String getRelativePath(String projName, String tblName, PartitionSpec partSpec, Object ... flag) {
        String relativePath = projName + File.separator + tblName + File.separator;
        if (partSpec != null) {
            relativePath = relativePath + PartitionUtils.toString(partSpec);
        }
        return relativePath;
    }

    public List<File> getDataFiles(String projName, String tblName, PartitionSpec pattern, char inputColumnSeperator) throws IOException, OdpsException {
        if (pattern != null && !pattern.isEmpty() && !this.existsPartition(projName, tblName, pattern)) {
            LinkedHashMap<String, String> part = PartitionUtils.convert(pattern);
            TableInfo tableInfo = TableInfo.builder().projectName(projName).tableName(tblName).partSpec(part).build();
            DownloadUtils.downloadTableSchemeAndData(WareHouse.getInstance().getOdps(), tableInfo, this.getLimitDownloadRecordCount(), inputColumnSeperator);
        } else if (!this.existsTable(projName, tblName)) {
            TableInfo tableInfo = TableInfo.builder().projectName(projName).tableName(tblName).build();
            DownloadUtils.downloadTableSchemeAndData(WareHouse.getInstance().getOdps(), tableInfo, this.getLimitDownloadRecordCount(), inputColumnSeperator);
        }
        File tableDir = this.getTableDir(projName, tblName);
        TableMeta tableMeta = SchemaUtils.readSchema(tableDir);
        boolean isPartitionTable = false;
        if (tableMeta.getPartitions() != null && tableMeta.getPartitions().length > 0) {
            isPartitionTable = true;
        }
        if (!isPartitionTable) {
            if (pattern != null && !pattern.isEmpty()) {
                throw new OdpsException("Table " + projName + "." + tblName + " is not a partition table");
            }
            return LocalRunUtils.listDataFiles(tableDir);
        }
        if (pattern == null) {
            ArrayList<File> result = new ArrayList<File>();
            LocalRunUtils.listAllDataFiles(tableDir, result);
            return result;
        }
        ArrayList<File> result = new ArrayList<File>();
        Map<PartitionSpec, File> partitionToPathMap = WareHouse.getInstance().getPartitionToPathMap(projName, tblName);
        for (PartitionSpec parts : partitionToPathMap.keySet()) {
            if (!PartitionUtils.match(pattern, parts)) continue;
            result.addAll(LocalRunUtils.listDataFiles(partitionToPathMap.get(parts)));
        }
        return result;
    }

    public boolean copyTableSchema(String projectName, String tableName, File destDir, int limitDownloadRecordCount, char inputColumnSeperator) throws IOException, OdpsException {
        File tableDir;
        File schemaFile;
        if (StringUtils.isBlank((String)projectName) || StringUtils.isBlank((String)tableName) || destDir == null) {
            return false;
        }
        TableInfo tableInfo = TableInfo.builder().projectName(projectName).tableName(tableName).build();
        LOG.info((Object)("Start to copy table schema: " + tableInfo + "-->" + destDir.getAbsolutePath()));
        if (!this.existsTable(projectName, tableName)) {
            DownloadUtils.downloadTableSchemeAndData(this.getOdps(), tableInfo, limitDownloadRecordCount, inputColumnSeperator);
        }
        if (!(schemaFile = new File(tableDir = this.getTableDir(projectName, tableName), "__schema__")).exists()) {
            throw new FileNotFoundException("Schema file of table " + projectName + "." + tableName + " not exists in warehouse.");
        }
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        FileUtils.copyFileToDirectory((File)schemaFile, (File)destDir);
        LOG.info((Object)("Finished copy table schema: " + tableInfo + "-->" + destDir.getAbsolutePath()));
        return true;
    }

    public boolean copyTable(String projectName, String tableName, PartitionSpec partSpec, String[] readCols, File destDir, int limitDownloadRecordCount, char inputColumnSeperator) {
        if (StringUtils.isBlank((String)projectName) || StringUtils.isBlank((String)tableName) || destDir == null) {
            return false;
        }
        TableInfo tableInfo = TableInfo.builder().projectName(projectName).tableName(tableName).partSpec(partSpec).build();
        LOG.info((Object)("Start to copy table: " + tableInfo + "-->" + destDir.getAbsolutePath()));
        boolean hasPartition = false;
        if (partSpec != null && !partSpec.isEmpty()) {
            hasPartition = true;
        }
        if (hasPartition && !this.existsPartition(projectName, tableName, partSpec)) {
            DownloadUtils.downloadTableSchemeAndData(this.getOdps(), tableInfo, limitDownloadRecordCount, inputColumnSeperator);
        } else if (!this.existsTable(projectName, tableName)) {
            DownloadUtils.downloadTableSchemeAndData(this.getOdps(), tableInfo, limitDownloadRecordCount, inputColumnSeperator);
        }
        File whTableDir = this.getTableDir(projectName, tableName);
        File schemaFile = new File(whTableDir, "__schema__");
        if (!schemaFile.exists()) {
            throw new RuntimeException("Schema file of table " + projectName + "." + tableName + " not exists in warehouse.");
        }
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try {
            FileUtils.copyFileToDirectory((File)schemaFile, (File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Copy schema file of table " + tableInfo + " failed!" + e.getMessage());
        }
        TableMeta tableMeta = this.getTableMeta(projectName, tableName);
        List<Integer> indexes = LocalRunUtils.genReadColsIndexes(tableMeta, readCols);
        if (hasPartition) {
            Collection dataFiles = FileUtils.listFiles((File)whTableDir, (IOFileFilter)HiddenFileFilter.VISIBLE, (IOFileFilter)HiddenFileFilter.VISIBLE);
            for (File dataFile : dataFiles) {
                String parentDir;
                String partPath;
                PartitionSpec ps;
                if (dataFile.getName().equals("__schema__") || !PartitionUtils.isEqual(ps = PartitionUtils.convert(partPath = (parentDir = dataFile.getParentFile().getAbsolutePath()).substring(whTableDir.getAbsolutePath().length(), parentDir.length())), partSpec)) continue;
                File destPartitionDir = new File(destDir, PartitionUtils.toString(ps));
                destPartitionDir.mkdirs();
                try {
                    this.copyDataFiles(dataFile.getParentFile(), indexes, destPartitionDir, inputColumnSeperator);
                }
                catch (IOException e) {
                    throw new RuntimeException("Copy data file of table " + tableInfo + " failed!" + e.getMessage());
                }
            }
        } else {
            try {
                this.copyDataFiles(whTableDir, indexes, destDir, inputColumnSeperator);
            }
            catch (IOException e) {
                throw new RuntimeException("Copy data file of table " + tableInfo + " failed!" + e.getMessage());
            }
        }
        LOG.info((Object)("Finished copy table: " + tableInfo + "-->" + destDir.getAbsolutePath()));
        return true;
    }

    public void copyResource(String projName, String resourceName, File resourceRootDir, int limitDownloadRecordCount, char inputColumnSeperator) throws IOException, OdpsException {
        File file;
        if (StringUtils.isBlank((String)projName) || StringUtils.isBlank((String)resourceName) || resourceRootDir == null) {
            return;
        }
        if (!resourceRootDir.exists()) {
            resourceRootDir.mkdirs();
        }
        LOG.info((Object)("Start to copy resource: " + projName + "." + resourceName + "-->" + resourceRootDir.getAbsolutePath()));
        if (!this.existsResource(projName, resourceName)) {
            DownloadUtils.downloadResource(this.getOdps(), projName, resourceName, limitDownloadRecordCount, inputColumnSeperator);
        }
        if ((file = this.getReourceFile(projName, resourceName)).isDirectory()) {
            File tableResourceDir = new File(resourceRootDir, resourceName);
            TableInfo refTableInfo = this.getReferencedTable(projName, resourceName);
            LinkedHashMap partitions = refTableInfo.getPartSpec();
            if (partitions != null && partitions.size() > 0) {
                PartitionSpec partSpec = new PartitionSpec();
                for (String key : partitions.keySet()) {
                    partSpec.set(key, (String)partitions.get(key));
                }
                this.copyTable(refTableInfo.getProjectName(), refTableInfo.getTableName(), partSpec, null, tableResourceDir, limitDownloadRecordCount, inputColumnSeperator);
            } else {
                this.copyTable(refTableInfo.getProjectName(), refTableInfo.getTableName(), null, null, tableResourceDir, limitDownloadRecordCount, inputColumnSeperator);
            }
        } else {
            if (!this.existsResource(projName, resourceName)) {
                DownloadUtils.downloadResource(this.getOdps(), projName, resourceName, limitDownloadRecordCount, inputColumnSeperator);
            }
            FileUtils.copyFileToDirectory((File)file, (File)resourceRootDir);
        }
        LOG.info((Object)("Finished copy resource: " + projName + "." + resourceName + "-->" + resourceRootDir.getAbsolutePath()));
    }

    public void copyDataFiles(File srcDir, List<Integer> indexes, File destDir, char inputColumnSeperator) throws IOException {
        if (indexes == null || indexes.isEmpty()) {
            for (File file : LocalRunUtils.listDataFiles(srcDir)) {
                FileUtils.copyFileToDirectory((File)file, (File)destDir);
            }
        } else {
            for (File file : LocalRunUtils.listDataFiles(srcDir)) {
                CsvReader reader = DownloadUtils.newCsvReader(file.getAbsolutePath(), inputColumnSeperator, encoding);
                CsvWriter writer = new CsvWriter(new File(destDir, file.getName()).getAbsolutePath(), inputColumnSeperator, encoding);
                while (reader.readRecord()) {
                    String[] vals = reader.getValues();
                    String[] newVals = new String[indexes.size()];
                    for (int i = 0; i < indexes.size(); ++i) {
                        newVals[i] = vals[indexes.get(i)];
                    }
                    writer.writeRecord(newVals);
                }
                writer.close();
                reader.close();
            }
        }
    }

    public File createPartitionDir(String projName, String tblName, PartitionSpec partSpec) {
        File tableDir = this.getTableDir(projName, tblName);
        if (!tableDir.exists()) {
            tableDir.mkdirs();
        }
        if (partSpec != null && !partSpec.isEmpty()) {
            File partitionDir = new File(tableDir, PartitionUtils.toString(partSpec));
            if (!partitionDir.exists()) {
                partitionDir.mkdirs();
            }
            return partitionDir;
        }
        return tableDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTableReourceFile(String projName, String resourceName, TableInfo refTableInfo) {
        File tableResourceDir;
        StringBuffer sb = new StringBuffer();
        sb.append(refTableInfo.getProjectName());
        sb.append(".");
        sb.append(refTableInfo.getTableName());
        String partitions = refTableInfo.getPartPath();
        if (partitions != null && !partitions.trim().isEmpty()) {
            sb.append("(");
            String partStr = partitions.replaceAll("/", ",");
            if (partStr.endsWith(",")) {
                partStr = partStr.substring(0, partStr.length() - 1);
            }
            sb.append(partStr);
            sb.append(")");
        }
        if (!(tableResourceDir = this.getReourceFile(projName, resourceName)).exists()) {
            tableResourceDir.mkdirs();
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new File(tableResourceDir, "__ref__"));
            pw.println(sb.toString());
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public TableMeta getResourceSchema(String projName, String resourceName) throws IOException {
        File dir = this.getReourceFile(projName, resourceName);
        if (SchemaUtils.existsSchemaFile(dir)) {
            return SchemaUtils.readSchema(dir);
        }
        return null;
    }

    public TableMeta getTableMeta(String projName, String tblName) {
        if (StringUtils.isBlank((String)projName) || StringUtils.isBlank((String)tblName)) {
            return null;
        }
        File dir = this.getTableDir(projName, tblName);
        TableMeta meta = SchemaUtils.readSchema(dir);
        if (meta.getProjName() != null && !meta.getProjName().equals(projName)) {
            throw new RuntimeException("Invalid project name " + meta.getProjName() + " in file 'warehouse" + File.separator + projName + File.separator + tblName + File.separator + "__schema__" + "'");
        }
        if (meta.getTableName() != null && !meta.getTableName().equals(tblName)) {
            throw new RuntimeException("Invalid table name " + meta.getProjName() + " in file 'warehouse" + File.separator + projName + File.separator + tblName + File.separator + "__schema__" + "'");
        }
        return meta;
    }

    public Map<PartitionSpec, File> getPartitionToPathMap(String projName, String tblName) {
        File tableDir = this.getTableDir(projName, tblName);
        TableMeta tableMeta = SchemaUtils.readSchema(tableDir);
        HashMap<PartitionSpec, File> result = new HashMap<PartitionSpec, File>();
        File dir = this.getTableDir(projName, tblName);
        Collection dataFiles = FileUtils.listFiles((File)dir, (IOFileFilter)HiddenFileFilter.VISIBLE, (IOFileFilter)HiddenFileFilter.VISIBLE);
        List<File> emptyPatitions = LocalRunUtils.listEmptyDirectory(dir);
        dataFiles.addAll(emptyPatitions);
        for (File dataFile : dataFiles) {
            String parentDir;
            if (dataFile.getName().equals("__schema__")) continue;
            String partPath = null;
            if (dataFile.isFile()) {
                parentDir = dataFile.getParentFile().getAbsolutePath();
                partPath = parentDir.substring(dir.getAbsolutePath().length(), parentDir.length());
            } else {
                parentDir = dataFile.getAbsolutePath();
                partPath = parentDir.substring(dir.getAbsolutePath().length(), parentDir.length());
            }
            try {
                if (partPath.length() <= 0) continue;
                PartitionSpec ps = PartitionUtils.convert(partPath);
                if (!PartitionUtils.valid(tableMeta.getPartitions(), ps)) continue;
                result.put(ps, dataFile.getParentFile());
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public List<PartitionSpec> getPartitions(String projName, String tblName) {
        Map<PartitionSpec, File> partitionToPathMap = this.getPartitionToPathMap(projName, tblName);
        ArrayList<PartitionSpec> result = new ArrayList<PartitionSpec>();
        for (PartitionSpec key : partitionToPathMap.keySet()) {
            result.add(key);
        }
        return result;
    }

    public List<String> getProjectNames() {
        File[] projects;
        File warehouseDir = this.getWarehouseDir();
        if (!warehouseDir.exists()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File p : projects = warehouseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.isHidden();
            }
        })) {
            if (!p.isDirectory()) continue;
            result.add(p.getName());
        }
        return result;
    }

    public List<TableMeta> getTableMetas(String projName) throws IOException {
        File[] tables;
        File projectDir = this.getProjectDir(projName);
        if (!projectDir.exists()) {
            return null;
        }
        ArrayList<TableMeta> result = new ArrayList<TableMeta>();
        for (File t : tables = projectDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.isHidden() && !pathname.getName().equals("__resources__");
            }
        })) {
            TableMeta tableMeta;
            if (!this.existsTable(projName, t.getName()) || (tableMeta = this.getTableMeta(projName, t.getName())) == null) continue;
            result.add(tableMeta);
        }
        File tableBaseDir = new File(projectDir, "__tables__");
        if (!tableBaseDir.exists()) {
            return result;
        }
        for (File t : tables = tableBaseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.isHidden();
            }
        })) {
            TableMeta tableMeta;
            if (!this.existsTable(projName, t.getName()) || (tableMeta = this.getTableMeta(projName, t.getName())) == null) continue;
            result.add(tableMeta);
        }
        return result;
    }

    public List<String> getTableNames(String projName) throws IOException {
        List<TableMeta> list = this.getTableMetas(projName);
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (TableMeta tableMeta : list) {
            result.add(tableMeta.getTableName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableInfo getReferencedTable(String projName, String resourceName) {
        block24: {
            TableInfo tableInfo;
            File file = this.getTableReourceFile(projName, resourceName);
            BufferedReader br = null;
            try {
                String table;
                String project;
                br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String line = br.readLine();
                while (line != null && (line.trim().isEmpty() || line.startsWith("#"))) {
                    line = br.readLine();
                }
                if (line == null || line.trim().isEmpty()) {
                    TableInfo tableInfo2 = null;
                    return tableInfo2;
                }
                int index = line.indexOf(".");
                if (index == -1) {
                    project = projName;
                } else {
                    project = line.substring(0, index);
                    line = line.substring(index + 1);
                }
                index = line.indexOf("(");
                if (index == -1) {
                    table = line;
                    line = null;
                } else {
                    table = line.substring(0, index);
                    line = line.substring(index + 1, line.length() - 1);
                }
                String partitions = null;
                if (line != null) {
                    TableInfo parts;
                    partitions = "";
                    for (TableInfo item : parts = line.split(",")) {
                        if (!partitions.equals("")) {
                            partitions = partitions + "/";
                        }
                        partitions = partitions + (String)item;
                    }
                }
                TableInfo tableInfo3 = partitions == null ? TableInfo.builder().projectName(project).tableName(table).build() : TableInfo.builder().projectName(project).tableName(table).partSpec(partitions).build();
                tableInfo = tableInfo3;
            }
            catch (IOException iOException) {
                break block24;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return tableInfo;
        }
        return null;
    }

    public boolean existsTable(String projName, String tblName) {
        return this.existsTableSchema(projName, tblName);
    }

    public boolean existsTableSchema(String projectName, String tableName) {
        File tableDir = this.getTableDir(projectName, tableName);
        if (!tableDir.exists()) {
            return false;
        }
        return new File(tableDir, "__schema__").exists();
    }

    public boolean existsPartition(String projectName, String tableName, PartitionSpec partSpec) {
        if (!this.existsTable(projectName, tableName)) {
            return false;
        }
        if (partSpec == null || partSpec.isEmpty()) {
            return true;
        }
        List<PartitionSpec> partionList = this.getPartitions(projectName, tableName);
        if (partionList == null || partionList.size() == 0) {
            return false;
        }
        for (PartitionSpec item : partionList) {
            if (!PartitionUtils.match(partSpec, item)) continue;
            return true;
        }
        return false;
    }

    public boolean existsResource(String projName, String resourceName) {
        return this.getReourceFile(projName, resourceName).exists();
    }

    public void dropTableIfExists(String projName, String tblName) throws IOException {
        File tableDir = this.getTableDir(projName, tblName);
        if (tableDir != null && tableDir.exists() && tableDir.isDirectory()) {
            FileUtils.deleteDirectory((File)tableDir);
        }
    }

    public void dropTableDataIfExists(String projName, String tblName, PartitionSpec partSpec) throws IOException {
        File partitionDir = this.getPartitionDir(projName, tblName, partSpec);
        if (partitionDir != null && partitionDir.exists() && partitionDir.isDirectory()) {
            LocalRunUtils.removeDataFiles(partitionDir);
        }
    }

    public boolean isTableEmpty(String projName, String tblName, PartitionSpec partSpec) throws IOException {
        File partitionDir = this.getPartitionDir(projName, tblName, partSpec);
        if (partitionDir != null && partitionDir.exists() && partitionDir.isDirectory()) {
            ArrayList<File> dataFiles = new ArrayList<File>();
            LocalRunUtils.listAllDataFiles(partitionDir, dataFiles);
            if (dataFiles == null || dataFiles.isEmpty()) {
                return true;
            }
            for (File f : dataFiles) {
                if (f.length() <= 0L) continue;
                return false;
            }
        }
        return true;
    }

    public void dropResourceIfExists(String projName, String resourceName) throws IOException {
        File resourceDir = this.getReourceFile(projName, resourceName);
        if (resourceDir == null || !resourceDir.exists()) {
            return;
        }
        if (resourceDir.isDirectory()) {
            FileUtils.deleteDirectory((File)resourceDir);
        }
        if (resourceDir.isFile()) {
            resourceDir.delete();
        }
    }

    public boolean valid(String projName, String tblName, PartitionSpec partitionSpec, String[] readCols) throws OdpsException, IOException {
        if (StringUtils.isBlank((String)projName)) {
            throw new OdpsException("Project " + projName + " is null");
        }
        if (StringUtils.isBlank((String)tblName)) {
            throw new OdpsException("Table Name is null");
        }
        if (!this.existsTable(projName, tblName)) {
            throw new OdpsException("table " + projName + "." + tblName + " not exitsts");
        }
        if (partitionSpec != null && !this.existsPartition(projName, tblName, partitionSpec)) {
            throw new OdpsException("table " + projName + "." + tblName + "(" + PartitionUtils.toString(partitionSpec) + ") not exitsts");
        }
        if (readCols != null) {
            TableMeta tableMeta = this.getTableMeta(projName, tblName);
            int columnCount = tableMeta.getCols().length;
            for (int i = 0; i < readCols.length; ++i) {
                boolean isFind = false;
                for (int j = 0; j < columnCount; ++j) {
                    if (!tableMeta.getCols()[j].getName().equals(readCols[i])) continue;
                    isFind = true;
                    break;
                }
                if (isFind) continue;
                throw new OdpsException("table " + projName + "." + tblName + " do not have column :" + readCols[i]);
            }
        }
        return true;
    }

    public List<Object[]> readData(String projName, String tblName, PartitionSpec partitionSpec, String[] readCols, char inputColumnSeparator) throws OdpsException, IOException {
        List<File> dataFiles = this.getDataFiles(projName, tblName, partitionSpec, inputColumnSeparator);
        if (dataFiles == null || dataFiles.size() == 0) {
            return null;
        }
        File tableDir = this.getTableDir(projName, tblName);
        TableMeta tableMeta = SchemaUtils.readSchema(tableDir);
        List<ColumnOrConstant> columnOrConstants = SchemaUtils.parseColumnConstant(readCols, tableMeta);
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (File file : dataFiles) {
            CsvReader reader = DownloadUtils.newCsvReader(file.getAbsolutePath(), inputColumnSeparator, encoding);
            while (reader.readRecord()) {
                int i;
                Object[] newVals;
                String[] vals = reader.getValues();
                if (columnOrConstants != null && !columnOrConstants.isEmpty()) {
                    newVals = new Object[columnOrConstants.size()];
                    for (i = 0; i < columnOrConstants.size(); ++i) {
                        ColumnOrConstant columnOrConstant = columnOrConstants.get(i);
                        if (columnOrConstant.isConstant()) {
                            newVals[i] = columnOrConstant.getConstantValue();
                            continue;
                        }
                        Integer colIndex = columnOrConstant.getColIndex();
                        newVals[i] = TypeConvertUtils.fromString(tableMeta.getCols()[colIndex].getTypeInfo(), vals[colIndex], false);
                    }
                } else {
                    newVals = new Object[vals.length];
                    for (i = 0; i < vals.length; ++i) {
                        newVals[i] = TypeConvertUtils.fromString(tableMeta.getCols()[i].getTypeInfo(), vals[i], false);
                    }
                }
                result.add(newVals);
            }
            reader.close();
        }
        return result;
    }

    public Class[] getColumnTypes(String projName, String tblName, String[] readCols) {
        Class[] result;
        File tableDir = this.getTableDir(projName, tblName);
        TableMeta tableMeta = SchemaUtils.readSchema(tableDir);
        Column[] columns = tableMeta.getCols();
        List<ColumnOrConstant> columnOrConstants = SchemaUtils.parseColumnConstant(readCols, tableMeta);
        if (columnOrConstants != null && !columnOrConstants.isEmpty()) {
            result = new Class[columnOrConstants.size()];
            for (int i = 0; i < columnOrConstants.size(); ++i) {
                TypeInfo typeInfo;
                ColumnOrConstant columnOrConstant = columnOrConstants.get(i);
                if (columnOrConstant.isConstant()) {
                    typeInfo = columnOrConstant.getConstantTypeInfo();
                } else {
                    Integer colIndex = columnOrConstant.getColIndex();
                    typeInfo = columns[colIndex].getTypeInfo();
                }
                result[i] = TypeConvertUtils.getOdpsJavaType(typeInfo);
            }
        } else {
            result = new Class[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                result[i] = TypeConvertUtils.getOdpsJavaType(columns[i].getTypeInfo());
            }
        }
        return result;
    }

    public BufferedInputStream readResourceFileAsStream(String project, String resource, char inputColumnSeperator) throws IOException, OdpsException {
        if (!this.existsResource(project, resource)) {
            DownloadUtils.downloadResource(WareHouse.getInstance().getOdps(), this.getOdps().getDefaultProject(), resource, this.getLimitDownloadRecordCount(), inputColumnSeperator);
        }
        if (!this.existsResource(project, resource)) {
            throw new OdpsException("File Resource " + project + "." + resource + " not exists");
        }
        File file = this.getReourceFile(project, resource);
        if (!file.isFile()) {
            throw new OdpsException("Resource " + project + "." + resource + " is not a valid file Resource, because it is a direcotry");
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    public byte[] readResourceFile(String project, String resource, char inputColumnSeperator) throws IOException, OdpsException {
        int length;
        File file;
        if (!this.existsResource(project, resource)) {
            DownloadUtils.downloadResource(WareHouse.getInstance().getOdps(), this.getOdps().getDefaultProject(), resource, this.getLimitDownloadRecordCount(), inputColumnSeperator);
        }
        if (!(file = this.getReourceFile(project, resource)).isFile()) {
            throw new OdpsException("Resource " + project + "." + resource + " is not a valid file Resource, because it is a direcotry");
        }
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] temp = new byte[1024];
        while ((length = in.read(temp)) != -1) {
            out.write(temp, 0, length);
        }
        in.close();
        return out.toByteArray();
    }

    public Iterator<Object[]> readResourceTable(String project, String resource, final char inputColumnSeperator) throws IOException, OdpsException {
        File tableResourceDir;
        if (!this.existsResource(project, resource)) {
            DownloadUtils.downloadResource(WareHouse.getInstance().getOdps(), this.getOdps().getDefaultProject(), resource, this.getLimitDownloadRecordCount(), inputColumnSeperator);
        }
        if (!(tableResourceDir = this.getReourceFile(project, resource)).isDirectory()) {
            throw new OdpsException("Resource " + project + "." + resource + " is not a valid file Resource, because it is not a direcotry");
        }
        TableInfo tableInfo = this.getReferencedTable(project, resource);
        PartitionSpec partitionSpec = PartitionUtils.convert(tableInfo.getPartSpec());
        final List<File> datafiles = this.getDataFiles(project, tableInfo.getTableName(), partitionSpec, inputColumnSeperator);
        final Column[] schema = SchemaUtils.readSchema(this.getTableDir(project, tableInfo.getTableName())).getCols();
        return new Iterator<Object[]>(){
            CsvReader reader;
            Object[] current;
            boolean fetched;

            @Override
            public boolean hasNext() {
                if (this.fetched) {
                    return this.current != null;
                }
                try {
                    this.fetch();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.current != null;
            }

            private void fetch() throws IOException {
                if (this.reader == null) {
                    if (datafiles.isEmpty()) {
                        this.current = null;
                        this.fetched = true;
                        return;
                    }
                    File f = (File)datafiles.remove(0);
                    this.reader = DownloadUtils.newCsvReader(f.getAbsolutePath(), inputColumnSeperator, encoding);
                    this.reader.setSafetySwitch(false);
                    this.current = this.read();
                    this.fetched = true;
                    return;
                }
                this.current = this.read();
                if (this.current == null && !datafiles.isEmpty()) {
                    File f = (File)datafiles.remove(0);
                    this.reader = DownloadUtils.newCsvReader(f.getAbsolutePath(), inputColumnSeperator, encoding);
                    this.reader.setSafetySwitch(false);
                    this.current = this.read();
                    this.fetched = true;
                    return;
                }
                this.fetched = true;
            }

            @Override
            public Object[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.fetched = false;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Object[] read() throws IOException {
                Object[] result;
                if (!this.reader.readRecord()) {
                    return null;
                }
                String[] vals = this.reader.getValues();
                if (vals == null || vals.length == 0) {
                    result = null;
                } else {
                    result = new Object[vals.length];
                    for (int i = 0; i < vals.length; ++i) {
                        result[i] = TypeConvertUtils.fromString(schema[i].getTypeInfo(), vals[i], false);
                    }
                }
                return result;
            }
        };
    }

    public boolean isRetainTempData() {
        String tempRetain = this.getConfiguration().get("odps.mapred.local.temp.retain", "true");
        return !tempRetain.equalsIgnoreCase("false");
    }

    public String getJobDirStr() {
        return this.getConfiguration().get("odps.mapred.local.temp.dir", "temp");
    }

    public JobDirecotry getJobDir() {
        return this.jobDirecotry;
    }

    public String getJobName() {
        return this.getConfiguration().get("odps.mapred.job.name", "");
    }

    public void setJobName(String jobname) {
        this.getConfiguration().set("odps.mapred.job.name", jobname);
    }

    public char getInputColumnSeperator() {
        String seperator = this.getConfiguration().get("odps.mapred.local.input.column.seperator", ",");
        if (seperator.length() > 0) {
            char c = seperator.charAt(0);
            if (c == 's' || c == ' ') {
                return ' ';
            }
            if (c == 't' || c == '\t') {
                return '\t';
            }
            if (c == ',' || c == '\t' || c == ';' || c == '|') {
                return c;
            }
        }
        return ',';
    }

    public char getOutputColumnSeperator() {
        String seperator = this.getConfiguration().get("odps.mapred.local.output.column.seperator", ",");
        if (seperator.length() > 0) {
            char c = seperator.charAt(0);
            if (c == 's' || c == ' ') {
                return ' ';
            }
            if (c == 't' || c == '\t') {
                return '\t';
            }
            if (c == ',' || c == '\t' || c == ';' || c == '|') {
                return c;
            }
        }
        return ',';
    }

    public int getLimitDownloadRecordCount() {
        int limit = this.getConfiguration().getInt("odps.mapred.local.record.download.limit", 100);
        return limit > 0 ? limit : 100;
    }

    public DownloadMode getDownloadMode() {
        String downloadModeStr = this.getConfiguration().get("odps.mapred.local.download.mode", DownloadMode.AUTO.toString()).toUpperCase();
        DownloadMode downloadMode = DownloadMode.AUTO;
        try {
            downloadMode = DownloadMode.valueOf(downloadModeStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return downloadMode;
    }

    public boolean caintainsKey(String key) {
        for (Map.Entry entry : this.getConfiguration()) {
            if (!((String)entry.getKey()).equals(key)) continue;
            return true;
        }
        return false;
    }

    public void setOdps(Odps odps) {
        if (odps != null) {
            this.odpsThreadLocal.remove();
            this.odpsThreadLocal.set(odps);
        }
    }

    public Odps getOdps() {
        return this.odpsThreadLocal.get();
    }

    public void setConfiguration(Configuration conf) {
        if (conf != null) {
            this.confThreadLocal.remove();
            this.confThreadLocal.set(conf);
        }
    }

    public Configuration getConfiguration() {
        Configuration conf = this.confThreadLocal.get();
        if (conf == null) {
            conf = new Configuration();
            this.confThreadLocal.set(conf);
        }
        return conf;
    }

    public void setTunnelEndpoint(String tunnelEndpoint) {
        this.getConfiguration().set("odps.tunnel.end.point", tunnelEndpoint);
    }

    public String getTunnelEndpoint() {
        return this.getConfiguration().get("odps.tunnel.end.point");
    }

    public void setRecordLimit(String recordLimit) {
        if (StringUtils.isBlank((String)recordLimit)) {
            return;
        }
        this.getConfiguration().set("odps.mapred.local.record.download.limit", recordLimit);
    }

    public void setColumnSeparator(String columnSeparator) {
        if (StringUtils.isBlank((String)columnSeparator)) {
            return;
        }
        this.getConfiguration().set("odps.mapred.local.input.column.seperator", columnSeparator);
    }
}

