/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.local.common;

import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.utils.StringUtils;
import java.io.File;

public class JobDirecotry {
    public File getJobDir() {
        File f = new File(WareHouse.getInstance().getJobDirStr(), WareHouse.getInstance().getJobName());
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public File getJobFile() {
        return new File(this.getJobDir(), "job.xml");
    }

    public File getInputBaseDir() {
        File f = new File(this.getJobDir(), "input");
        return f;
    }

    public File getOutputBaseDir() {
        File f = new File(this.getJobDir(), "output");
        return f;
    }

    public File getInputDir(String relativePath) {
        File f = new File(this.getJobDir(), "input" + File.separator + relativePath);
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public File convertInputFile(File jobInputFile) {
        int index;
        File jobInputBaseDir;
        String jobInputBaseDirStr;
        String jobInputFileStr = jobInputFile.getAbsolutePath().replaceAll("\\\\", "/");
        if (!jobInputFileStr.startsWith(jobInputBaseDirStr = (jobInputBaseDir = new File(this.getJobDir(), "input")).getAbsolutePath().replaceAll("\\\\", "/"))) {
            return null;
        }
        if (jobInputBaseDirStr.length() == jobInputFileStr.length()) {
            return new File(this.getJobDir(), "input");
        }
        String relativePath = jobInputFileStr.substring(jobInputBaseDirStr.length());
        if (relativePath.equals("/")) {
            return new File(this.getJobDir(), "input");
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        if ((index = relativePath.indexOf("/")) == -1) {
            return new File(WareHouse.getInstance().getWarehouseDir(), relativePath);
        }
        String projectName = relativePath.substring(0, index);
        relativePath = relativePath.substring(index);
        return new File(WareHouse.getInstance().getWarehouseDir(), projectName + File.separator + "__tables__" + File.separator + relativePath);
    }

    public File getOutputDir(String label) {
        StringBuilder sb = new StringBuilder("output" + File.separator);
        if (StringUtils.isNullOrEmpty((String)label)) {
            sb.append("__default__");
        } else {
            sb.append(label);
        }
        File f = new File(this.getJobDir(), sb.toString());
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public File getResourceDir() {
        File f = new File(this.getJobDir(), "resource");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public boolean hasResource(String resourceName) {
        File resourceRootDir = new File(this.getJobDir(), "resource");
        if (!resourceRootDir.exists()) {
            resourceRootDir.mkdirs();
        }
        File resourceDir = new File(resourceRootDir, resourceName);
        return resourceDir.exists();
    }
}

