/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local;

import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.graph.JobConf;
import com.aliyun.odps.local.common.JobDirecotry;
import com.aliyun.odps.utils.StringUtils;
import java.io.File;
import java.io.IOException;

public class RuntimeContext {
    private static final String LOCAL_RUN_DIR = "graph_local_jobs";
    private static RuntimeContext INSTANCE = null;
    private String jobId;
    private File jobDir;
    private File inputDir;
    private File outputDir;
    private File resourceDir;
    private File counterDir;
    private File superStepDir;
    private Counters counters = new Counters();

    private RuntimeContext(String jobId, JobConf conf) throws IOException {
        this.jobId = jobId;
        this.jobDir = new JobDirecotry().getJobDir();
        this.inputDir = new File(this.jobDir, "input");
        this.outputDir = new File(this.jobDir, "output");
        this.resourceDir = new File(this.jobDir, "resource");
        this.superStepDir = new File(this.jobDir, "superSteps");
        this.counterDir = new File(this.jobDir, "counters");
        this.inputDir.mkdirs();
        this.outputDir.mkdirs();
        this.resourceDir.mkdirs();
        this.superStepDir.mkdirs();
        this.counterDir.mkdirs();
    }

    public static synchronized RuntimeContext create(String jobId, JobConf conf) throws IOException {
        INSTANCE = new RuntimeContext(jobId, conf);
        return INSTANCE;
    }

    public static synchronized RuntimeContext getInstance() {
        return INSTANCE;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public String getJobId() {
        return this.jobId;
    }

    public File getJobDir() {
        return this.jobDir;
    }

    public File getJobFile() {
        return new File(this.jobDir, "job.xml");
    }

    public File getInputDir(String tbl, String partSpec) {
        String folder = StringUtils.isEmpty((String)partSpec) ? tbl : tbl + "/" + partSpec;
        return new File(this.inputDir, folder);
    }

    public File getOutputDir(String label) {
        if (label.isEmpty()) {
            label = "__default__";
        }
        return new File(this.outputDir, label);
    }

    public File getResourceDir() {
        return this.resourceDir;
    }

    public File getSuperStepDir() {
        return this.superStepDir;
    }

    public File getCounterDir() {
        return this.counterDir;
    }
}

