/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upload;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.ship.common.CommandType;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.RecordConverter;
import com.aliyun.odps.ship.upload.TunnelUpdateSession;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.jline.reader.UserInterruptException;

public class TunnelUploadSession
implements TunnelUpdateSession {
    TableTunnel.UploadSession upload;

    protected TunnelUploadSession(String str) {
    }

    public TunnelUploadSession() throws OdpsException, IOException, ODPSConsoleException {
        String tableProject = DshipContext.INSTANCE.get("table-project");
        String schemaName = DshipContext.INSTANCE.get("schema");
        String tableName = DshipContext.INSTANCE.get("table");
        String partitionSpec = DshipContext.INSTANCE.get("partition-spec");
        Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)DshipContext.INSTANCE.getExecutionContext());
        PartitionSpec ps = partitionSpec == null ? null : new PartitionSpec(partitionSpec);
        TableTunnel tunnel = new TableTunnel(odps);
        tunnel.getConfig().setQuotaName(DshipContext.INSTANCE.get("quota_name"));
        if (DshipContext.INSTANCE.get("tunnel_endpoint") != null) {
            tunnel.setEndpoint(DshipContext.INSTANCE.get("tunnel_endpoint"));
        } else if (StringUtils.isNotEmpty((String)DshipContext.INSTANCE.getExecutionContext().getTunnelEndpoint())) {
            tunnel.setEndpoint(DshipContext.INSTANCE.getExecutionContext().getTunnelEndpoint());
        }
        if (StringUtils.isEmpty((String)tableProject)) {
            tableProject = odps.getDefaultProject();
        }
        if (StringUtils.isNotEmpty((String)DshipContext.INSTANCE.get("resume-upload-id"))) {
            this.upload = ps == null ? tunnel.getUploadSession(tableProject, schemaName, tableName, DshipContext.INSTANCE.get("resume-upload-id")) : tunnel.getUploadSession(tableProject, schemaName, tableName, ps, DshipContext.INSTANCE.get("resume-upload-id"));
        } else {
            boolean overwrite = Boolean.parseBoolean(DshipContext.INSTANCE.get("overwrite"));
            if (ps == null) {
                this.upload = tunnel.createUploadSession(tableProject, schemaName, tableName, overwrite);
            } else {
                Table t;
                if ("true".equalsIgnoreCase(DshipContext.INSTANCE.get("auto-create-partition")) && !(t = odps.tables().get(tableProject, schemaName, tableName)).hasPartition(ps)) {
                    System.err.println("Create partition " + ps.toString());
                    t.createPartition(ps);
                }
                this.upload = tunnel.createUploadSession(tableProject, schemaName, tableName, ps, overwrite);
            }
        }
        System.err.println("Upload session: " + this.upload.getId());
    }

    @Override
    public void setScan(boolean isScan) {
        DshipContext.INSTANCE.put("scan", String.valueOf(isScan));
    }

    @Override
    public boolean isScan() {
        return Boolean.valueOf(DshipContext.INSTANCE.get("scan"));
    }

    @Override
    public TableSchema getSchema() {
        return this.upload.getSchema();
    }

    @Override
    public Record getRecord(RecordConverter recordConverter, byte[][] textRecord) throws UnsupportedEncodingException, ParseException {
        return recordConverter.parse(textRecord);
    }

    @Override
    public void initRecord() {
    }

    @Override
    public RecordWriter getWriter(long bId) throws TunnelException, IOException {
        if (this.isScan()) {
            return new ScanerWriter();
        }
        return this.upload.openRecordWriter(bId, Boolean.valueOf(DshipContext.INSTANCE.get("compress")).booleanValue());
    }

    @Override
    public String getSessionId() {
        return this.upload.getId();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.upload;
    }

    @Override
    public void complete(List<Long> bList) throws TunnelException, IOException {
        int retry = 1;
        while (true) {
            block7: {
                try {
                    this.upload.commit(bList.toArray(new Long[bList.size()]));
                    break;
                }
                catch (TunnelException e) {
                    System.err.println("Exception occurred while commit upload session: " + e.getMessage() + ", retry(" + retry + "/" + 5 + ")");
                    if (++retry > 5) {
                        throw e;
                    }
                }
                catch (IOException e) {
                    System.err.println("Exception occurred while commit upload session: " + e.getMessage() + ", retry(" + retry + "/" + 5 + ")");
                    if (++retry <= 5) break block7;
                    throw e;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new UserInterruptException(e.getMessage());
            }
        }
    }

    class ScanerWriter
    implements RecordWriter {
        ScanerWriter() {
        }

        public void close() throws IOException {
        }

        public void write(Record arg0) throws IOException {
        }
    }
}

