/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.upload;

import com.aliyun.odps.ship.common.BlockInfo;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public abstract class RecordReader {
    protected long startPos = 0L;
    protected long readBytes = 0L;
    protected BlockInfo blockInfo;
    protected String detectedCharset;
    protected int bomBytes;

    public RecordReader(BlockInfo info) {
        this.blockInfo = info;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public abstract byte[][] readTextRecord() throws IOException;

    public abstract String getCurrentLine();

    public abstract void close() throws IOException;

    public String getDetectedCharset() {
        return this.detectedCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectBomCharset() throws IOException {
        InputStream internalIs = this.blockInfo.getFileInputStream();
        try {
            byte[] bom = new byte[4];
            int n = internalIs.read(bom, 0, bom.length);
            if (n >= 4 && bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                this.detectedCharset = "UTF-32BE";
                this.bomBytes = 4;
            } else if (n >= 4 && bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                this.detectedCharset = "UTF-32LE";
                this.bomBytes = 4;
            } else if (n >= 3 && bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                this.detectedCharset = "UTF-8";
                this.bomBytes = 3;
            } else if (n >= 2 && bom[0] == -2 && bom[1] == -1) {
                this.detectedCharset = "UTF-16BE";
                this.bomBytes = 2;
            } else if (n >= 2 && bom[0] == -1 && bom[1] == -2) {
                this.detectedCharset = "UTF-16LE";
                this.bomBytes = 2;
            } else {
                this.detectedCharset = null;
                this.bomBytes = 0;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)internalIs);
        }
    }
}

