/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.history;

import com.aliyun.odps.ship.common.BlockInfo;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class SessionHistory {
    String sid;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    SessionHistory(String sid) {
        this.sid = sid;
        File f = new File(Util.getSessionDir(sid));
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContext() throws FileNotFoundException, IOException {
        String cp = Util.getSessionDir(this.sid) + "/context.properties";
        Properties p = new Properties();
        p.putAll(DshipContext.INSTANCE.getAll());
        FileOutputStream out = new FileOutputStream(cp);
        try {
            p.store(out, "context");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void loadContext() throws FileNotFoundException, IOException {
        Map<String, String> ctx = this.loadProperty();
        DshipContext.INSTANCE.putAll(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> loadProperty() throws FileNotFoundException, IOException {
        String cp = Util.getSessionDir(this.sid) + "/context.properties";
        File file = new File(cp);
        if (!file.exists()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> context = new HashMap<String, String>();
        FileInputStream in = new FileInputStream(file);
        try {
            Properties p = new Properties();
            p.load(in);
            Set<Map.Entry<Object, Object>> entrySet = p.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                if (entry.getKey().toString().startsWith("#")) continue;
                context.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return context;
    }

    public void log(String msg) throws FileNotFoundException, IOException {
        String log = Util.getSessionDir(this.sid) + "/log.txt";
        String m = this.df.format(new Date()) + "  -  " + msg + "\n";
        this.write(new File(log), m, true);
    }

    public void clearBadData(long bid) {
        String bad = Util.getSessionDir(this.sid) + "/bad_" + bid;
        File f = new File(bad);
        if (f.exists()) {
            f.delete();
        }
    }

    public void delete() {
        File parentFile;
        String s = Util.getSessionDir(this.sid);
        File f = new File(s);
        if (f.exists()) {
            File[] fs;
            for (File df : fs = f.listFiles()) {
                df.delete();
            }
            f.delete();
        }
        if ((parentFile = f.getParentFile()).list().length == 0) {
            parentFile.delete();
        }
    }

    public void saveBadData(String data, long bid) throws IOException {
        String bad = Util.getSessionDir(this.sid) + "/bad_" + bid;
        this.write(new File(bad), data, true);
    }

    public void showLog() throws FileNotFoundException, IOException {
        String log = Util.getSessionDir(this.sid) + "/log.txt";
        this.show(new File(log));
    }

    protected boolean existsBad() {
        File dir = new File(Util.getSessionDir(this.sid));
        String[] bl = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.indexOf("bad_") == 0;
            }
        });
        return bl != null && bl.length > 0;
    }

    public void showBad() throws FileNotFoundException, IOException {
        String bad = Util.getSessionDir(this.sid);
        File[] fs = new File(bad).listFiles();
        for (File f : fs = Util.sortFiles(fs)) {
            if (f.getName().indexOf("bad_") != 0) continue;
            this.show(f);
        }
    }

    public void saveBlockIndex(ArrayList<BlockInfo> blockIndex) throws FileNotFoundException, IOException {
        File blockIndexFile = new File(Util.getSessionDir(this.sid) + "/block_index.txt");
        if (blockIndexFile.exists()) {
            blockIndexFile.delete();
        }
        for (BlockInfo blockInfo : blockIndex) {
            this.write(blockIndexFile, blockInfo.toString() + "\n", true);
        }
    }

    public void saveFinishBlock(BlockInfo blockInfo) throws FileNotFoundException, IOException {
        File finishBlockFile = new File(Util.getSessionDir(this.sid) + "/finish_block.txt");
        this.write(finishBlockFile, blockInfo.toString() + "\n", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BlockInfo> loadBlockIndex() throws IOException {
        ArrayList<BlockInfo> blockIndex = new ArrayList<BlockInfo>();
        File blockIndexFile = new File(Util.getSessionDir(this.sid) + "/block_index.txt");
        if (!blockIndexFile.exists()) {
            return blockIndex;
        }
        BufferedReader blockIndexReader = new BufferedReader(new FileReader(blockIndexFile));
        try {
            String blockInfo = null;
            while ((blockInfo = blockIndexReader.readLine()) != null) {
                BlockInfo block = new BlockInfo();
                block.parse(blockInfo);
                blockIndex.add(block);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)blockIndexReader);
        }
        File finishBlockFile = new File(Util.getSessionDir(this.sid) + "/finish_block.txt");
        if (!finishBlockFile.exists()) {
            return blockIndex;
        }
        BufferedReader finishBlockReader = new BufferedReader(new FileReader(finishBlockFile));
        try {
            String finishBlock = null;
            while ((finishBlock = finishBlockReader.readLine()) != null) {
                BlockInfo block = new BlockInfo();
                block.parse(finishBlock);
                blockIndex.remove(block);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)finishBlockReader);
        }
        return blockIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockInfo> loadFinishBlockList() throws IOException {
        ArrayList<BlockInfo> blockList = new ArrayList<BlockInfo>();
        File finishBlockFile = new File(Util.getSessionDir(this.sid) + "/finish_block.txt");
        if (!finishBlockFile.exists()) {
            return blockList;
        }
        BufferedReader finishBlockReader = new BufferedReader(new FileReader(finishBlockFile));
        try {
            String finishBlock = null;
            while ((finishBlock = finishBlockReader.readLine()) != null) {
                BlockInfo block = new BlockInfo();
                block.parse(finishBlock);
                blockList.add(block);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)finishBlockReader);
        }
        return blockList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void show(File f) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(f);
        try {
            InputStreamReader r = new InputStreamReader((InputStream)fileInputStream, "utf-8");
            int c = r.read();
            while (c != -1) {
                System.out.print((char)c);
                c = r.read();
            }
            r.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(File f, String data, boolean append) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(f, append);
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            w.write(data);
            w.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public String getSid() {
        return this.sid;
    }
}

