/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.download;

import com.aliyun.odps.Column;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.ship.download.TunnelDownloadSession;
import com.aliyun.odps.ship.history.SessionHistoryManager;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.util.List;

public class DshipRecordReader {
    private TunnelDownloadSession download;
    private Long end;
    TunnelRecordReader tunnelReader;
    private long currentLines;
    int retry = 0;
    private Record r = null;
    private List<Column> columns = null;

    public DshipRecordReader(TunnelDownloadSession download, Long start, Long end, List<Column> columns) throws IOException, TunnelException {
        this.download = download;
        this.end = end;
        this.currentLines = start;
        this.columns = columns;
        if (!start.equals(end)) {
            this.initReader(null);
        }
    }

    public Record next() throws TunnelException, IOException {
        if (this.tunnelReader == null) {
            return null;
        }
        try {
            this.r = this.tunnelReader.read(this.r);
            ++this.currentLines;
            this.retry = 0;
            return this.r;
        }
        catch (IOException e) {
            this.initReader(e);
            return this.next();
        }
    }

    protected void initReader(Exception throwedException) throws TunnelException, IOException {
        ++this.retry;
        if (this.retry > 5) {
            if (throwedException != null) {
                throw new IOException("ERROR: download read error, retry exceed 5.\n" + throwedException.getMessage(), throwedException);
            }
            throw new IOException("ERROR: download read error, retry exceed 5.");
        }
        if (this.tunnelReader != null) {
            this.tunnelReader.close();
            this.tunnelReader = null;
        }
        try {
            this.tunnelReader = (TunnelRecordReader)this.openRecordReader(this.currentLines);
        }
        catch (Exception e) {
            SessionHistoryManager.createSessionHistory(this.download.getDownloadId()).log("retry:" + this.retry + "  " + Util.getStack(e));
            this.initReader(e);
        }
    }

    protected RecordReader openRecordReader(long currentLines) throws TunnelException, IOException {
        if (currentLines > this.end) {
            throw new TunnelException("ERROR: current lines: " + currentLines + " end: " + this.end);
        }
        return this.download.openRecordReader(currentLines, this.end - currentLines, Boolean.valueOf(DshipContext.INSTANCE.get("compress")), this.columns);
    }
}

