/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.common;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.ship.common.DshipContext;
import com.aliyun.odps.ship.common.Util;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.exception.ExceptionUtils;

public class RecordConverter {
    private final byte[] nullBytes;
    private final Record r;
    TableSchema schema;
    String nullTag;
    DateTimeFormatter zonedDatetimeFormatter;
    DateTimeFormatter dateFormatter;
    DateTimeFormatter timestampFormatter;
    DecimalFormat doubleFormat;
    String charset;
    ZoneId zoneId;
    String defaultCharset;
    boolean isStrictSchema;
    private final Gson gson = new Gson();
    private final JsonParser jsonParser = new JsonParser();

    public RecordConverter(TableSchema schema, String nullTag, String datetimeFormat, String tz, String charset, boolean exponential, boolean isStrictSchema) throws UnsupportedEncodingException {
        this.schema = schema;
        this.nullTag = nullTag;
        this.isStrictSchema = isStrictSchema;
        try {
            if (datetimeFormat == null) {
                this.zonedDatetimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                this.timestampFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
            } else {
                this.zonedDatetimeFormatter = DateTimeFormatter.ofPattern(datetimeFormat);
                this.timestampFormatter = DateTimeFormatter.ofPattern(datetimeFormat);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported date format pattern '" + DshipContext.INSTANCE.get("date-format-pattern") + "'");
        }
        this.zoneId = ZoneId.systemDefault();
        if (tz != null) {
            this.zoneId = TimeZone.getTimeZone(tz).toZoneId();
            if (!tz.equalsIgnoreCase("GMT") && this.zoneId.getId().equals("GMT")) {
                System.err.println("WARNING: possible invalid time zone: " + tz + ", fall back to GMT");
            }
        }
        this.zonedDatetimeFormatter = this.zonedDatetimeFormatter.withZone(this.zoneId);
        this.timestampFormatter = this.timestampFormatter.withZone(this.zoneId);
        this.dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withResolverStyle(ResolverStyle.LENIENT);
        if (exponential) {
            this.doubleFormat = null;
        } else {
            this.doubleFormat = new DecimalFormat();
            this.doubleFormat.setMinimumFractionDigits(0);
            this.doubleFormat.setMaximumFractionDigits(20);
        }
        this.setCharset(charset);
        this.r = new ArrayRecord(schema.getColumns().toArray(new Column[0]));
        this.nullBytes = nullTag.getBytes(this.defaultCharset);
    }

    public byte[][] format(Record r) throws UnsupportedEncodingException {
        int cols = this.schema.getColumns().size();
        byte[][] line = new byte[cols][];
        Object v = null;
        block6: for (int i = 0; i < cols; ++i) {
            TypeInfo typeInfo = this.schema.getColumn(i).getTypeInfo();
            switch (typeInfo.getOdpsType()) {
                case STRING: 
                case CHAR: 
                case VARCHAR: 
                case BINARY: {
                    v = r.getBytes(i);
                    line[i] = this.formatValue(typeInfo, v);
                    continue block6;
                }
                case ARRAY: {
                    v = r.get(i);
                    line[i] = this.formatValueArray((ArrayTypeInfo)typeInfo, (List)v).getBytes(this.defaultCharset);
                    continue block6;
                }
                case MAP: {
                    v = r.get(i);
                    line[i] = this.formatValueMap((MapTypeInfo)typeInfo, (Map)v).getBytes(this.defaultCharset);
                    continue block6;
                }
                case STRUCT: {
                    v = r.get(i);
                    line[i] = this.formatValueStruct((StructTypeInfo)typeInfo, (Struct)v).getBytes(this.defaultCharset);
                    continue block6;
                }
                default: {
                    v = r.get(i);
                    line[i] = this.formatValue(typeInfo, v);
                }
            }
        }
        return line;
    }

    private String formatValueArray(ArrayTypeInfo typeInfo, List<Object> list) throws UnsupportedEncodingException {
        if (list == null) {
            return this.nullTag;
        }
        TypeInfo elementTypeInfo = typeInfo.getElementTypeInfo();
        ArrayList<String> ret = new ArrayList<String>(list.size());
        block5: for (Object o : list) {
            switch (elementTypeInfo.getOdpsType()) {
                case ARRAY: {
                    ret.add(this.formatValueArray((ArrayTypeInfo)elementTypeInfo, (List)o));
                    continue block5;
                }
                case MAP: {
                    ret.add(this.formatValueMap((MapTypeInfo)elementTypeInfo, (Map)o));
                    continue block5;
                }
                case STRUCT: {
                    ret.add(this.formatValueStruct((StructTypeInfo)elementTypeInfo, (Struct)o));
                    continue block5;
                }
            }
            ret.add(new String(this.formatValue(elementTypeInfo, o), this.defaultCharset));
        }
        return this.gson.toJson(ret);
    }

    private String formatValueMap(MapTypeInfo typeInfo, Map<Object, Object> map) throws UnsupportedEncodingException {
        if (map == null) {
            return this.nullTag;
        }
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>(map.size());
        TypeInfo keyTypeInfo = typeInfo.getKeyTypeInfo();
        TypeInfo valueTypeInfo = typeInfo.getValueTypeInfo();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            switch (keyTypeInfo.getOdpsType()) {
                case ARRAY: {
                    key = this.formatValueArray((ArrayTypeInfo)keyTypeInfo, (List)key);
                    break;
                }
                case MAP: {
                    key = this.formatValueMap((MapTypeInfo)keyTypeInfo, (Map)key);
                    break;
                }
                case STRUCT: {
                    key = this.formatValueStruct((StructTypeInfo)keyTypeInfo, (Struct)key);
                    break;
                }
                default: {
                    key = new String(this.formatValue(keyTypeInfo, key), this.defaultCharset);
                }
            }
            switch (valueTypeInfo.getOdpsType()) {
                case ARRAY: {
                    value = this.formatValueArray((ArrayTypeInfo)valueTypeInfo, (List)value);
                    break;
                }
                case MAP: {
                    value = this.formatValueMap((MapTypeInfo)valueTypeInfo, (Map)value);
                    break;
                }
                case STRUCT: {
                    value = this.formatValueStruct((StructTypeInfo)valueTypeInfo, (Struct)value);
                    break;
                }
                default: {
                    value = new String(this.formatValue(valueTypeInfo, value), this.defaultCharset);
                }
            }
            ret.put(key, value);
        }
        return this.gson.toJson(ret);
    }

    private String formatValueStruct(StructTypeInfo typeInfo, Struct struct) throws UnsupportedEncodingException {
        if (struct == null) {
            return this.nullTag;
        }
        ArrayList<Object> values = new ArrayList<Object>(struct.getFieldCount());
        List fieldTypeInfos = typeInfo.getFieldTypeInfos();
        for (int i = 0; i < typeInfo.getFieldCount(); ++i) {
            TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(i);
            Object o = struct.getFieldValue(i);
            switch (fieldTypeInfo.getOdpsType()) {
                case ARRAY: {
                    o = this.formatValueArray((ArrayTypeInfo)fieldTypeInfo, (List)o);
                    break;
                }
                case MAP: {
                    o = this.formatValueMap((MapTypeInfo)fieldTypeInfo, (Map)o);
                    break;
                }
                case STRUCT: {
                    o = this.formatValueStruct((StructTypeInfo)fieldTypeInfo, (Struct)o);
                    break;
                }
                default: {
                    o = new String(this.formatValue(fieldTypeInfo, o), this.defaultCharset);
                }
            }
            values.add(o);
        }
        SimpleStruct newStruct = new SimpleStruct(typeInfo, values);
        return this.structToJson((Struct)newStruct);
    }

    private String structToJson(Struct struct) {
        List values = struct.getFieldValues();
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        for (int i = 0; i < values.size(); ++i) {
            String fieldName = struct.getFieldName(i);
            Object val = values.get(i);
            if (val == null) {
                info.put(fieldName, this.nullTag);
                continue;
            }
            info.put(fieldName, (String)val);
        }
        return this.gson.toJson(info);
    }

    private byte[] formatValue(TypeInfo typeInfo, Object v) throws UnsupportedEncodingException {
        if (v == null) {
            return this.nullBytes;
        }
        switch (typeInfo.getOdpsType()) {
            case BIGINT: 
            case INT: 
            case SMALLINT: 
            case TINYINT: 
            case BOOLEAN: {
                return v.toString().getBytes(this.defaultCharset);
            }
            case DOUBLE: {
                if (v.equals(Double.POSITIVE_INFINITY) || v.equals(Double.NEGATIVE_INFINITY)) {
                    return v.toString().getBytes(this.defaultCharset);
                }
                if (this.doubleFormat != null) {
                    return this.doubleFormat.format(v).replaceAll(",", "").getBytes(this.defaultCharset);
                }
                return v.toString().replaceAll(",", "").getBytes(this.defaultCharset);
            }
            case FLOAT: {
                if (v.equals(Float.valueOf(Float.POSITIVE_INFINITY)) || v.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                    return v.toString().getBytes(this.defaultCharset);
                }
                return v.toString().replaceAll(",", "").getBytes(this.defaultCharset);
            }
            case DATETIME: {
                return this.zonedDatetimeFormatter.format((ZonedDateTime)v).getBytes(this.defaultCharset);
            }
            case DATE: {
                return ((LocalDate)v).toString().getBytes(this.defaultCharset);
            }
            case TIMESTAMP: {
                return this.timestampFormatter.format((Instant)v).getBytes(this.defaultCharset);
            }
            case TIMESTAMP_NTZ: {
                return ((LocalDateTime)v).format(this.timestampFormatter).getBytes(this.defaultCharset);
            }
            case BINARY: {
                return (byte[])v;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (v instanceof String) {
                    v = ((String)v).getBytes("utf8");
                }
                if (Util.isIgnoreCharset(this.charset)) {
                    return (byte[])v;
                }
                return new String((byte[])v, "utf8").getBytes(this.charset);
            }
            case DECIMAL: {
                return ((BigDecimal)v).toPlainString().getBytes(this.defaultCharset);
            }
            case ARRAY: 
            case MAP: 
            case STRUCT: {
                throw new RuntimeException("Not supported column type: " + typeInfo);
            }
        }
        throw new RuntimeException("Unknown column type: " + typeInfo);
    }

    public Record parse(byte[][] line) throws ParseException, UnsupportedEncodingException {
        return this.parse(this.r, line);
    }

    public Record parse(Record record, byte[][] line) throws ParseException, UnsupportedEncodingException {
        if (line == null) {
            return null;
        }
        int cols = this.schema.getColumns().size();
        if (this.isStrictSchema && line.length != cols) {
            throw new ParseException("ERROR: column mismatch, expected " + this.schema.getColumns().size() + " columns, " + line.length + " columns found, please check data or delimiter\n");
        }
        int idx = 0;
        for (byte[] v : line) {
            if (idx >= cols && !this.isStrictSchema) break;
            TypeInfo typeInfo = this.schema.getColumn(idx).getTypeInfo();
            try {
                record.set(idx, this.parseValue(typeInfo, v));
            }
            catch (Exception e) {
                String vStr = Util.isIgnoreCharset(this.charset) ? new String(v, "utf8") : new String(v, this.charset);
                String val = vStr.length() > 20 ? vStr.substring(0, 17) + "..." : vStr;
                throw new ParseException("ERROR: format error - :" + (idx + 1) + ", " + typeInfo + ":'" + val + "'  " + ExceptionUtils.getFullStackTrace((Throwable)e));
            }
            ++idx;
        }
        return record;
    }

    private Object parseValue(TypeInfo typeInfo, byte[] v) throws UnsupportedEncodingException, ParseException {
        if (Arrays.equals(v, this.nullBytes)) {
            return null;
        }
        boolean isIgnoreCharset = Util.isIgnoreCharset(this.charset);
        OdpsType type = typeInfo.getOdpsType();
        String value = this.getTrimmedString(v, this.defaultCharset);
        switch (type) {
            case BIGINT: {
                return Long.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case DATETIME: {
                try {
                    TemporalAccessor accessor = this.timestampFormatter.parseBest(value, ZonedDateTime::from, LocalDate::from);
                    if (accessor instanceof LocalDate) {
                        accessor = ((LocalDate)accessor).atStartOfDay(this.zoneId);
                    }
                    return accessor;
                }
                catch (RuntimeException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            case BOOLEAN: {
                String vStr = value.toLowerCase();
                if ("true".equals(vStr) || "false".equals(vStr)) {
                    return "true".equals(vStr);
                }
                if ("0".equals(vStr) || "1".equals(vStr)) {
                    return "1".equals(vStr);
                }
                throw new IllegalArgumentException("Invalid boolean value, expect: 'true'|'false'|'0'|'1'");
            }
            case STRING: {
                try {
                    if (isIgnoreCharset) {
                        return v;
                    }
                    return this.getTrimmedString(v, this.charset);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("String value bigger than 8M");
                }
            }
            case CHAR: {
                return new Char(value);
            }
            case VARCHAR: {
                return new Varchar(value);
            }
            case DECIMAL: {
                return new BigDecimal(value);
            }
            case INT: {
                return Integer.valueOf(value);
            }
            case TINYINT: {
                return Byte.valueOf(value);
            }
            case SMALLINT: {
                return Short.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case BINARY: {
                return new Binary(v);
            }
            case DATE: {
                return LocalDate.parse(value, this.dateFormatter);
            }
            case TIMESTAMP: {
                try {
                    ZonedDateTime dateTime = ZonedDateTime.parse(value, this.timestampFormatter);
                    return dateTime.toInstant();
                }
                catch (RuntimeException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            case TIMESTAMP_NTZ: {
                try {
                    return LocalDateTime.parse(value, this.timestampFormatter);
                }
                catch (RuntimeException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            case MAP: {
                JsonElement map = this.jsonParser.parse(value);
                if (map.isJsonNull()) {
                    return null;
                }
                return this.transformMap(map.getAsJsonObject(), (MapTypeInfo)typeInfo);
            }
            case STRUCT: {
                JsonElement struct = this.jsonParser.parse(value);
                if (struct.isJsonNull()) {
                    return null;
                }
                return this.transformStruct(struct.getAsJsonObject(), (StructTypeInfo)typeInfo);
            }
            case ARRAY: {
                JsonElement array = this.jsonParser.parse(value);
                if (array.isJsonNull()) {
                    return null;
                }
                return this.transformArray(array.getAsJsonArray(), (ArrayTypeInfo)typeInfo);
            }
        }
        throw new IllegalArgumentException("Unknown column type: " + typeInfo);
    }

    private List<Object> transformArray(JsonArray arrayObj, ArrayTypeInfo typeInfo) throws UnsupportedEncodingException, ParseException {
        ArrayList<Object> newList = new ArrayList<Object>();
        TypeInfo elementTypeInfo = typeInfo.getElementTypeInfo();
        block5: for (JsonElement element : arrayObj) {
            switch (elementTypeInfo.getOdpsType()) {
                case ARRAY: {
                    JsonElement array = this.jsonParser.parse(element.getAsString());
                    if (array.isJsonNull() || array.isJsonPrimitive() && array.getAsString().equals(this.nullTag)) {
                        newList.add(null);
                        continue block5;
                    }
                    newList.add(this.transformArray(array.getAsJsonArray(), (ArrayTypeInfo)elementTypeInfo));
                    continue block5;
                }
                case MAP: {
                    JsonElement map = this.jsonParser.parse(element.getAsString());
                    if (map.isJsonNull() || map.isJsonPrimitive() && map.getAsString().equals(this.nullTag)) {
                        newList.add(null);
                        continue block5;
                    }
                    newList.add(this.transformMap(map.getAsJsonObject(), (MapTypeInfo)elementTypeInfo));
                    continue block5;
                }
                case STRUCT: {
                    JsonElement struct = this.jsonParser.parse(element.getAsString());
                    if (struct.isJsonNull() || struct.isJsonPrimitive() && struct.getAsString().equals(this.nullTag)) {
                        newList.add(null);
                        continue block5;
                    }
                    newList.add(this.transformStruct(struct.getAsJsonObject(), (StructTypeInfo)elementTypeInfo));
                    continue block5;
                }
            }
            newList.add(this.parseValue(elementTypeInfo, element.getAsString().getBytes(this.defaultCharset)));
        }
        return newList;
    }

    private Map<Object, Object> transformMap(JsonObject mapObj, MapTypeInfo typeInfo) throws UnsupportedEncodingException, ParseException {
        TypeInfo keyTypeInfo = typeInfo.getKeyTypeInfo();
        TypeInfo valTypeInfo = typeInfo.getValueTypeInfo();
        LinkedHashMap<Object, Object> newMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry entry : mapObj.entrySet()) {
            Object newValue;
            JsonElement struct;
            JsonElement array;
            Object newKey;
            JsonElement map;
            String keyStr = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            switch (keyTypeInfo.getOdpsType()) {
                case MAP: {
                    map = this.jsonParser.parse(keyStr);
                    if (map.isJsonNull() || map.isJsonPrimitive() && map.getAsString().equals(this.nullTag)) {
                        newKey = null;
                        break;
                    }
                    newKey = this.transformMap(map.getAsJsonObject(), (MapTypeInfo)keyTypeInfo);
                    break;
                }
                case ARRAY: {
                    array = this.jsonParser.parse(keyStr);
                    if (array.isJsonNull() || array.isJsonPrimitive() && array.getAsString().equals(this.nullTag)) {
                        newKey = null;
                        break;
                    }
                    newKey = this.transformArray(array.getAsJsonArray(), (ArrayTypeInfo)keyTypeInfo);
                    break;
                }
                case STRUCT: {
                    struct = this.jsonParser.parse(keyStr);
                    if (struct.isJsonNull() || struct.isJsonPrimitive() && struct.getAsString().equals(this.nullTag)) {
                        newKey = null;
                        break;
                    }
                    newKey = this.transformStruct(struct.getAsJsonObject(), (StructTypeInfo)keyTypeInfo);
                    break;
                }
                default: {
                    newKey = this.parseValue(keyTypeInfo, keyStr.getBytes(this.defaultCharset));
                }
            }
            switch (valTypeInfo.getOdpsType()) {
                case MAP: {
                    map = this.jsonParser.parse(value.getAsString());
                    if (map.isJsonNull() || map.isJsonPrimitive() && map.getAsString().equals(this.nullTag)) {
                        newValue = null;
                        break;
                    }
                    newValue = this.transformMap(map.getAsJsonObject(), (MapTypeInfo)valTypeInfo);
                    break;
                }
                case ARRAY: {
                    array = this.jsonParser.parse(value.getAsString());
                    if (array.isJsonNull() || array.isJsonPrimitive() && array.getAsString().equals(this.nullTag)) {
                        newValue = null;
                        break;
                    }
                    newValue = this.transformArray(array.getAsJsonArray(), (ArrayTypeInfo)valTypeInfo);
                    break;
                }
                case STRUCT: {
                    struct = this.jsonParser.parse(value.getAsString());
                    if (struct.isJsonNull() || struct.isJsonPrimitive() && struct.getAsString().equals(this.nullTag)) {
                        newValue = null;
                        break;
                    }
                    newValue = this.transformStruct(struct.getAsJsonObject(), (StructTypeInfo)valTypeInfo);
                    break;
                }
                default: {
                    newValue = this.parseValue(valTypeInfo, value.getAsString().getBytes(this.defaultCharset));
                }
            }
            newMap.put(newKey, newValue);
        }
        return newMap;
    }

    private Struct transformStruct(JsonObject structObj, StructTypeInfo typeInfo) throws UnsupportedEncodingException, ParseException {
        ArrayList<Object> values = new ArrayList<Object>();
        List fieldTypeInfos = typeInfo.getFieldTypeInfos();
        int index = 0;
        block5: for (Map.Entry entry : structObj.entrySet()) {
            TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(index++);
            JsonElement element = (JsonElement)entry.getValue();
            switch (fieldTypeInfo.getOdpsType()) {
                case ARRAY: {
                    JsonElement array = this.jsonParser.parse(element.getAsString());
                    if (array.isJsonNull() || array.isJsonPrimitive() && array.getAsString().equals(this.nullTag)) {
                        values.add(null);
                        continue block5;
                    }
                    values.add(this.transformArray(array.getAsJsonArray(), (ArrayTypeInfo)fieldTypeInfo));
                    continue block5;
                }
                case MAP: {
                    JsonElement map = this.jsonParser.parse(element.getAsString());
                    if (map.isJsonNull() || map.isJsonPrimitive() && map.getAsString().equals(this.nullTag)) {
                        values.add(null);
                        continue block5;
                    }
                    values.add(this.transformMap(map.getAsJsonObject(), (MapTypeInfo)fieldTypeInfo));
                    continue block5;
                }
                case STRUCT: {
                    JsonElement struct = this.jsonParser.parse(element.getAsString());
                    if (struct.isJsonPrimitive() && struct.getAsString().equals(this.nullTag)) {
                        values.add(null);
                        continue block5;
                    }
                    values.add(this.transformStruct(struct.getAsJsonObject(), (StructTypeInfo)fieldTypeInfo));
                    continue block5;
                }
            }
            values.add(this.parseValue(fieldTypeInfo, element.getAsString().getBytes(this.defaultCharset)));
        }
        return new SimpleStruct(typeInfo, values);
    }

    private void setCharset(String charset) {
        if (Util.isIgnoreCharset(charset)) {
            this.charset = null;
            this.defaultCharset = "utf8";
        } else {
            this.charset = charset;
            this.defaultCharset = charset;
        }
    }

    private String getTrimmedString(byte[] v, String charset) throws UnsupportedEncodingException {
        return new String(v, charset).trim();
    }
}

