/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ship.common;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PartitionHelper {
    private Table table;
    private boolean isPartitioned;

    public PartitionHelper(Odps odps, String projectName, String schemaName, String tableName) throws OdpsException {
        this.table = odps.tables().get(projectName, schemaName, tableName);
        this.isPartitioned = this.table.isPartitioned();
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public static String buildSuffix(PartitionSpec ps) {
        if (ps == null) {
            return "";
        }
        String path = "";
        ps.keys().size();
        for (String key : ps.keys()) {
            String val = ps.get(key);
            val = val.replace(':', ';');
            val = val.replace('.', ',');
            path = path + '.' + val;
        }
        return path;
    }

    public List<PartitionSpec> completePartitionSpecs(String partitionSpecLiteral) {
        if (!this.isPartitioned) {
            throw new IllegalArgumentException("ERROR: can not complete PartitionSpecs for an unpartitioned table");
        }
        PartitionSpec ps = partitionSpecLiteral == null ? null : new PartitionSpec(partitionSpecLiteral);
        Map<String, String> filterKV = PartitionHelper.getKV(ps);
        ArrayList<PartitionSpec> partitionSpecs = new ArrayList<PartitionSpec>();
        for (Partition p : this.table.getPartitions()) {
            PartitionSpec parSpec = p.getPartitionSpec();
            Map<String, String> parKV = PartitionHelper.getKV(parSpec);
            if (!PartitionHelper.isSupersetOf(filterKV, parKV)) continue;
            partitionSpecs.add(parSpec);
        }
        return partitionSpecs;
    }

    public List<PartitionSpec> inferPartitionSpecs(String partitionSpecLiteral) throws OdpsException {
        if (!this.isPartitioned) {
            throw new IllegalArgumentException("ERROR: can not infer PartitionSpecs for an unpartitioned table");
        }
        PartitionSpec ps = partitionSpecLiteral == null ? null : new PartitionSpec(partitionSpecLiteral);
        Iterator it = this.table.getPartitionIterator(ps);
        ArrayList<PartitionSpec> partitions = new ArrayList<PartitionSpec>();
        try {
            while (it.hasNext()) {
                partitions.add(((Partition)it.next()).getPartitionSpec());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return partitions;
    }

    private static Map<String, String> getKV(PartitionSpec ps) {
        LinkedHashMap<String, String> kv = new LinkedHashMap<String, String>();
        if (ps != null) {
            for (String key : ps.keys()) {
                kv.put(key, ps.get(key));
            }
        }
        return kv;
    }

    private static boolean isSupersetOf(Map<String, String> x, Map<String, String> y) {
        for (String key : x.keySet()) {
            String expectVal = x.get(key);
            if (expectVal.equals(y.get(key))) continue;
            return false;
        }
        return true;
    }
}

