/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.volume2;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.shell.FilteredFsShell;

public class Volume2Command
extends AbstractCommand {
    public static final String COMMAND_IDENTITY = "vfs";
    private static FilteredFsShell shell = null;
    private String[] args = null;

    public Volume2Command(String commandText, ExecutionContext context) {
        super(commandText, context);
        String[] commandSplits = commandText.split("\\s+");
        this.args = new String[commandSplits.length - 1];
        System.arraycopy(commandSplits, 1, this.args, 0, commandSplits.length - 1);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        Volume2Command.initShell(this.getContext());
        try {
            shell.run(this.args);
            shell.close();
            shell = null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void printUsage(PrintStream out) {
        try {
            new FilteredFsShell(new Configuration()).run(new String[]{"-usage"});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void printCommandUsage(PrintStream out, String cmd, ExecutionContext context) {
        try {
            new FilteredFsShell(new Configuration()).run(new String[]{"-usage", cmd.substring(1)});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Volume2Command parse(String command, ExecutionContext sessionContext) {
        String trimCmd = command.trim().replaceAll("\\s+", " ");
        if (trimCmd.startsWith(COMMAND_IDENTITY) || COMMAND_IDENTITY.equals(trimCmd)) {
            Volume2Command.initShell(sessionContext);
            return new Volume2Command(command, sessionContext);
        }
        return null;
    }

    private static void initShell(final ExecutionContext sessionContext) {
        if (shell == null) {
            shell = new FilteredFsShell(new Configuration(){
                {
                    this.set("odps.access.id", sessionContext.getAccessId());
                    this.set("odps.access.key", sessionContext.getAccessKey());
                    this.set("odps.service.endpoint", sessionContext.getEndpoint());
                    this.set("fs.defaultFS", String.format("odps://%s/", sessionContext.getProjectName()));
                    this.set("fs.odps.impl", "com.aliyun.odps.fs.VolumeFileSystem");
                    this.set("dfs.replication", "3");
                    this.set("fs.AbstractFileSystem.odps.impl", "com.aliyun.odps.fs.VolumeFs");
                    this.set("io.file.buffer.size", "512000");
                    this.set("volume.internal", "false");
                    this.set("pangu.access.check", "false");
                    this.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                }
            });
            if (!StringUtils.isNullOrEmpty((String)sessionContext.getTunnelEndpoint())) {
                shell.getConf().set("odps.tunnel.endpoint", sessionContext.getTunnelEndpoint());
            }
        }
    }
}

