/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.volume2;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.volume2.ExternalVolumeCommand;
import java.io.PrintStream;

public class DeleteExternalVolumeCommand
extends ExternalVolumeCommand {
    public static void printDeleteExternalVolumeUsage(PrintStream out) {
        out.println("");
        out.println("Usage: vfs <-rmv> <volume_path>; remove invalid or illegal external volume.");
    }

    public DeleteExternalVolumeCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        String[] paras = this.getCommandText().split("\\s+");
        if (paras.length != 3) {
            DeleteExternalVolumeCommand.printDeleteExternalVolumeUsage(System.err);
            throw new ODPSConsoleException("Invalid delete external volume command.");
        }
        Odps odps = this.getCurrentOdps();
        String path = paras[2];
        this.rmFile(odps, path);
        this.getWriter().writeError("OK");
    }

    private void rmFile(Odps odps, String path) throws ODPSConsoleException, OdpsException {
        int start = path.startsWith("/") ? 1 : 0;
        String[] sp = path.substring(start).split("/");
        if (sp.length > 1) {
            throw new ODPSConsoleException("Invalid parameters - can not remove file or folder.");
        }
        String vName = sp[0];
        if (StringUtils.isNullOrEmpty((String)vName)) {
            throw new ODPSConsoleException("Invalid parameters - unrecognized option [" + path + "].");
        }
        Project project = odps.projects().get();
        odps.volumes().delete(project.getName(), vName);
    }
}

