/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.auth;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class SetProjectCommand
extends AbstractCommand {
    private String commandText;
    public static final String[] HELP_TAGS = new String[]{"setproject", "set", "project"};
    private int brackets = 0;
    private int quotations = 0;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: setproject <key>=<value> [<key>=<value>]");
    }

    public SetProjectCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
        this.commandText = commandText;
    }

    public void run() throws ODPSConsoleException {
        try {
            Odps odps = this.getCurrentOdps();
            Project project = odps.projects().get();
            if (this.commandText.isEmpty()) {
                Map allProperties = project.getAllProperties();
                if (allProperties != null) {
                    for (Map.Entry property : allProperties.entrySet()) {
                        this.getWriter().writeError((String)property.getKey() + "=" + (String)property.getValue());
                    }
                }
                this.getWriter().writeError("OK");
                return;
            }
            Map<String, String> properties = this.parseProperties();
            odps.projects().updateProject(this.getCurrentProject(), properties);
            this.getWriter().writeError("OK");
        }
        catch (OdpsException e) {
            throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
        }
    }

    public static SetProjectCommand parse(String commandString, ExecutionContext context) {
        if (commandString.toUpperCase().matches("^SETPROJECT\\s*[\\s\\S]*")) {
            return new SetProjectCommand(commandString.substring(10).trim(), context);
        }
        return null;
    }

    public Map<String, String> parseProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(0);
        String input = this.commandText + " ";
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean keyMode = true;
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            if (keyMode) {
                if (c == '=') {
                    keyMode = false;
                    continue;
                }
                if (this.isEndOfProperty(c)) {
                    this.save(properties, key, null);
                    continue;
                }
                key.append(c);
                continue;
            }
            if (this.isEndOfProperty(c) && this.isCompleteProperty()) {
                this.save(properties, key, value);
                keyMode = true;
                continue;
            }
            value.append(c);
            this.updateQuotationsAndBracketsCount(c);
        }
        return properties;
    }

    private boolean isEndOfProperty(char c) {
        return c == '\f' || c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    private boolean isCompleteProperty() {
        return this.brackets == 0 && this.quotations % 2 == 0;
    }

    private void save(Map<String, String> properties, StringBuilder key, StringBuilder value) {
        if (key.length() == 0) {
            return;
        }
        if (value == null) {
            properties.put(key.toString(), "");
            key.setLength(0);
        } else {
            properties.put(key.toString(), value.toString());
            key.setLength(0);
            value.setLength(0);
        }
    }

    private void updateQuotationsAndBracketsCount(char c) {
        if (c == '{' || c == '(') {
            ++this.brackets;
        } else if (c == '}' || c == ')') {
            --this.brackets;
        } else if (c == '\'' || c == '\"') {
            ++this.quotations;
        }
    }
}

