/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.auth;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import java.io.PrintStream;

public class PutSecurityPolicyCommand
extends AbstractCommand {
    private static final String REGEX = "PUT\\s+SECURITY\\s+POLICY\\s+.+";
    public static final String[] HELP_TAGS = new String[]{"PUT", "SECURITY", "POLICY"};
    private String policyPath;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: PUT SECURITY POLICY");
    }

    public PutSecurityPolicyCommand(String policyPath, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.policyPath = policyPath;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        SecurityManager sm = odps.projects().get().getSecurityManager();
        String policy = FileUtil.getStringFromFile((String)this.policyPath);
        sm.putSecurityPolicy(policy);
        this.getWriter().writeError("OK");
    }

    public static PutSecurityPolicyCommand parse(String commandText, ExecutionContext context) {
        if ((commandText = commandText.trim()).toUpperCase().matches(REGEX)) {
            String[] splits = commandText.split("\\s+");
            return new PutSecurityPolicyCommand(splits[3], commandText, context);
        }
        return null;
    }
}

