/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.LanguageTransformProtos;
import apsara.odps.lot.Lot;
import apsara.odps.lot.TransformProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.Language;
import com.aliyun.odps.lot.common.ReferencedURI;
import com.aliyun.odps.lot.common.Resource;
import com.aliyun.odps.lot.common.ScalarExpression;
import com.aliyun.odps.lot.common.Schema;
import com.aliyun.odps.lot.operators.Transform;
import java.util.ArrayList;
import java.util.List;

public class LanguageTransform
extends Transform {
    private String className;
    private List<ReferencedURI> referencedURIs;
    private Language language;

    public String getClassName() {
        return this.className;
    }

    public List<ReferencedURI> getReferencedURIs() {
        return this.referencedURIs;
    }

    public Language getLanguage() {
        return this.language;
    }

    public LanguageTransform(List<ScalarExpression> parameters, List<Resource> resources, Schema schema, String className, List<ReferencedURI> referencedURIs, Language language) {
        super(parameters, resources, schema);
        if (className == null) {
            throw new ArgumentNullException("className");
        }
        this.referencedURIs = referencedURIs == null ? new ArrayList<ReferencedURI>() : referencedURIs;
        this.className = className;
        this.language = language;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 1);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        TransformProtos.Transform.Builder trans = TransformProtos.Transform.newBuilder();
        trans.setId(this.getId());
        trans.setParentId(this.getParents().get(0).getId());
        for (ScalarExpression param : this.getParameters()) {
            trans.addParameters(param.toProtoBuf());
        }
        for (Resource res : this.getResources()) {
            TransformProtos.Transform.Resources.Builder rb = TransformProtos.Transform.Resources.newBuilder();
            rb.setProject(res.getProject());
            rb.setResourceName(res.getName());
            trans.addResources(rb.build());
        }
        LanguageTransformProtos.LanguageTransform.Builder ll = LanguageTransformProtos.LanguageTransform.newBuilder();
        ll.setClassName(this.className);
        for (ReferencedURI uri : this.referencedURIs) {
            ll.addURIs(uri.toProtoBuf());
        }
        ll.setLanguage(this.language.toProtoBuf());
        trans.setLanguageTransform(ll.build());
        trans.setSchema(this.getSchema().toProtoBuf());
        builder.setTransform(trans.build());
        return builder.build();
    }
}

