/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.DataSourceProtos;
import apsara.odps.lot.LanguageSourceProtos;
import apsara.odps.lot.Lot;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.Language;
import com.aliyun.odps.lot.common.ReferencedURI;
import com.aliyun.odps.lot.common.Resource;
import com.aliyun.odps.lot.common.Schema;
import com.aliyun.odps.lot.operators.DataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LanguageSource
extends DataSource {
    private String className;
    private List<Resource> resources;
    private List<ReferencedURI> referencedURIs;
    private Language language;
    private Schema schema;
    private int insCount;
    private Map<String, String> properties = new HashMap<String, String>();

    public String getClassName() {
        return this.className;
    }

    public List<ReferencedURI> getReferencedURIs() {
        return this.referencedURIs;
    }

    public Language getLanguage() {
        return this.language;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getWorkerCount() {
        return this.insCount;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public LanguageSource(Language language, List<Resource> resources, String className, List<ReferencedURI> referencedURIs, Schema schema, int workerCount, Map<String, String> properties) {
        if (className == null) {
            throw new ArgumentNullException("className");
        }
        if (schema.getColumns().size() == 0) {
            throw new ArgumentNullException("schema");
        }
        if (workerCount <= 0) {
            throw new ArgumentNullException("workerCount");
        }
        this.resources = resources == null ? new ArrayList<Resource>() : resources;
        this.referencedURIs = referencedURIs == null ? new ArrayList<ReferencedURI>() : referencedURIs;
        this.properties = properties == null ? new HashMap<String, String>() : properties;
        this.className = className;
        this.language = language;
        this.schema = schema;
        this.insCount = workerCount;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 0);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSourceProtos.DataSource.Builder src = DataSourceProtos.DataSource.newBuilder();
        src.setId(this.getId());
        LanguageSourceProtos.LanguageSource.Builder ls = LanguageSourceProtos.LanguageSource.newBuilder();
        ls.setLanguage(this.language.toProtoBuf());
        for (Resource resource : this.resources) {
            LanguageSourceProtos.LanguageSource.Resources.Builder rb = LanguageSourceProtos.LanguageSource.Resources.newBuilder();
            rb.setProject(resource.getProject());
            rb.setResourceName(resource.getName());
            ls.addResources(rb.build());
        }
        ls.setClassName(this.className);
        for (ReferencedURI referencedURI : this.referencedURIs) {
            ls.addURIs(referencedURI.toProtoBuf());
        }
        ls.setSchema(this.getSchema().toProtoBuf());
        ls.setInstanceCount(this.insCount);
        for (Map.Entry entry : this.properties.entrySet()) {
            LanguageSourceProtos.LanguageSource.Properties.Builder pb = LanguageSourceProtos.LanguageSource.Properties.newBuilder();
            pb.setKey((String)entry.getKey());
            pb.setValue((String)entry.getValue());
            ls.addProperties(pb.build());
        }
        src.setLanguageSource(ls.build());
        builder.setDataSource(src.build());
        return builder.build();
    }
}

