/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.JoinTypeProtos;
import apsara.odps.lot.JoinProtos;
import apsara.odps.lot.Lot;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.IllegalOperationException;
import com.aliyun.odps.lot.common.ScalarExpression;
import com.aliyun.odps.lot.operators.Operator;
import java.util.ArrayList;
import java.util.List;

public class Join
extends Operator {
    private Operator leftParent;
    private Operator rightParent;
    private Type type;
    private ScalarExpression onCondition;
    private ExecutionHint executionHint = ExecutionHint.Auto;
    private List<String> smallParents = new ArrayList<String>();

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 2);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        JoinProtos.Join.Builder j = JoinProtos.Join.newBuilder();
        j.setId(this.getId());
        j.setLeftParentId(this.leftParent.getId());
        j.setRightParentId(this.rightParent.getId());
        switch (this.type) {
            case Inner: {
                j.setJoinType(JoinTypeProtos.JoinType.InnerJoin);
                break;
            }
            case LeftOuter: {
                j.setJoinType(JoinTypeProtos.JoinType.LeftJoin);
                break;
            }
            case RightOuter: {
                j.setJoinType(JoinTypeProtos.JoinType.RightJoin);
                break;
            }
            case FullOuter: {
                j.setJoinType(JoinTypeProtos.JoinType.FullOuterJoin);
                break;
            }
            case CartesianProduct: {
                j.setJoinType(JoinTypeProtos.JoinType.CartesianProduct);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.onCondition != null) {
            j.setOnCondition(this.onCondition.toProtoBuf());
        }
        switch (this.executionHint) {
            case Auto: {
                j.setExeType(JoinProtos.Join.ExecutionType.Auto);
                break;
            }
            case MergeJoin: {
                j.setExeType(JoinProtos.Join.ExecutionType.MergeJoin);
                break;
            }
            case FullHashJoin: {
                j.setExeType(JoinProtos.Join.ExecutionType.FullHashJoin);
                break;
            }
            case ShuffledHashJoin: {
                j.setExeType(JoinProtos.Join.ExecutionType.ShuffledHashJoin);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        j.addAllSmallParents(this.smallParents);
        builder.setJoin(j.build());
        return builder.build();
    }

    public List<String> getSmallParents() {
        return this.smallParents;
    }

    public void setSmallParents(List<String> smallParents) {
        this.smallParents = smallParents;
    }

    public void setExecutionHint(ExecutionHint executionHint) {
        this.executionHint = executionHint;
    }

    public Operator getLeftParent() {
        return this.leftParent;
    }

    public Operator getRightParent() {
        return this.rightParent;
    }

    public Type getType() {
        return this.type;
    }

    public ScalarExpression getOnCondition() {
        return this.onCondition;
    }

    public ExecutionHint getExecutionHint() {
        return this.executionHint;
    }

    public Join(Operator leftParent, Operator rightParent, Type type, ScalarExpression onCondition) throws IllegalOperationException {
        if (leftParent == null) {
            throw new ArgumentNullException("leftParent");
        }
        if (rightParent == null) {
            throw new ArgumentNullException("rightParent");
        }
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        leftParent.addChild(this);
        rightParent.addChild(this);
        this.type = type;
        this.onCondition = onCondition;
    }

    @Override
    protected void onBeAddedAsChild(Operator parent) throws IllegalOperationException {
        super.onBeAddedAsChild(parent);
        if (parent != this.leftParent && parent != this.rightParent) {
            throw new IllegalOperationException("Unknown parent of join operator, it should be one of the parents you set in constructor.");
        }
    }

    public static enum ExecutionHint {
        Auto,
        MergeJoin,
        FullHashJoin,
        ShuffledHashJoin,
        DistributedHashJoin;

    }

    public static enum Type {
        Inner,
        LeftOuter,
        RightOuter,
        FullOuter,
        CartesianProduct;

    }
}

