/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot;

import apsara.odps.lot.Lot;
import apsara.odps.lot.Lottask;
import com.aliyun.odps.FileResource;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.TemporaryFunction;
import com.aliyun.odps.lot.operators.DataSource;
import com.aliyun.odps.lot.operators.Operator;
import com.aliyun.odps.task.LOTTask;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Task {
    private Odps odps;
    private String name;
    private Map<String, String> hints = new HashMap<String, String>();
    private Map<String, String> resourceAliasesForCurrentProject = new HashMap<String, String>();
    private List<DataSource> roots = new ArrayList<DataSource>();
    private Map<String, TemporaryFunction> tmpFunctions = new HashMap<String, TemporaryFunction>();

    public Task(Odps odps, String name) {
        if (odps == null) {
            throw new ArgumentNullException("odps");
        }
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        this.odps = odps;
        this.name = name;
    }

    public void addTemporaryFunction(TemporaryFunction function) {
        if (this.tmpFunctions.containsKey(function.getName())) {
            throw new IllegalArgumentException("You are adding temporary functions with the same name '" + function.getName() + "'.");
        }
        this.tmpFunctions.put(function.getName(), function);
    }

    public void addHint(String key, String value) {
        if (key == null) {
            throw new ArgumentNullException("key");
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        this.hints.put(key, value);
    }

    public void addResourceAliasesForCurrentProject(String source, String alias) {
        if (source == null) {
            throw new ArgumentNullException("source");
        }
        if (alias == null) {
            throw new ArgumentNullException("alias");
        }
        this.resourceAliasesForCurrentProject.put(source, alias);
    }

    public void addRootOperator(DataSource root) {
        if (root == null) {
            throw new ArgumentNullException("root");
        }
        this.roots.add(root);
    }

    public Odps getOdps() {
        return this.odps;
    }

    public String getCurrentProject() {
        return this.odps.getDefaultProject();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public Map<String, String> getResourceAliasesForCurrentProject() {
        return this.resourceAliasesForCurrentProject;
    }

    public List<DataSource> getRoots() {
        return this.roots;
    }

    public Map<String, TemporaryFunction> getTmpFunctions() {
        return this.tmpFunctions;
    }

    public ByteArrayInputStream getTaskInputStream() throws OdpsException {
        this.validateGraph();
        Lottask.LotTask.Builder task = Lottask.LotTask.newBuilder();
        for (Map.Entry<String, String> item : this.hints.entrySet()) {
            task.addEnvironmentBuilder().setKey(item.getKey()).setValue(item.getValue());
        }
        HashSet<Operator> visited = new HashSet<Operator>();
        Lot.LogicalOperatorTree.Builder tree = Lot.LogicalOperatorTree.newBuilder();
        for (Operator operator : this.roots) {
            this.genTree(tree, operator, visited);
        }
        task.setLot(tree.build());
        for (Map.Entry entry : this.tmpFunctions.entrySet()) {
            task.addTempFunctions(((TemporaryFunction)entry.getValue()).toProtoBuf());
        }
        Lottask.LotTask lotTask = task.build();
        System.out.println(lotTask.toString());
        return new ByteArrayInputStream(lotTask.toByteArray());
    }

    public Instance run() throws OdpsException {
        String tmpRes = "lot-" + UUID.randomUUID().toString();
        FileResource res = new FileResource();
        res.setName(tmpRes);
        res.setIsTempResource(true);
        ByteArrayInputStream stream = this.getTaskInputStream();
        this.odps.resources().create(this.odps.getDefaultProject(), res, (InputStream)stream);
        return LOTTask.run((Odps)this.odps, (String)this.getCurrentProject(), (String)tmpRes, (boolean)false, this.getHints(), this.getResourceAliasesForCurrentProject());
    }

    private void genTree(Lot.LogicalOperatorTree.Builder tree, Operator root, Set<Operator> visited) {
        if (!visited.contains(root)) {
            tree.addOperators(root.toProtoBuf());
            visited.add(root);
            for (Operator child : root.getChildren()) {
                this.genTree(tree, child, visited);
            }
        }
    }

    private void validateGraph() throws OdpsException {
        if (this.roots.size() == 0) {
            throw new OdpsException("Invalid LOT task. You have to set one root operator at least for LOT.");
        }
    }
}

