/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import java.io.PrintStream;

public class DropOfflineModelCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"drop", "delete", "kill", "offline", "model", "offlinemodel"};
    private String modelName;
    private boolean ifExists;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: drop offlinemodel [if exists] <offlinemodel_name>");
    }

    public DropOfflineModelCommand(String modelName, String commandString, ExecutionContext sessionContext) {
        super(commandString, sessionContext);
        this.modelName = modelName;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        if (this.isIfExists() && !this.getCurrentOdps().offlineModels().exists(this.modelName)) {
            System.out.println("OK");
            return;
        }
        this.getCurrentOdps().offlineModels().delete(this.modelName);
        System.out.println("OK");
    }

    public static DropOfflineModelCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        boolean ifExists = false;
        if (commandString.toUpperCase().matches("\\s*DROP\\s+OFFLINEMODEL\\s+.*")) {
            String[] temp;
            String line = commandString.trim().replaceAll("\\s+", " ");
            if ((line = line.substring("DROP OFFLINEMODEL ".length()).trim()).toUpperCase().startsWith("IF EXISTS ")) {
                ifExists = true;
                line = line.substring("IF EXISTS ".length()).trim();
            }
            if ((temp = line.split(" ")).length == 1) {
                DropOfflineModelCommand command = new DropOfflineModelCommand(temp[0], commandString, sessionContext);
                command.setIfExists(ifExists);
                return command;
            }
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        return null;
    }

    private boolean isIfExists() {
        return this.ifExists;
    }

    private void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }
}

