/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ml.OfflineModel;
import com.aliyun.odps.ml.OfflineModelInfo;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.xflow.DescribeOfflineModelCommand;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jline.reader.UserInterruptException;

public class CreateOfflineModelCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"create", "offline", "model", "offlinemodel"};
    private String projectName;
    private OfflineModelInfo modelInfo;
    private static Pattern PATTERN = Pattern.compile("\\s*CREATE\\s+OFFLINEMODEL\\s+(.+)", 34);

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: create offlinemodel <offlinemodel_name> -modelPath <model_path> [-arn <oss_role_arn>]");
        stream.println("                           [-type <type> -version <version> -configuration <user_config>]");
        stream.println("       create offlinemodel <offlinemodel_name> -modelPath <model_path> [-arn <oss_role_arn>]");
        stream.println("                           [-process <processor_json>]");
    }

    public CreateOfflineModelCommand(String projectName, OfflineModelInfo modelInfo, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.projectName = projectName;
        this.modelInfo = modelInfo;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        if (odps.offlineModels().exists(this.projectName, this.modelInfo.modelName)) {
            throw new ODPSConsoleException("Offlinemodel already exists : " + this.projectName + "." + this.modelInfo.modelName);
        }
        Instance instance = odps.offlineModels().create(this.projectName, this.modelInfo);
        this.getWriter().writeError("ID = " + instance.getId());
        this.getWriter().writeError(ODPSConsoleUtils.generateLogView((Odps)odps, (Instance)instance, (ExecutionContext)this.getContext()));
        try {
            this.waitForTerminated(instance, 2000L);
        }
        catch (UserInterruptException e) {
            this.getWriter().writeError("Instance running background.");
            this.getWriter().writeError("Use 'kill " + instance.getId() + "' to stop this instance.");
            throw e;
        }
        if (!odps.offlineModels().exists(this.projectName, this.modelInfo.modelName)) {
            throw new ODPSConsoleException("Create offlinemodel error: " + this.projectName + "." + this.modelInfo.modelName);
        }
        OfflineModel model = odps.offlineModels().get(this.projectName, this.modelInfo.modelName);
        DescribeOfflineModelCommand.printModelInfo(this.getWriter(), model);
    }

    private void waitForTerminated(Instance instance, long intervalMs) throws OdpsException {
        try {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (!instance.isTerminated()) {
                Thread.sleep(intervalMs);
                this.getWriter().writeError(sim.format(new Date()) + "\tCreating");
            }
            if (instance.isSuccessful()) {
                this.getWriter().writeError("OK");
            } else {
                for (Map.Entry e : instance.getTaskStatus().entrySet()) {
                    if (((Instance.TaskStatus)e.getValue()).getStatus() == Instance.TaskStatus.Status.FAILED) {
                        throw new OdpsException((String)instance.getTaskResults().get(e.getKey()));
                    }
                    if (((Instance.TaskStatus)e.getValue()).getStatus() == Instance.TaskStatus.Status.SUCCESS) continue;
                    throw new OdpsException((String)e.getKey() + ", Status=" + ((Instance.TaskStatus)e.getValue()).getStatus());
                }
            }
        }
        catch (InterruptedException e) {
            throw new UserInterruptException(e.getMessage());
        }
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("modelPath", true, "user spec oss model path");
        options.addOption("arn", true, "oss rolearn");
        options.addOption("type", true, "model type:[tensorflow, caffe, mxnet, ...], builtin processor name");
        options.addOption("version", true, "model version, appear with argument 'type'");
        options.addOption("processor", true, "external user spec processor description");
        options.addOption("configuration", true, "user spec configuration for builtin processor");
        return options;
    }

    private static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(CreateOfflineModelCommand.getOptions(), args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  " + e.getMessage(), (Throwable)e);
        }
    }

    public static OfflineModelInfo buildOfflineModelInfo(String cmd, Pattern PATTERN, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        boolean match = m.matches();
        if (!match) {
            return null;
        }
        String input = m.group(1);
        String[] inputs = ODPSConsoleUtils.translateCommandline((String)input);
        CommandLine commandLine = CreateOfflineModelCommand.getCommandLine(inputs);
        OfflineModelInfo modelInfo = new OfflineModelInfo();
        if (!commandLine.hasOption("modelPath")) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. invalid parameter for offlinemodel, please HELP OFFLINEMODEL.");
        }
        modelInfo.modelPath = commandLine.getOptionValue("modelPath");
        if (commandLine.hasOption("arn")) {
            modelInfo.rolearn = commandLine.getOptionValue("arn");
        }
        if (commandLine.hasOption("type") && !commandLine.hasOption("processor")) {
            modelInfo.type = commandLine.getOptionValue("type");
            if (commandLine.hasOption("version")) {
                modelInfo.version = commandLine.getOptionValue("version");
            }
            if (commandLine.hasOption("configuration")) {
                modelInfo.configuration = commandLine.getOptionValue("configuration");
            }
        } else if (commandLine.hasOption("processor") && !commandLine.hasOption("type")) {
            modelInfo.processor = commandLine.getOptionValue("processor");
        } else {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. invalid parameter for offlinemodel, please HELP OFFLINEMODEL.");
        }
        if (commandLine.getArgList().size() != 1) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Model name is ambiguous.");
        }
        String modelName = commandLine.getArgs()[0];
        if (!modelName.matches("[\\w]+")) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Invalid model name.");
        }
        modelInfo.modelName = modelName;
        return modelInfo;
    }

    public static CreateOfflineModelCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        if (cmd == null || ctx == null) {
            return null;
        }
        OfflineModelInfo modelInfo = CreateOfflineModelCommand.buildOfflineModelInfo(cmd, PATTERN, ctx);
        if (modelInfo == null) {
            return null;
        }
        return new CreateOfflineModelCommand(ctx.getProjectName(), modelInfo, cmd, ctx);
    }
}

