/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.xflow;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ml.OfflineModelInfo;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jline.reader.UserInterruptException;

public class CopyOfflineModelCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"copy", "offline", "model", "offlinemodel"};
    private String projectName;
    private OfflineModelInfo modelInfo;
    private static Pattern PATTERN = Pattern.compile("\\s*COPY\\s+OFFLINEMODEL\\s+(.+)", 34);

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: copy offlinemodel -src_model <src_model_name> -dest_model <dest_model_name> ");
        stream.println("                         [-src_project <src_project_name> -dest_project <dest_project_name>]");
    }

    public CopyOfflineModelCommand(String projectName, OfflineModelInfo modelInfo, String cmd, ExecutionContext ctx) {
        super(cmd, ctx);
        this.projectName = projectName;
        this.modelInfo = modelInfo;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        Instance instance = odps.offlineModels().copy(this.projectName, this.modelInfo);
        this.getWriter().writeError("ID = " + instance.getId());
        this.getWriter().writeError(ODPSConsoleUtils.generateLogView((Odps)odps, (Instance)instance, (ExecutionContext)this.getContext()));
        try {
            this.waitForTerminated(instance, 2000L);
        }
        catch (UserInterruptException e) {
            this.getWriter().writeError("Instance running background.");
            this.getWriter().writeError("Use 'kill " + instance.getId() + "' to stop this instance.");
            throw e;
        }
    }

    private void waitForTerminated(Instance instance, long intervalMs) throws OdpsException {
        try {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (!instance.isTerminated()) {
                Thread.sleep(intervalMs);
                this.getWriter().writeError(sim.format(new Date()) + "\tCopying");
            }
            if (instance.isSuccessful()) {
                this.getWriter().writeError("OK");
            } else {
                for (Map.Entry e : instance.getTaskStatus().entrySet()) {
                    if (((Instance.TaskStatus)e.getValue()).getStatus() == Instance.TaskStatus.Status.FAILED) {
                        throw new OdpsException((String)instance.getTaskResults().get(e.getKey()));
                    }
                    if (((Instance.TaskStatus)e.getValue()).getStatus() == Instance.TaskStatus.Status.SUCCESS) continue;
                    throw new OdpsException((String)e.getKey() + ", Status=" + ((Instance.TaskStatus)e.getValue()).getStatus());
                }
            }
        }
        catch (InterruptedException e) {
            throw new UserInterruptException(e.getMessage());
        }
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("src_project", true, "project to copy model from");
        options.addOption("src_model", true, "source model name");
        options.addOption("dest_project", true, "project to copy model into");
        options.addOption("dest_model", true, "destination model name");
        return options;
    }

    private static CommandLine getCommandLine(String[] args) throws ODPSConsoleException {
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(CopyOfflineModelCommand.getOptions(), args);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  " + e.getMessage(), (Throwable)e);
        }
    }

    public static OfflineModelInfo buildOfflineModelInfo(String cmd, Pattern PATTERN, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        boolean match = m.matches();
        if (!match) {
            return null;
        }
        String input = m.group(1);
        String[] inputs = ODPSConsoleUtils.translateCommandline((String)input);
        CommandLine commandLine = CopyOfflineModelCommand.getCommandLine(inputs);
        OfflineModelInfo modelInfo = new OfflineModelInfo();
        if (commandLine.hasOption("src_project")) {
            modelInfo.srcProject = commandLine.getOptionValue("src_project");
        }
        if (commandLine.hasOption("dest_project")) {
            modelInfo.destProject = commandLine.getOptionValue("dest_project");
        }
        if (!commandLine.hasOption("src_model")) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. invalid parameter for offlinemodel, please HELP OFFLINEMODEL.");
        }
        modelInfo.srcModel = commandLine.getOptionValue("src_model");
        if (!commandLine.hasOption("dest_model")) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. invalid parameter for offlinemodel, please HELP OFFLINEMODEL.");
        }
        modelInfo.destModel = commandLine.getOptionValue("dest_model");
        modelInfo.modelName = "";
        modelInfo.modelPath = "";
        return modelInfo;
    }

    public static CopyOfflineModelCommand parse(String cmd, ExecutionContext ctx) throws ODPSConsoleException {
        if (cmd == null || ctx == null) {
            return null;
        }
        OfflineModelInfo modelInfo = CopyOfflineModelCommand.buildOfflineModelInfo(cmd, PATTERN, ctx);
        if (modelInfo == null) {
            return null;
        }
        return new CopyOfflineModelCommand(ctx.getProjectName(), modelInfo, cmd, ctx);
    }
}

