/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

public class WhoamiCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"whoami", "who"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: whoami");
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        SecurityManager sm = odps.projects().get().getSecurityManager();
        String result = sm.runQuery(this.getCommandText(), Boolean.valueOf(false));
        this.cOutWhoami(result);
    }

    protected void cOutWhoami(String jsonResult) throws ODPSConsoleException {
        try {
            JsonObject js = new JsonParser().parse(jsonResult).getAsJsonObject();
            if (js.has("DisplayName")) {
                this.getWriter().writeResult("Name: " + js.get("DisplayName").getAsString());
            }
            if (js.has("SourceIP")) {
                this.getWriter().writeResult("Source IP: " + js.get("SourceIP").getAsString());
            }
            if (js.has("VpcId")) {
                this.getWriter().writeResult("VPC ID: " + js.get("VpcId").getAsString());
            }
            this.getWriter().writeResult("End_Point: " + this.getContext().getEndpoint());
            if (!StringUtils.isBlank((String)this.getContext().getTunnelEndpoint())) {
                this.getWriter().writeResult("Tunnel_End_Point: " + this.getContext().getTunnelEndpoint());
            }
            this.getWriter().writeResult("Project: " + this.getContext().getProjectName());
            if (this.getContext().isSchemaMode()) {
                this.getWriter().writeResult("Schema: " + ODPSConsoleUtils.getDisplaySchema((ExecutionContext)this.getContext()));
            }
        }
        catch (JsonParseException e) {
            throw new ODPSConsoleException("parse whoami error:" + e.getMessage());
        }
    }

    public WhoamiCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public static WhoamiCommand parse(String commandString, ExecutionContext sessionContext) {
        if (commandString.trim().toUpperCase().equals("WHOAMI")) {
            return new WhoamiCommand(commandString, sessionContext);
        }
        return null;
    }
}

