/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.common.CommandUtils;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.LogUtil;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import com.aliyun.openservices.odps.console.utils.PluginUtil;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class DescribeTableCommand
extends AbstractCommand {
    private Coordinate coordinate;
    private boolean isExtended;
    private static List<String> reservedPrintFields = null;
    public static final String[] HELP_TAGS = new String[]{"describe", "desc", "extended", "table"};
    private static final String EXTENDED_GROUP = "extended";
    private static Pattern PATTERN;

    public static void printUsage(PrintStream stream, ExecutionContext ctx) {
        stream.println("Usage:");
        if (ctx.isProjectMode()) {
            stream.println("  describe|desc [extended] [<project name>.]<table name> [partition(<partition spec>)];");
            stream.println("Examples:");
            stream.println("  desc my_table;");
            stream.println("  desc my_table partition(foo='bar');");
            stream.println("  desc extended my_table;");
            stream.println("  desc my_project.my_table;");
        } else {
            stream.println("  describe|desc [extended] [[<project name>.]<schema name>.]<table name> [partition(<partition spec>)];");
            stream.println("Examples:");
            stream.println("  desc my_table;");
            stream.println("  desc my_table partition(foo='bar');");
            stream.println("  desc extended my_table;");
            stream.println("  desc my_schema.my_table;");
            stream.println("  desc my_project.my_schema.my_table;");
        }
    }

    public DescribeTableCommand(String cmd, ExecutionContext cxt, Coordinate coordinate, boolean isExtended) {
        super(cmd, cxt);
        this.coordinate = coordinate;
        this.isExtended = isExtended;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        String result;
        this.coordinate.interpretByCtx(this.getContext());
        String project = this.coordinate.getProjectName();
        String schema = this.coordinate.getSchemaName();
        String table = this.coordinate.getObjectName();
        String partition = this.coordinate.getPartitionSpec();
        boolean isExternalProject = false;
        try {
            Odps odps = OdpsConnectionFactory.createOdps((ExecutionContext)this.getContext());
            String propStr = odps.projects().get(this.coordinate.getProjectName()).getAllProperties().getOrDefault("external_project_properties", "{}");
            Map props = (Map)new GsonBuilder().create().fromJson(propStr, Map.class);
            isExternalProject = props.getOrDefault("isExternalCatalogBound", false);
        }
        catch (Exception e) {
            LogUtil.sendFallbackLog((ExecutionContext)this.getContext(), (String)this.getCommandText(), (String)"get external project properties failed", (Exception)e);
        }
        if (isExternalProject) {
            try {
                Class commandClass = CommandParserUtils.getClassFromPlugin((String)"com.aliyun.openservices.odps.console.QueryCommand");
                Method parseMethod = commandClass.getDeclaredMethod("parse", String.class, ExecutionContext.class);
                Object commandObject = parseMethod.invoke(null, this.getCommandText(), this.getContext());
                ((AbstractCommand)commandObject).execute();
            }
            catch (Exception e) {
                LogUtil.sendFallbackLog((ExecutionContext)this.getContext(), (String)this.getCommandText(), (String)"show tables in sql", (Exception)e);
            }
            return;
        }
        if (table == null || table.length() == 0) {
            throw new OdpsException("ODPS-0903004: Invalid syntax - DESCRIBE|DESC [EXTENDED] table_name [PARTITION(partition_col = 'partition_col_value';");
        }
        DefaultOutputWriter writer = this.getContext().getOutputWriter();
        Odps odps = this.getCurrentOdps();
        Table t = odps.tables().get(project, schema, table);
        writer.writeResult("");
        if (partition == null) {
            t.reload();
            result = this.getScreenDisplay(t, null);
        } else {
            if (partition.trim().length() == 0) {
                throw new OdpsException("ODPS-0903004: Invalid partition key.");
            }
            Partition meta = t.getPartition(new PartitionSpec(partition));
            meta.reload();
            result = this.getScreenDisplay(t, meta);
        }
        writer.writeResult(result);
        System.out.flush();
        writer.writeError("OK");
    }

    public static DescribeTableCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        if (!m.matches()) {
            return null;
        }
        boolean extended = m.group(EXTENDED_GROUP) != null;
        Coordinate coordinate = Coordinate.getTableCoordinate((Matcher)m, (ExecutionContext)cxt);
        return new DescribeTableCommand(cmd, cxt, coordinate, extended);
    }

    private String getScreenDisplay(Table t, Partition meta) throws ODPSConsoleException {
        return this.getBasicScreenDisplay(t, meta) + this.getExtendedScreenDisplay(t, meta);
    }

    private String getSpace(int len) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private String getBasicScreenDisplay(Table t, Partition meta) throws ODPSConsoleException {
        StringWriter out = new StringWriter();
        PrintWriter w = new PrintWriter(out);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (meta != null) {
                w.println("+------------------------------------------------------------------------------------+");
                w.printf("| PartitionSize: %-67d |\n", meta.getSize());
                w.println("+------------------------------------------------------------------------------------+");
                w.printf("| CreateTime:               %-56s |\n", df.format(meta.getCreatedTime()));
                w.printf("| LastDDLTime:              %-56s |\n", df.format(meta.getLastMetaModifiedTime()));
                w.printf("| LastModifiedTime:         %-56s |\n", df.format(meta.getLastDataModifiedTime()));
                if (meta.getLastDataAccessTime() != null) {
                    w.printf("| LastAccessTime:           %-56s |\n", df.format(meta.getLastDataAccessTime()));
                }
                w.println("+------------------------------------------------------------------------------------+");
            } else {
                w.println("+------------------------------------------------------------------------------------+");
                w.printf("| Owner:                    %-56s |\n", t.getOwner());
                w.printf("| Project:                  %-56s |\n", t.getProject());
                if (this.getContext().isSchemaMode()) {
                    w.printf("| Schema:                   %-56s |\n", t.getSchemaName());
                }
                w.printf("| TableComment: %-68s |\n", t.getComment());
                w.println("+------------------------------------------------------------------------------------+");
                w.printf("| CreateTime:               %-56s |\n", df.format(t.getCreatedTime()));
                w.printf("| LastDDLTime:              %-56s |\n", df.format(t.getLastMetaModifiedTime()));
                w.printf("| LastModifiedTime:         %-56s |\n", df.format(t.getLastDataModifiedTime()));
                if (t.getLastDataAccessTime() != null) {
                    w.printf("| LastAccessTime:           %-56s |\n", df.format(t.getLastDataAccessTime()));
                }
                if (t.getLife() != -1L) {
                    w.printf("| Lifecycle:                %-56d |\n", t.getLife());
                }
                if (t.getHubLifecycle() != -1L) {
                    w.printf("| HubLifecycle:             %-56d |\n", t.getHubLifecycle());
                }
                w.println("+------------------------------------------------------------------------------------+");
                if (!StringUtils.isNullOrEmpty((String)t.getMaxLabel())) {
                    w.printf("| TableLabel:               %-56s |\n", t.getTableLabel());
                    w.printf("| MaxLabel:                 %-56s |\n", t.getMaxLabel());
                    w.println("+------------------------------------------------------------------------------------+");
                }
                if (this.isExtended && !StringUtils.isNullOrEmpty((String)t.getMaxExtendedLabel())) {
                    w.printf("| TableExtendedLabel:       %-56s |\n", CollectionUtils.isEmpty((Collection)t.getTableExtendedLabels()) ? " " : StringUtils.join((Object[])t.getTableExtendedLabels().toArray(), (String)","));
                    w.printf("| MaxExtendedLabel:         %-56s |\n", t.getMaxExtendedLabel());
                    w.println("+------------------------------------------------------------------------------------+");
                }
                if (t.isExternalTable()) {
                    w.println("| ExternalTable: YES                                                                 |");
                } else if (t.isVirtualView()) {
                    w.println("| VirtualView  : YES                                                                 |");
                    w.printf("| ViewText: %-72s |\n", t.getViewText());
                } else if (t.isMaterializedView()) {
                    w.println("| MaterializedView: YES                                                              |");
                    w.printf("| ViewText: %-72s |\n", t.getViewText());
                    w.printf("| Rewrite Enabled: %-65s |\n", t.isMaterializedViewRewriteEnabled());
                    w.printf("| AutoRefresh Enabled: %-61s |\n", t.isAutoRefreshEnabled());
                    if (t.isAutoSubstituteEnabled() != null) {
                        w.printf("| AutoSubstitute Enabled: %-58s |\n", t.isAutoSubstituteEnabled());
                    }
                    if (t.getRefreshInterval() != null) {
                        w.printf("| Refresh Interval Minutes: %-56s |\n", t.getRefreshInterval());
                    }
                    if (t.getRefreshCron() != null) {
                        w.printf("| Refresh Cron: %-68s |\n", t.getRefreshCron());
                    }
                } else if (t.isObjectTable()) {
                    w.printf("| ObjectTable: YES        | Size: %-50d |\n", t.getSize());
                } else {
                    w.printf("| InternalTable: YES      | Size: %-50d |\n", t.getSize());
                }
                w.println("+------------------------------------------------------------------------------------+");
                w.println("| Native Columns:                                                                    |");
                w.println("+------------------------------------------------------------------------------------+");
                String columnFormat = this.isExtended ? "| %-8s | %-6s | %-5s | %-13s | %-8s | %-12s | %-12s |\n" : "| %-15s | %-10s | %-5s | %-43s |\n";
                String columnHeader = this.isExtended ? String.format(columnFormat, "Field", "Type", "Label", "ExtendedLabel", "Nullable", "DefaultValue", "Comment") : String.format(columnFormat, "Field", "Type", "Label", "Comment");
                w.printf(columnHeader, new Object[0]);
                w.println("+------------------------------------------------------------------------------------+");
                for (Column c : t.getSchema().getColumns()) {
                    String labelOutput = "";
                    if (c.getCategoryLabel() != null) {
                        labelOutput = c.getCategoryLabel();
                    }
                    if (this.isExtended) {
                        String extendedLabels = "";
                        if (!CollectionUtils.isEmpty((Collection)c.getExtendedlabels())) {
                            extendedLabels = StringUtils.join((Object[])c.getExtendedlabels().toArray(), (String)",");
                        }
                        String defaultValueStr = "NULL";
                        if (c.hasDefaultValue()) {
                            defaultValueStr = c.getDefaultValue();
                        }
                        w.printf(columnFormat, c.getName(), c.getTypeInfo().getTypeName().toLowerCase(), labelOutput, extendedLabels, c.isNullable(), defaultValueStr, c.getComment());
                        continue;
                    }
                    w.printf(columnFormat, c.getName(), c.getTypeInfo().getTypeName().toLowerCase(), labelOutput, c.getComment());
                }
                w.println("+------------------------------------------------------------------------------------+");
                if (t.getSchema().getPartitionColumns().size() > 0) {
                    w.println("| Partition Columns:                                                                 |");
                    w.println("+------------------------------------------------------------------------------------+");
                    for (Column c : t.getSchema().getPartitionColumns()) {
                        w.printf("| %-15s | %-10s | %-51s |\n", c.getName(), c.getTypeInfo().getTypeName().toLowerCase(), c.getComment());
                    }
                    w.println("+------------------------------------------------------------------------------------+");
                }
            }
        }
        catch (Exception e) {
            throw new ODPSConsoleException("ODPS-0903: Invalid table schema.", (Throwable)e);
        }
        w.flush();
        w.close();
        return out.toString();
    }

    private String getExtendedScreenDisplay(Table t, Partition pt) throws ODPSConsoleException {
        if (!this.isExtended || t.isVirtualView()) {
            return "";
        }
        StringWriter out = new StringWriter();
        PrintWriter w = new PrintWriter(out);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            List columnMaskInfo;
            List history;
            boolean isAcid2Table;
            int spaceLength;
            if (pt != null) {
                if (pt.getLifeCycle() != -1L) {
                    w.printf("| LifeCycle:                %-56s |\n", pt.getLifeCycle());
                }
                w.printf("| IsExstore:                %-56s |\n", pt.isExstore());
                w.printf("| IsArchived:               %-56s |\n", pt.isArchived());
                w.printf("| PhysicalSize:             %-56s |\n", pt.getPhysicalSize());
                w.printf("| FileNum:                  %-56s |\n", pt.getFileNum());
                if (!CollectionUtils.isEmpty(reservedPrintFields) && !StringUtils.isNullOrEmpty((String)pt.getReserved())) {
                    JsonObject object = new JsonParser().parse(pt.getReserved()).getAsJsonObject();
                    for (String key : reservedPrintFields) {
                        if (!object.has(key)) continue;
                        spaceLength = Math.max(25 - key.length(), 1);
                        w.printf(String.format("| %s:%-" + spaceLength + "s%-56s |\n", key, " ", object.get(key).getAsString()), new Object[0]);
                    }
                }
                boolean bl = isAcid2Table = t.isTransactional() && t.getPrimaryKey() != null && !t.getPrimaryKey().isEmpty();
                if (pt.getClusterInfo() != null) {
                    this.appendClusterInfo(pt.getClusterInfo(), w);
                }
                if (isAcid2Table) {
                    this.appendAcidInfo(t, pt.getClusterInfo(), w);
                }
                if (pt.getStorageTierInfo() != null) {
                    Date date;
                    if (pt.getStorageTierInfo().getStorageTier() != null) {
                        w.printf("| StorageTier:              %-56s |\n", pt.getStorageTierInfo().getStorageTier().getName());
                    }
                    if ((date = pt.getStorageTierInfo().getStorageLastModifiedTime()) != null) {
                        w.printf("| StorageTierLastModifiedTime:  %-52s |\n", df.format(date));
                    }
                }
                w.println("+------------------------------------------------------------------------------------+");
            } else {
                w.println("| Extended Info:                                                                     |");
                w.println("+------------------------------------------------------------------------------------+");
                if (t.isExternalTable()) {
                    if (!StringUtils.isNullOrEmpty((String)t.getTableID())) {
                        w.printf("| %-20s: %-60s |\n", "TableID", t.getTableID());
                    }
                    if (!StringUtils.isNullOrEmpty((String)t.getStorageHandler())) {
                        w.printf("| %-20s: %-60s |\n", "StorageHandler", t.getStorageHandler());
                    }
                    if (!StringUtils.isNullOrEmpty((String)t.getLocation())) {
                        w.printf("| %-20s: %-60s |\n", "Location", t.getLocation());
                    }
                    if (!StringUtils.isNullOrEmpty((String)t.getResources())) {
                        w.printf("| %-20s: %-60s |\n", "Resources", t.getResources());
                    }
                    if (t.getSerDeProperties() != null) {
                        for (Map.Entry entry : t.getSerDeProperties().entrySet()) {
                            w.printf("| %-20s: %-60s |\n", entry.getKey(), StringEscapeUtils.escapeJava((String)((String)entry.getValue())));
                        }
                    }
                } else if (!t.isVirtualView()) {
                    if (t.isMaterializedView()) {
                        w.printf("| IsOutdated:               %-56s |\n", t.isMaterializedViewOutdated());
                    }
                    if (!StringUtils.isNullOrEmpty((String)t.getTableID())) {
                        w.printf("| TableID:                  %-56s |\n", t.getTableID());
                    }
                    w.printf("| IsArchived:               %-56s |\n", t.isArchived());
                    w.printf("| PhysicalSize:             %-56s |\n", t.getPhysicalSize());
                    w.printf("| FileNum:                  %-56s |\n", t.getFileNum());
                }
                if (!CollectionUtils.isEmpty(reservedPrintFields) && !StringUtils.isNullOrEmpty((String)t.getReserved())) {
                    JsonObject object = new JsonParser().parse(t.getReserved()).getAsJsonObject();
                    for (String key : reservedPrintFields) {
                        if (!object.has(key)) continue;
                        spaceLength = Math.max(25 - key.length(), 1);
                        w.printf(String.format("| %s:%-" + spaceLength + "s%-56s |\n", key, " ", object.get(key).getAsString()), new Object[0]);
                    }
                }
                if (!StringUtils.isNullOrEmpty((String)t.getCryptoAlgoName())) {
                    w.printf("| CryptoAlgoName:           %-56s |\n", t.getCryptoAlgoName());
                }
                boolean bl = isAcid2Table = t.isTransactional() && t.getPrimaryKey() != null && !t.getPrimaryKey().isEmpty();
                if (t.getClusterInfo() != null && !isAcid2Table) {
                    this.appendClusterInfo(t.getClusterInfo(), w);
                }
                if (isAcid2Table) {
                    this.appendAcidInfo(t, t.getClusterInfo(), w);
                }
                if (!t.isPartitioned() && t.getStorageTierInfo() != null) {
                    Date date;
                    if (t.getStorageTierInfo().getStorageTier() != null) {
                        w.printf("| StorageTier:              %-56s |\n", t.getStorageTierInfo().getStorageTier().getName());
                    }
                    if ((date = t.getStorageTierInfo().getStorageLastModifiedTime()) != null) {
                        w.printf("| StorageTierLastModifiedTime:  %-52s |\n", df.format(date));
                    }
                }
                w.println("+------------------------------------------------------------------------------------+");
            }
            if (t.isMaterializedView() && (history = t.getRefreshHistory()) != null && history.size() != 0) {
                w.println("| AutoRefresh History:                                                               |");
                w.println("+------------------------------------------------------------------------------------+");
                String string = "| %-25s | %-10s | %-19s | %-19s |";
                String columnHeader = String.format(string, "InstanceId", "Status", "StartTime", "EndTime");
                w.println(columnHeader);
                w.println("+------------------------------------------------------------------------------------+");
                for (Map map : history) {
                    String id = (String)map.get("InstanceId");
                    String status = (String)map.get("Status");
                    String startTime = CommandUtils.longToDateTime((String)map.get("StartTime"));
                    String endTime = CommandUtils.longToDateTime((String)map.get("EndTime"));
                    String res = String.format(string, id, status, startTime, endTime);
                    w.println(res);
                }
                w.println("+------------------------------------------------------------------------------------+");
            }
            if ((columnMaskInfo = t.getColumnMaskInfo()) != null) {
                w.println("| Data Masking Policy Detail:                                                        |");
                w.println("+------------------------------------------------------------------------------------+");
                w.println("| Column Name               | Policy Name List                                       |");
                w.println("+------------------------------------------------------------------------------------+");
                for (Table.ColumnMaskInfo columnMaskInfoItem : columnMaskInfo) {
                    String name = columnMaskInfoItem.getName();
                    List policyNames = columnMaskInfoItem.getPolicyNameList();
                    for (int i = 0; i < policyNames.size(); ++i) {
                        if (i == 0) {
                            w.printf("| %-25s | %-54s |\n", name, policyNames.get(i));
                            continue;
                        }
                        w.printf("| %-25s | %-54s |\n", "", policyNames.get(i));
                    }
                    w.println("+------------------------------------------------------------------------------------+");
                }
            }
        }
        catch (Exception e) {
            throw new ODPSConsoleException("ODPS-0903: Invalid table schema.", (Throwable)e);
        }
        w.flush();
        w.close();
        return out.toString();
    }

    private void appendAcidInfo(Table table, Table.ClusterInfo clusterInfo, PrintWriter writer) {
        if (table.getPrimaryKey() != null && !table.getPrimaryKey().isEmpty()) {
            writer.printf("| Primarykey:               %-56s |\n", Arrays.toString(table.getPrimaryKey().toArray()));
        }
        if (table.getAcidDataRetainHours() >= 0) {
            writer.printf("| acid.data.retain.hours:   %-56s |\n", table.getAcidDataRetainHours());
        }
        if (clusterInfo.getBucketNum() != -1L) {
            writer.printf("| write.bucket.num:         %-56s |\n", clusterInfo.getBucketNum());
        }
    }

    private void appendClusterInfo(Table.ClusterInfo clusterInfo, PrintWriter w) {
        String cols;
        if (!StringUtils.isNullOrEmpty((String)clusterInfo.getClusterType())) {
            w.printf("| ClusterType:              %-56s |\n", clusterInfo.getClusterType());
        }
        if (clusterInfo.getBucketNum() != -1L) {
            w.printf("| BucketNum:                %-56s |\n", clusterInfo.getBucketNum());
        }
        if (clusterInfo.getClusterCols() != null && !clusterInfo.getClusterCols().isEmpty()) {
            cols = Arrays.toString(clusterInfo.getClusterCols().toArray());
            w.printf("| ClusterColumns:           %-56s |\n", cols);
        }
        if (clusterInfo.getSortCols() != null && !clusterInfo.getSortCols().isEmpty()) {
            cols = Arrays.toString(clusterInfo.getSortCols().toArray());
            w.printf("| SortColumns:              %-56s |\n", cols);
        }
    }

    static {
        try {
            Properties properties;
            String cmd;
            if (reservedPrintFields == null && !StringUtils.isNullOrEmpty((String)(cmd = (properties = PluginUtil.getPluginProperty(DescribeTableCommand.class)).getProperty("reserved_print_fields")))) {
                reservedPrintFields = Arrays.asList(cmd.split(","));
            }
        }
        catch (IOException e) {
            System.err.println("Warning: load config failed, cannot get table reserved print fields.");
            System.err.flush();
        }
        PATTERN = Pattern.compile("\\s*(DESCRIBE|DESC)\\s+(?<extended>EXTENDED\\s+)?" + Coordinate.TABLE_PATTERN, 34);
    }
}

