/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.common;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.utils.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class FileCache {
    private File cacheDir = this.getLocalAppDir();
    private int capacity;

    public FileCache(int capacity) {
        this.capacity = capacity * 1024 * 1024;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream get(Instance inst, String taskName) throws ODPSConsoleException {
        try {
            boolean needLock;
            Map taskStatux = inst.getTaskStatus();
            Instance.TaskStatus taskStatus = (Instance.TaskStatus)taskStatux.get(taskName);
            if (taskStatus == null) {
                throw new ODPSConsoleException("Instance '" + inst.getId() + "' has no such task: " + taskName);
            }
            boolean bl = needLock = !taskStatus.getStatus().equals((Object)Instance.TaskStatus.Status.RUNNING) && !taskStatus.getStatus().equals((Object)Instance.TaskStatus.Status.WAITING);
            if (!needLock) {
                return this.fireOnNet(inst, taskName);
            }
        }
        catch (OdpsException e2) {
            throw new ODPSConsoleException((Throwable)e2);
        }
        String key = inst.getProject() + "-" + inst.getId() + "-" + taskName;
        File file = new File(this.cacheDir, key);
        File lockFile = new File(this.cacheDir, ".lock");
        RandomAccessFile locFile = null;
        FileLock lock = null;
        try {
            lockFile.createNewFile();
            locFile = new RandomAccessFile(lockFile, "rw");
            lock = locFile.getChannel().lock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            FileInputStream in;
            if (lock == null) {
                InputStream inputStream = this.fireOnNet(inst, taskName);
                return inputStream;
            }
            FileInputStream e = in = new FileInputStream(file);
            return e;
        }
        catch (FileNotFoundException e) {
            OutputStream out = null;
            try {
                InputStream in = this.fireOnNet(inst, taskName);
                int contentSize = this.getContentSize();
                if (contentSize > this.capacity) {
                    this.clearCache();
                }
                file.createNewFile();
                FileUtil.saveInputStreamToFile((InputStream)in, (String)file.getPath());
                FileInputStream fileInputStream = new FileInputStream(file);
                return fileInputStream;
            }
            catch (IOException e1) {
                throw new ODPSConsoleException((Throwable)e1);
            }
            catch (Exception e2) {
                throw new ODPSConsoleException((Throwable)e2);
            }
            finally {
                IOUtils.closeQuietly(out);
            }
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException e) {
                throw new ODPSConsoleException((Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)locFile);
            }
        }
    }

    private File getLocalAppDir() {
        File d = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        File dir = d.getParentFile().getParentFile();
        File cacheDirFile = new File(dir, ".CacheFiles");
        cacheDirFile.mkdir();
        return cacheDirFile;
    }

    private int getContentSize() {
        File[] files = this.cacheDir.listFiles();
        long len = 0L;
        for (File f : files) {
            if (!f.isFile()) continue;
            len += f.length();
        }
        return (int)len;
    }

    private void clearCache() {
        for (File f : this.cacheDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().charAt(0) != '.';
            }
        })) {
            if (!f.isFile()) continue;
            f.delete();
        }
    }

    private InputStream fireOnNet(Instance inst, String taskName) throws ODPSConsoleException {
        try {
            return new ByteArrayInputStream(inst.getTaskDetailJson2(taskName).getBytes());
        }
        catch (OdpsException e) {
            throw new ODPSConsoleException((Throwable)e);
        }
    }
}

