/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.unittest;

import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.local.MapOutputBuffer;
import com.aliyun.odps.mapred.unittest.KeyValue;
import com.aliyun.odps.mapred.unittest.LocalRecordComparator;
import com.aliyun.odps.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TaskOutput
extends MapOutputBuffer {
    private Counters counters;
    private Map<Integer, List<KeyValue<Record, Record>>> outputKeyValues = new LinkedHashMap<Integer, List<KeyValue<Record, Record>>>();
    private Map<String, List<Record>> outputs = new HashMap<String, List<Record>>();

    public TaskOutput(JobConf conf, int reduceNum) {
        super(conf, reduceNum);
    }

    public TaskOutput(JobConf job, Pipeline pipeline, String taskId, int reduceCopyNum) {
        super(job, pipeline, taskId, reduceCopyNum);
    }

    public List<KeyValue<Record, Record>> getOutputKeyValues() {
        ArrayList<KeyValue<Record, Record>> list = new ArrayList<KeyValue<Record, Record>>();
        for (Map.Entry<Integer, List<KeyValue<Record, Record>>> entry : this.outputKeyValues.entrySet()) {
            list.addAll((Collection<KeyValue<Record, Record>>)entry.getValue());
        }
        return list;
    }

    public List<KeyValue<Record, Record>> getOutputKeyValues(int reduceId) {
        return this.outputKeyValues.get(reduceId);
    }

    void setOutputKeyValues(int reduceId, List<KeyValue<Record, Record>> outputKeyValues) {
        this.outputKeyValues.put(reduceId, outputKeyValues);
    }

    public List<Record> getOutputRecords() {
        return this.getOutputRecords("__default__");
    }

    public List<Record> getOutputRecords(String label) {
        return this.getOutputRecords(label, true);
    }

    public List<Record> getOutputRecords(boolean sort) {
        return this.getOutputRecords("__default__", sort);
    }

    public List<Record> getOutputRecords(String label, boolean sort) {
        List<Record> records = this.outputs.get(label);
        if (records == null) {
            records = new ArrayList<Record>();
        }
        ArrayList<Record> sortRecords = new ArrayList<Record>(records);
        LocalRecordComparator comparator = new LocalRecordComparator();
        if (sort) {
            Collections.sort(sortRecords, comparator);
        }
        return sortRecords;
    }

    public Counters getCounters() {
        return this.counters;
    }

    void setCounters(Counters counters) {
        this.counters = counters;
    }

    void setOutputRecords(String label, List<Record> records) {
        this.outputs.put(label, records);
    }

    @Override
    public void add(Record key, Record value) {
        int partition = this.getPartition(key);
        this.add(key, value, partition);
    }

    @Override
    public void add(Record key, Record value, int partition) {
        super.add(key, value, partition);
        KeyValue<Record, Record> kv = new KeyValue<Record, Record>(key.clone(), value.clone());
        List<KeyValue<Record, Record>> kvs = this.getOutputKeyValues(partition);
        if (kvs == null) {
            kvs = new ArrayList<KeyValue<Record, Record>>();
            this.outputKeyValues.put(partition, kvs);
        }
        kvs.add(kv);
    }

    @Override
    public void add(Record record, String label) {
        List<Record> records = this.outputs.get(label);
        if (records == null) {
            records = new ArrayList<Record>();
            this.outputs.put(label, records);
        }
        records.add(record.clone());
    }

    @Override
    public long getTotalRecordCount() {
        long numOutputRecords = 0L;
        for (List<Record> records : this.outputs.values()) {
            numOutputRecords += (long)records.size();
        }
        return numOutputRecords + super.getTotalRecordCount();
    }
}

