/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.FileSplit;
import com.aliyun.odps.local.common.JobDirecotry;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.utils.ArchiveUtils;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.local.common.utils.SchemaUtils;
import com.aliyun.odps.mapred.LocalJobRunner;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.TaskContext;
import com.aliyun.odps.mapred.TaskId;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.conf.SessionState;
import com.aliyun.odps.mapred.local.CSVRecordReader;
import com.aliyun.odps.mapred.local.CSVRecordWriter;
import com.aliyun.odps.mapred.local.JobCounter;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.pipeline.Pipeline;
import com.aliyun.odps.utils.ReflectionUtils;
import com.aliyun.odps.volume.FileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LocalTaskContext
implements TaskContext {
    public static final Log LOG = LogFactory.getLog(LocalTaskContext.class);
    protected BridgeJobConf conf;
    private TaskId taskId;
    private final Counters counters;
    protected Map<String, RecordWriter> recordWriters;
    protected Pipeline pipeline;
    protected boolean pipeMode;
    protected int pipeIndex = -1;
    protected Pipeline.TransformNode pipeNode;
    private JobDirecotry jobDirecotry;
    protected int reducerNum = 0;

    public LocalTaskContext(BridgeJobConf conf, TaskId taskid, Counters counters) throws IOException {
        this.conf = conf;
        this.taskId = taskid;
        this.jobDirecotry = new JobDirecotry();
        this.pipeline = Pipeline.fromJobConf((JobConf)conf);
        if (this.pipeline != null) {
            this.pipeMode = true;
            String taskId = this.getTaskID().toString();
            System.err.println("Task ID: " + taskId);
            this.pipeIndex = Integer.parseInt(taskId.split("_")[0].substring(1)) - 1;
            this.pipeNode = this.pipeline.getNode(this.pipeIndex);
        }
        this.reducerNum = this.pipeMode && this.pipeNode != null ? (this.pipeNode.getNextNode() != null ? this.pipeNode.getNextNode().getNumTasks() : (this.pipeIndex > 0 ? this.pipeNode.getNumTasks() : 0)) : conf.getNumReduceTasks();
        this.recordWriters = new HashMap<String, RecordWriter>();
        TableInfo[] output = OutputUtils.getTables((JobConf)conf);
        if (output != null) {
            for (TableInfo info : output) {
                Counter byteCounter;
                Counter recordCounter;
                int reduceNum = conf.getNumReduceTasks();
                if (taskid.isMap() && reduceNum > 0) {
                    Counter emptyCounter;
                    recordCounter = emptyCounter = counters.findCounter((Enum)JobCounter.__EMPTY_WILL_NOT_SHOW);
                    byteCounter = emptyCounter;
                } else {
                    recordCounter = counters.findCounter(JobCounter.class.getName(), String.format("%s_OUTPUT_[%s]_RECORDS", this.taskId.isMap() ? "MAP" : "REDUCE", info));
                    byteCounter = counters.findCounter(JobCounter.class.getName(), String.format("%s_OUTPUT_[%s]_BYTES", this.taskId.isMap() ? "MAP" : "REDUCE", info));
                }
                CSVRecordWriter writer = new CSVRecordWriter(new File(this.jobDirecotry.getOutputDir(info.getLabel()), this.taskId.toString()), recordCounter, byteCounter, WareHouse.getInstance().getInputColumnSeperator());
                this.recordWriters.put(info.getLabel(), writer);
            }
        }
        this.counters = counters;
    }

    public Mapper createMapper() {
        return (Mapper)ReflectionUtils.newInstance(this.getMapperClass(), (Configuration)this.conf);
    }

    public Reducer createReducer() {
        return (Reducer)ReflectionUtils.newInstance(this.getReducerClass(), (Configuration)this.conf);
    }

    public Reducer createCombiner() {
        if (this.getCombinerClass() != null) {
            return (Reducer)ReflectionUtils.newInstance(this.getCombinerClass(), (Configuration)this.conf);
        }
        return null;
    }

    public void closeWriters() throws IOException {
        for (RecordWriter writer : this.recordWriters.values()) {
            writer.close();
        }
    }

    public String[] getGroupingColumns() {
        if (this.pipeMode && this.pipeNode != null) {
            return this.pipeNode.getOutputGroupingColumns();
        }
        return this.conf.getOutputGroupingColumns();
    }

    public Column[] getMapOutputKeySchema() {
        return this.conf.getMapOutputKeySchema();
    }

    public Column[] getMapOutputValueSchema() {
        return this.conf.getMapOutputValueSchema();
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.conf.getMapperClass();
    }

    public int getNumReduceTasks() {
        return this.reducerNum;
    }

    public Class<? extends Reducer> getReducerClass() {
        return this.conf.getReducerClass();
    }

    public Class<? extends Reducer> getCombinerClass() {
        return this.conf.getCombinerClass();
    }

    public Record createOutputRecord() throws IOException {
        return this.createOutputRecord("__default__");
    }

    public Record createOutputRecord(String label) throws IOException {
        return new WritableRecord(this.conf.getOutputSchema(label));
    }

    public Counter getCounter(Enum<?> key) {
        return this.counters.findCounter(key);
    }

    public Counter getCounter(String groupName, String counterName) {
        return this.counters.findCounter(groupName, counterName);
    }

    public TaskId getTaskID() {
        return this.taskId;
    }

    public void progress() {
    }

    public BufferedInputStream readResourceFileAsStream(String name) throws IOException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IOException("Resouce name is empty or null");
        }
        if (!this.jobDirecotry.hasResource(name)) {
            String project = SessionState.get().getOdps().getDefaultProject();
            try {
                WareHouse.getInstance().copyResource(project, name, this.jobDirecotry.getResourceDir(), WareHouse.getInstance().getLimitDownloadRecordCount(), WareHouse.getInstance().getInputColumnSeperator());
            }
            catch (OdpsException odpsException) {
                // empty catch block
            }
        }
        File file = new File(this.jobDirecotry.getResourceDir(), name);
        return new BufferedInputStream(new FileInputStream(file));
    }

    public Iterable<BufferedInputStream> readResourceArchiveAsStream(String resourceName) throws IOException {
        return this.readResourceArchiveAsStream(resourceName, "");
    }

    public Iterable<BufferedInputStream> readResourceArchiveAsStream(String resourceName, String relativePath) throws IOException {
        File resDir;
        if (StringUtils.isEmpty((String)resourceName)) {
            throw new IOException("Resouce name is empty or null");
        }
        File resFile = new File(this.jobDirecotry.getResourceDir(), resourceName);
        if (!this.jobDirecotry.hasResource(resourceName)) {
            String project = SessionState.get().getOdps().getDefaultProject();
            try {
                WareHouse.getInstance().copyResource(project, resourceName, this.jobDirecotry.getResourceDir(), WareHouse.getInstance().getLimitDownloadRecordCount(), WareHouse.getInstance().getInputColumnSeperator());
            }
            catch (OdpsException odpsException) {
                // empty catch block
            }
        }
        if (!(resDir = new File(this.jobDirecotry.getResourceDir(), resourceName + "_decompressed")).exists()) {
            ArchiveUtils.unArchive((File)resFile, (File)resDir);
        }
        final Collection files = LocalRunUtils.listFiles((File)resDir, (String)relativePath.trim());
        return new Iterable<BufferedInputStream>(){

            @Override
            public Iterator<BufferedInputStream> iterator() {
                return new InputStreamIterator(files.iterator());
            }
        };
    }

    public Iterator<Record> readResourceTable(String tbl) throws IOException {
        if (StringUtils.isEmpty((String)tbl)) {
            throw new IOException("Table resouce name is empty or null");
        }
        if (!this.jobDirecotry.hasResource(tbl)) {
            String project = SessionState.get().getOdps().getDefaultProject();
            try {
                WareHouse.getInstance().copyResource(project, tbl, this.jobDirecotry.getResourceDir(), WareHouse.getInstance().getLimitDownloadRecordCount(), WareHouse.getInstance().getInputColumnSeperator());
            }
            catch (OdpsException odpsException) {
                // empty catch block
            }
        }
        File dir = new File(this.jobDirecotry.getResourceDir(), tbl);
        LOG.info((Object)("Reading resource table from " + dir));
        final ArrayList datafiles = new ArrayList();
        LocalRunUtils.listAllDataFiles((File)dir, datafiles);
        final TableMeta tableMeta = SchemaUtils.readSchema((File)dir);
        return new Iterator<Record>(){
            RecordReader reader;
            Record current;
            boolean fetched;

            @Override
            public boolean hasNext() {
                if (this.fetched) {
                    return this.current != null;
                }
                try {
                    this.fetch();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.current != null;
            }

            private void fetch() throws IOException {
                if (this.reader == null) {
                    if (datafiles.isEmpty()) {
                        this.current = null;
                        this.fetched = true;
                        return;
                    }
                    File f = (File)datafiles.remove(0);
                    this.reader = new CSVRecordReader(new FileSplit(f, tableMeta.getCols(), 0L, f.getTotalSpace()), tableMeta, LocalJobRunner.EMPTY_COUNTER, LocalJobRunner.EMPTY_COUNTER, LocalTaskContext.this.counters, WareHouse.getInstance().getInputColumnSeperator());
                    this.current = this.reader.read();
                    this.fetched = true;
                    return;
                }
                this.current = this.reader.read();
                if (this.current == null && !datafiles.isEmpty()) {
                    File f = (File)datafiles.remove(0);
                    this.reader = new CSVRecordReader(new FileSplit(f, tableMeta.getCols(), 0L, f.getTotalSpace()), tableMeta, LocalJobRunner.EMPTY_COUNTER, LocalJobRunner.EMPTY_COUNTER, LocalTaskContext.this.counters, WareHouse.getInstance().getInputColumnSeperator());
                    this.current = this.reader.read();
                    this.fetched = true;
                    return;
                }
                this.fetched = true;
            }

            @Override
            public Record next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.fetched = false;
                return this.current.clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public JobConf getJobConf() {
        return this.conf;
    }

    public Record createMapOutputKeyRecord() {
        if (this.pipeMode && this.pipeNode != null && this.pipeNode.getType().equals("map")) {
            return new WritableRecord(this.pipeNode.getOutputKeySchema());
        }
        return new WritableRecord(this.conf.getMapOutputKeySchema());
    }

    public Record createMapOutputValueRecord() {
        if (this.pipeMode && this.pipeNode != null && this.pipeNode.getType().equals("map")) {
            return new WritableRecord(this.pipeNode.getOutputValueSchema());
        }
        return new WritableRecord(this.conf.getMapOutputValueSchema());
    }

    public TableInfo[] getOutputTableInfo() {
        return OutputUtils.getTables((JobConf)this.conf);
    }

    public Record createOutputKeyRecord() throws IOException {
        if (this.pipeMode && this.pipeNode != null) {
            return new WritableRecord(this.pipeNode.getOutputKeySchema());
        }
        return null;
    }

    public Record createOutputValueRecord() throws IOException {
        if (this.pipeMode && this.pipeNode != null) {
            return new WritableRecord(this.pipeNode.getOutputValueSchema());
        }
        return null;
    }

    public boolean isPipelineMode() {
        return this.pipeMode;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Pipeline.TransformNode getCurrentNode() {
        return this.pipeNode;
    }

    public FileSystem getTempFileSystem() throws IOException {
        return null;
    }

    private static class InputStreamIterator
    implements Iterator<BufferedInputStream> {
        private Iterator<File> files;

        public InputStreamIterator(Iterator<File> files) {
            this.files = files;
        }

        @Override
        public boolean hasNext() {
            return this.files.hasNext();
        }

        @Override
        public BufferedInputStream next() {
            File file = this.files.next();
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("remove Unsupported");
        }
    }
}

