/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.local;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.local.common.FileSplit;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.utils.DownloadUtils;
import com.aliyun.odps.local.common.utils.LocalWritableUtils;
import com.aliyun.odps.local.common.utils.TypeConvertUtils;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.local.JobCounter;
import com.aliyun.odps.type.TypeInfo;
import com.csvreader.CsvReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class CSVRecordReader
implements RecordReader {
    private Object[] value;
    private Counter recordCounter;
    private CsvReader csvReader;
    private FileSplit split;
    private TableMeta tableMeta;
    private Record record;
    private Counters counters;
    public static final Charset encoding = Charset.forName("UTF-8");

    public CSVRecordReader(FileSplit split, TableMeta tableMeta, Counter recordCounter, Counter byteCounter, Counters counters, char inputColumnSeperator) throws IOException {
        this.split = split;
        this.tableMeta = tableMeta;
        this.record = new WritableRecord(split.getSchema());
        File file = split.getFile();
        if (file != null) {
            if (byteCounter != null) {
                byteCounter.increment(file.length());
            }
            this.csvReader = DownloadUtils.newCsvReader((String)file.getAbsolutePath(), (char)inputColumnSeperator, (Charset)encoding);
            this.recordCounter = recordCounter;
        }
        this.counters = counters;
    }

    public Record read() throws IOException {
        int size;
        String[] vals;
        if (this.csvReader == null) {
            return null;
        }
        boolean hasNext = this.csvReader.readRecord();
        if (!hasNext) {
            return null;
        }
        if (this.recordCounter != null) {
            this.recordCounter.increment(1L);
        }
        if ((vals = this.csvReader.getValues()).length != (size = this.split.getSchema().length)) {
            if (this.tableMeta != null) {
                throw new IOException("column num of table '" + this.tableMeta.getProjName() + "." + this.tableMeta.getTableName() + "' not match, expect: " + size + ", but: " + vals.length);
            }
            throw new IOException("column num not match, expect: " + size + ", but: " + vals.length);
        }
        this.value = new Object[size];
        for (int i = 0; i < size; ++i) {
            TypeInfo typeInfo = this.split.getSchema()[i].getTypeInfo();
            this.value[i] = TypeConvertUtils.fromString((TypeInfo)typeInfo, (String)vals[i], (boolean)true);
            this.value[i] = LocalWritableUtils.convert((Object)this.value[i], (TypeInfo)typeInfo);
        }
        this.record.set(this.value);
        this.counters.findCounter((Enum)JobCounter.__EMPTY_INPUT_RECORD_COUNT).increment(1L);
        return this.record;
    }

    public void close() throws IOException {
        if (this.csvReader != null) {
            this.csvReader.close();
        }
    }
}

