/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.util.CostResultParser;
import com.aliyun.odps.task.SQLCostTask;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLCostCommand
extends MultiClusterCommandBase {
    public static final String[] HELP_TAGS = new String[]{"cost", "sql"};
    private static final Pattern PATTERN = Pattern.compile("^COST\\s+SQL(\\s+([\\s\\S]*))?", 2);

    public static void printUsage(PrintStream out) {
        out.println("Usage: cost sql <sqlstatement>");
    }

    public SQLCostCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        String query = this.getCommandText();
        Matcher matcher = PATTERN.matcher(query);
        if (!matcher.matches() || matcher.groupCount() != 2) {
            throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
        }
        query = matcher.group(2);
        String taskName = "console_cost_query_task_" + Calendar.getInstance().getTimeInMillis();
        SQLCostTask task = new SQLCostTask();
        task.setName(taskName);
        task.setQuery(query);
        HashMap taskConfig = QueryUtil.getTaskConfig();
        for (Map.Entry property : taskConfig.entrySet()) {
            task.setProperty((String)property.getKey(), (String)property.getValue());
        }
        this.runJob((Task)task);
    }

    public void writeResult(String queryResult) throws ODPSConsoleException {
        DefaultOutputWriter outputWriter = this.getContext().getOutputWriter();
        queryResult = CostResultParser.parse((String)queryResult, (String)"SQL");
        outputWriter.writeResult(queryResult);
    }

    public static SQLCostCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        String readCommandString = commandString;
        if (PATTERN.matcher(readCommandString).matches()) {
            if (!readCommandString.endsWith(";")) {
                readCommandString = readCommandString + ";";
            }
            return new SQLCostCommand(readCommandString, sessionContext);
        }
        return null;
    }
}

