/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.openservices.odps.console.CSVRecordPrinter;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.HumanReadableRecordPrinter;
import com.aliyun.openservices.odps.console.ODPSConsoleException;

public abstract class RecordPrinter {
    TableSchema schema;
    ExecutionContext context;

    RecordPrinter(TableSchema schema, ExecutionContext context) {
        this.schema = schema;
        this.context = context;
    }

    public static RecordPrinter createReporter(TableSchema schema, ExecutionContext context) {
        if (context.isMachineReadable()) {
            return new CSVRecordPrinter(schema, context);
        }
        return new HumanReadableRecordPrinter(schema, context);
    }

    public abstract void printFrame();

    public abstract void printTitle() throws ODPSConsoleException;

    public abstract void printRecord(Record var1) throws ODPSConsoleException;
}

