/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.mr;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.mapreduce.runtime.MapReduceJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MapReduceCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"mapreduce", "mr", "jar", "openmr"};
    private static final String OPT_CONF = "-conf";
    private static final String OPT_RESOURCES = "-resources";
    private static final String OPT_LIBJARS = "-libjars";
    private static final String OPT_CLASSPATH = "-classpath";
    private static final String OPT_CP = "-cp";
    private static final String OPT_L = "-l";
    private static final String OPT_D = "-D";
    private static final String OPT_X = "-X";
    private static final String OPT_COST = "-cost";
    private static final String TEMP_RESOURCE_PREFIX = "file:";
    private String conf = "";
    private String resources;
    private String libjars;
    private String classpath;
    private boolean localMode;
    private boolean isCostMode;
    private Map<String, List<String>> tempResources = new HashMap<String, List<String>>();
    private List<String> jvmOptions = new ArrayList<String>();
    private String remainderArgs;

    public static void printUsage(PrintStream out) {
        out.println("");
        out.println("Usage: jar [<genericOptions>] <mainClass> args...;");
        out.println("");
        out.println("Generic options supported are");
        out.println("    -conf <configuration file>         application configuration file");
        out.println("    -resources <resource_name_list>    file/archive/table resources used in mapper or reducer");
        out.println("    -libjars <rsource_name_list>       jar resources used in mapper or reducer");
        out.println("    -classpath <local_file_list>       classpaths used to run mainClass");
        out.println("    -l                                 run job in local mode");
        out.println("    -D<prop_name>=<prop_value>         property value pair, which will be used to run mainClass");
        out.println("    -cost                              just return plan cost without running real job");
        out.println("For example:");
        out.println("    jar -conf /home/admin/myconf -resources a.txt -libjars example.jar -classpath ../lib/example.jar:./other_lib.jar -Djava.library.path=./native -Xmx512M mycompany.WordCount -m 10 -r 10 in out;");
        out.println("");
    }

    public MapReduceCommand(String commandText, ExecutionContext context) throws ODPSConsoleException {
        super(commandText, context);
        this.parseGeneralOptions(commandText);
    }

    public String getConf() {
        return this.conf;
    }

    public String getResources() {
        return this.resources;
    }

    public String getLibjars() {
        return this.libjars;
    }

    public List<String> getJvmOptions() {
        return this.jvmOptions;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public String getArgs() {
        return this.remainderArgs;
    }

    public boolean isLocalMode() {
        return this.localMode;
    }

    public boolean isCostMode() {
        return this.isCostMode;
    }

    public Map<String, List<String>> getTempResources() {
        return this.tempResources;
    }

    private void parseGeneralOptions(String commandText) throws ODPSConsoleException {
        try {
            this.internalParseGeneralOptions(commandText);
            if (StringUtils.isBlank((String)this.remainderArgs)) {
                System.err.println("Syntax error: mainClass must be specified");
                MapReduceCommand.printUsage(System.err);
                throw new IllegalArgumentException("mainClass not specified.");
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new ODPSConsoleException("Parse general options error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void internalParseGeneralOptions(String commandText) throws ODPSConsoleException, IOException {
        String[] ss = StringUtils.splitPreserveAllTokens((String)commandText.trim());
        for (int idx = 1; idx < ss.length; ++idx) {
            while (idx < ss.length && ss[idx].isEmpty()) {
                ++idx;
            }
            if (idx >= ss.length) break;
            String token = ss[idx];
            if (token.equalsIgnoreCase(OPT_CONF)) {
                while (++idx < ss.length && ss[idx].isEmpty()) {
                }
                if (idx >= ss.length || !this.isNotOpt(ss[idx])) {
                    throw new IOException("Argument for conf can't be empty");
                }
                this.conf = ss[idx];
                this.validateFiles(this.conf);
                continue;
            }
            if (token.equalsIgnoreCase(OPT_RESOURCES)) {
                while (++idx < ss.length && ss[idx].isEmpty()) {
                }
                if (idx < ss.length && this.isNotOpt(ss[idx])) {
                    this.resources = this.formatSeparator(ss[idx], false);
                    continue;
                }
                throw new IOException("Argument for resources can't be empty");
            }
            if (token.equalsIgnoreCase(OPT_LIBJARS)) {
                while (++idx < ss.length && ss[idx].isEmpty()) {
                }
                if (idx < ss.length && this.isNotOpt(ss[idx])) {
                    this.libjars = this.formatSeparator(ss[idx], true);
                    continue;
                }
                throw new IOException("Argument for libjars can't be empty");
            }
            if (token.equalsIgnoreCase(OPT_CLASSPATH) || token.equalsIgnoreCase(OPT_CP)) {
                while (++idx < ss.length && ss[idx].isEmpty()) {
                }
                if (idx >= ss.length || !this.isNotOpt(ss[idx])) {
                    throw new IOException("Argument for classpath can't be empty");
                }
                this.classpath = this.formatSeparator(ss[idx], false);
                this.classpath = this.validateFiles(this.classpath);
                continue;
            }
            if (token.equals(OPT_L)) {
                this.localMode = true;
                continue;
            }
            if (token.startsWith(OPT_D)) {
                String[] kv = token.substring(OPT_D.length()).split("=", 2);
                if (kv.length == 2) {
                    this.jvmOptions.add(token);
                    continue;
                }
                throw new IOException("Incorrect property: " + token);
            }
            if (token.startsWith(OPT_X)) {
                String xparam = token.substring(OPT_X.length());
                if (xparam.isEmpty()) {
                    throw new IOException("Incorrect -X option, should not be empty");
                }
                this.jvmOptions.add(token);
                continue;
            }
            if (token.startsWith(OPT_COST)) {
                String costParam = token.substring(OPT_COST.length());
                if (!costParam.isEmpty()) {
                    throw new IOException("Incorrect -cost option , remain it just a single flag , no suffix or kv");
                }
                this.isCostMode = true;
                continue;
            }
            if (token.isEmpty()) continue;
            StringBuilder builder = new StringBuilder();
            for (int i = idx; i < ss.length; ++i) {
                if (i != idx) {
                    builder.append(' ');
                }
                builder.append(ss[i]);
            }
            this.remainderArgs = builder.toString();
            break;
        }
    }

    private boolean isNotOpt(String token) {
        return !token.startsWith("-");
    }

    private String validateFiles(String files) throws IOException {
        StringBuffer buf = new StringBuffer();
        String[] fileArr = files.split(",|" + System.getProperty("path.separator"));
        for (int i = 0; i < fileArr.length; ++i) {
            String tmp = fileArr[i].trim();
            if (!new File(tmp).exists()) {
                throw new FileNotFoundException("File or Directory '" + tmp + "' does not exist.");
            }
            if (buf.length() > 0) {
                buf.append(System.getProperty("path.separator"));
            }
            buf.append(tmp);
        }
        return buf.toString();
    }

    private String formatSeparator(String itemlist, boolean isLibjars) throws IOException {
        String[] items;
        if (itemlist == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (String item : items = itemlist.trim().isEmpty() ? new String[]{} : itemlist.trim().split(",")) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            if (item.toLowerCase().startsWith(TEMP_RESOURCE_PREFIX)) {
                URL url = new URL(URLDecoder.decode(item, "utf-8"));
                File tempFile = new File(url.getPath());
                if (!tempFile.exists()) {
                    throw new FileNotFoundException("File or Directory '" + item + "' does not exist.");
                }
                if (tempFile.isDirectory()) {
                    throw new IOException("Temp resource not support directory '" + item + "'");
                }
                ArrayList<String> resInfo = new ArrayList<String>();
                resInfo.add(this.getResourceType(tempFile.getName(), isLibjars));
                resInfo.add(tempFile.getAbsolutePath());
                this.tempResources.put(tempFile.getName(), resInfo);
                buf.append(tempFile.getName());
                continue;
            }
            buf.append(item);
        }
        return buf.toString();
    }

    private String getResourceType(String name, boolean isLibjars) {
        String resNameSuffix = name.toUpperCase();
        if (resNameSuffix.endsWith(".PY")) {
            return "py";
        }
        if (resNameSuffix.endsWith(".JAR")) {
            if (isLibjars) {
                return "jar";
            }
            return "archive";
        }
        if (resNameSuffix.endsWith(".ZIP") || resNameSuffix.endsWith(".TGZ") || resNameSuffix.endsWith(".TAR.GZ") || resNameSuffix.endsWith(".TAR") || resNameSuffix.endsWith(".ZIP")) {
            return "archive";
        }
        return "file";
    }

    public void run() throws OdpsException, ODPSConsoleException {
        String prjName = this.getContext().getProjectName();
        if (prjName == null || prjName.trim().equals("")) {
            throw new OdpsException("Project not be set! ");
        }
        MapReduceJob launcher = null;
        launcher = new MapReduceJob(this);
        launcher.run();
    }

    public static MapReduceCommand parse(String command, ExecutionContext sessionContext) throws ODPSConsoleException {
        String trimCmd = command.trim();
        String jarCmd = trimCmd.replaceAll("\\s+", " ").toLowerCase();
        if (jarCmd.startsWith("jar ") || jarCmd.equals("jar")) {
            return new MapReduceCommand(trimCmd, sessionContext);
        }
        return null;
    }
}

