/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils.tune;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceCost {
    private String formattedString;
    private double cpuValue;
    private double memValue;

    private ResourceCost(String formattedResource, double cpuValue, double memValue) {
        this.formattedString = formattedResource;
        this.cpuValue = cpuValue;
        this.memValue = memValue;
    }

    public static ResourceCost makeUnknownCost(String reason) {
        return new ResourceCost(reason, -1.0, -1.0);
    }

    public static ResourceCost fromText(String text) {
        if (text == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("resource cost: cpu ([\\d\\.]+) Core \\* Min, memory ([\\d\\.]+) GB \\* Min", 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String matchedString = matcher.group(0).replace("resource cost:", "").trim();
            double cpuValue = Double.parseDouble(matcher.group(1));
            double memValue = Double.parseDouble(matcher.group(2));
            return new ResourceCost(matchedString, cpuValue, memValue);
        }
        return ResourceCost.makeUnknownCost("unknown cost from text");
    }

    public String getFormattedString() {
        return this.formattedString;
    }

    public double getCpuValue() {
        return this.cpuValue;
    }

    public double getMemValue() {
        return this.memValue;
    }
}

