/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import java.util.ArrayList;
import java.util.List;

public class RawStringCommandSplitter {
    private final String input;
    private int i = 0;
    private State state;
    private Character quoteType;
    private final StringBuilder commandBuffer;
    private final ArrayList<String> commandResults;
    private final StringBuilder tokenBuffer;
    private final ArrayList<String> tokenResults;
    private boolean parsed;
    private final StringBuilder rawStringDelimiter;
    private RawStringCommandSplitter checkPoint;
    private boolean reset = false;
    private boolean findRawString = false;

    public boolean getFindRawString() {
        return this.findRawString;
    }

    public RawStringCommandSplitter(String input) {
        this.input = input;
        this.state = State.START;
        this.quoteType = null;
        this.commandBuffer = new StringBuilder();
        this.commandResults = new ArrayList();
        this.tokenBuffer = new StringBuilder();
        this.tokenResults = new ArrayList();
        this.parsed = StringUtils.isNullOrEmpty((String)input);
        this.rawStringDelimiter = new StringBuilder();
    }

    private void flushBuffer(StringBuilder buffer, ArrayList<String> results, boolean isTrim) {
        if (buffer.length() > 0) {
            String s = buffer.toString();
            String t = s.trim();
            if (!t.isEmpty()) {
                if (isTrim) {
                    results.add(t);
                } else {
                    results.add(s);
                }
            }
            buffer.setLength(0);
        }
    }

    private void flushTokenBuffer() {
        this.flushBuffer(this.tokenBuffer, this.tokenResults, true);
    }

    private void flushCommandBuffer() {
        this.flushBuffer(this.commandBuffer, this.commandResults, false);
    }

    private void normalSwitch(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                this.state = State.QUOTE;
                this.quoteType = Character.valueOf(c);
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                this.tokenBuffer.append(c);
                break;
            }
            case '-': {
                this.state = State.PRE_COMMENT;
                break;
            }
            case ';': {
                this.state = State.NORMAL;
                this.flushCommandBuffer();
                this.flushTokenBuffer();
                break;
            }
            case '(': 
            case ')': {
                this.state = State.NORMAL;
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                this.tokenResults.add(String.valueOf(c));
                break;
            }
            case '\t': 
            case '\f': 
            case ' ': {
                this.state = State.NORMAL;
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                break;
            }
            case '\n': 
            case '\r': {
                this.state = State.END;
                this.commandBuffer.append(c);
                this.flushTokenBuffer();
                break;
            }
            case 'R': 
            case 'r': {
                if (this.reset) {
                    this.reset = false;
                    this.state = State.NORMAL;
                } else {
                    this.saveState();
                    this.state = State.PRE_RAW_STRING;
                    this.flushTokenBuffer();
                }
                this.commandBuffer.append(c);
                this.tokenBuffer.append(c);
                break;
            }
            default: {
                this.state = State.NORMAL;
                this.commandBuffer.append(c);
                this.tokenBuffer.append(c);
            }
        }
    }

    private void parse() throws ODPSConsoleException {
        while (this.i < this.input.length()) {
            char c = this.input.charAt(this.i);
            block0 : switch (this.state) {
                case START: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            this.commandBuffer.append(c);
                            break block0;
                        }
                        case '#': {
                            this.state = State.COMMENT;
                            break block0;
                        }
                    }
                    this.normalSwitch(c);
                    break;
                }
                case PRE_RAW_STRING: {
                    if (c == '\"' || c == '\'') {
                        this.quoteType = Character.valueOf(c);
                        this.state = State.RAW_STRING_DELIMITER;
                        this.commandBuffer.append(c);
                        this.tokenBuffer.append(c);
                        break;
                    }
                    this.reset = true;
                    this.setState(this.checkPoint);
                    --this.i;
                    break;
                }
                case RAW_STRING_DELIMITER: {
                    this.commandBuffer.append(c);
                    this.tokenBuffer.append(c);
                    if (c == '(') {
                        this.state = State.RAW_STRING;
                        this.flushTokenBuffer();
                    } else {
                        this.rawStringDelimiter.append(c);
                    }
                    if (this.i != this.input.length() - 1) break;
                    this.reset = true;
                    this.setState(this.checkPoint);
                    --this.i;
                    break;
                }
                case RAW_STRING: {
                    String rawStringEnd = ")" + this.rawStringDelimiter.toString() + this.quoteType;
                    int rawStringEndPosition = this.input.indexOf(rawStringEnd, this.i);
                    if (rawStringEndPosition >= 0) {
                        this.commandBuffer.append(this.input, this.i, rawStringEndPosition);
                        this.tokenBuffer.append(this.input, this.i, rawStringEndPosition);
                        this.flushTokenBuffer();
                        this.tokenBuffer.append(rawStringEnd);
                        this.commandBuffer.append(rawStringEnd);
                        this.flushTokenBuffer();
                        this.i = rawStringEndPosition + this.rawStringDelimiter.length() + 1;
                        this.state = State.NORMAL;
                        this.findRawString = true;
                        break;
                    }
                    this.reset = true;
                    this.setState(this.checkPoint);
                    --this.i;
                    break;
                }
                case PRE_COMMENT: {
                    if (c == '-') {
                        this.state = State.COMMENT;
                        this.flushTokenBuffer();
                        break;
                    }
                    this.state = State.NORMAL;
                    this.commandBuffer.append('-');
                    this.tokenBuffer.append('-');
                    --this.i;
                    break;
                }
                case COMMENT: {
                    if (c != '\n' && c != '\r') break;
                    this.commandBuffer.append(c);
                    this.state = State.END;
                    break;
                }
                case END: {
                    if (c != '\n' && c != '\r') {
                        this.state = State.START;
                        --this.i;
                        break;
                    }
                    this.commandBuffer.append(c);
                    break;
                }
                case QUOTE: {
                    this.tokenBuffer.append(c);
                    this.commandBuffer.append(c);
                    if (c == this.quoteType.charValue()) {
                        this.state = State.NORMAL;
                        this.flushTokenBuffer();
                        break;
                    }
                    if (c != '\\') break;
                    this.state = State.ESCAPE;
                    break;
                }
                case ESCAPE: {
                    this.tokenBuffer.append(c);
                    this.commandBuffer.append(c);
                    this.state = State.QUOTE;
                    break;
                }
                case NORMAL: {
                    this.normalSwitch(c);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("impossible thing happened. pos=%s, char='%s'", this.i, Character.valueOf(c)));
                }
            }
            ++this.i;
        }
        switch (this.state) {
            case QUOTE: 
            case ESCAPE: {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help.  string not closed");
            }
            case PRE_RAW_STRING: 
            case RAW_STRING_DELIMITER: 
            case RAW_STRING: {
                this.reset = true;
                this.setState(this.checkPoint);
                this.parse();
                return;
            }
        }
        this.flushTokenBuffer();
        this.flushCommandBuffer();
        this.parsed = true;
    }

    public List<String> getCommands() throws ODPSConsoleException {
        if (!this.parsed) {
            this.parse();
        }
        return this.commandResults;
    }

    public List<String> getTokens() throws ODPSConsoleException {
        if (!this.parsed) {
            this.parse();
        }
        return this.tokenResults;
    }

    private void saveState() {
        RawStringCommandSplitter splitter = new RawStringCommandSplitter(this.input);
        splitter.setState(this);
        this.checkPoint = splitter;
    }

    private void setState(RawStringCommandSplitter splitter) {
        this.i = splitter.i;
        this.state = splitter.state;
        this.quoteType = splitter.quoteType;
        this.commandBuffer.setLength(0);
        this.commandBuffer.append((CharSequence)splitter.commandBuffer);
        this.commandResults.clear();
        this.commandResults.addAll(splitter.commandResults);
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append((CharSequence)splitter.tokenBuffer);
        this.tokenResults.clear();
        this.tokenResults.addAll(splitter.tokenResults);
        this.parsed = splitter.parsed;
        this.rawStringDelimiter.setLength(0);
        this.rawStringDelimiter.append((CharSequence)splitter.rawStringDelimiter);
        this.findRawString = splitter.findRawString;
    }

    static enum State {
        START,
        QUOTE,
        ESCAPE,
        PRE_RAW_STRING,
        RAW_STRING_DELIMITER,
        RAW_STRING,
        NORMAL,
        PRE_COMMENT,
        COMMENT,
        END;

    }
}

