/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.ExtProperties;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.PluginPriorityCommand;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class PluginUtil {
    public static String getRootPath() {
        String path = ODPSConsoleUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path.endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/lib"));
        } else if (path.lastIndexOf("/target") != -1) {
            path = path.substring(0, path.lastIndexOf("/target"));
        }
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public static List<URL> getPluginsJarList() {
        ArrayList<URL> resultList = new ArrayList<URL>();
        String pluginsPath = PluginUtil.getRootPath() + File.separator + "plugins";
        File pluginRoot = new File(pluginsPath);
        if (pluginRoot.exists()) {
            String[] plugins;
            for (String pluginName : plugins = pluginRoot.list()) {
                File[] jars;
                File pluginLib = new File(pluginsPath + File.separator + pluginName + File.separator + "lib");
                if (!pluginLib.isDirectory()) continue;
                for (File jarFile : jars = pluginLib.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && file.getName().toLowerCase().endsWith(".jar");
                    }
                })) {
                    try {
                        resultList.add(new URL("file:///" + jarFile.getAbsolutePath()));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginPriorityCommand> getExtendCommandList() {
        ArrayList<PluginPriorityCommand> commands = new ArrayList<PluginPriorityCommand>();
        String pluginsPath = PluginUtil.getRootPath() + File.separator + "plugins";
        File pluginRoot = new File(pluginsPath);
        if (pluginRoot.exists()) {
            String[] plugins;
            for (String pluginName : plugins = pluginRoot.list()) {
                File pluginIni = new File(pluginsPath + File.separator + pluginName + File.separator + "plugin.ini");
                if (!pluginIni.exists() || !pluginIni.isFile()) continue;
                FileInputStream pis = null;
                try {
                    pis = new FileInputStream(pluginIni);
                    Properties properties = new Properties();
                    properties.load(pis);
                    String c = properties.getProperty("command");
                    PluginUtil.getPriorityCommandFromString(commands, c);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(pis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)pis);
                    continue;
                }
                IOUtils.closeQuietly((InputStream)pis);
            }
        }
        Collections.sort(commands);
        return commands;
    }

    public static void getPriorityCommandFromString(List<PluginPriorityCommand> commands, String commandString) throws Exception {
        try {
            if (commandString != null) {
                String[] parts;
                for (String cmd : parts = commandString.split(",")) {
                    if (cmd.split(":").length == 2) {
                        commands.add(new PluginPriorityCommand(cmd.split(":")[0], Float.parseFloat(cmd.split(":")[1])));
                        continue;
                    }
                    commands.add(new PluginPriorityCommand(cmd, 0.0f));
                }
            }
        }
        catch (NumberFormatException e) {
            throw new Exception("Priority number type error. Float is expected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPluginProperty(Class<?> cls) throws IOException {
        String path = cls.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path.endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/lib"));
        } else if (path.lastIndexOf("/target") != -1) {
            path = path.substring(0, path.lastIndexOf("/target"));
        }
        path = path + "/plugin.ini";
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileInputStream configInputStream = null;
        configInputStream = new FileInputStream(path);
        ExtProperties properties = new ExtProperties();
        try {
            properties.load(configInputStream);
        }
        finally {
            try {
                configInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public static void printPluginCommandPriority() {
        List<PluginPriorityCommand> ecList = CommandParserUtils.getExtendedCommandList();
        StringWriter out = new StringWriter();
        PrintWriter w = new PrintWriter(out);
        w.printf(" %-50s |  %-50s \n", "Command", "Priority");
        w.println("+------------------------------------------------------------------------------------+");
        for (PluginPriorityCommand command : ecList) {
            String commandPath = command.getCommandName();
            String[] splits = commandPath.split("\\.");
            String commandName = splits[splits.length - 1];
            w.printf(" %-50s |  %-50s \n", commandName, Float.valueOf(command.getCommandPriority()));
        }
        w.flush();
        w.close();
        System.out.println(out.toString());
    }

    public class ComparetorByPriority
    implements Comparator<PluginPriorityCommand> {
        @Override
        public int compare(PluginPriorityCommand o1, PluginPriorityCommand o2) {
            if (o1.getCommandPriority() > o2.getCommandPriority()) {
                return 1;
            }
            if (o1.getCommandPriority() == o2.getCommandPriority()) {
                return 0;
            }
            return -1;
        }
    }
}

