/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static void saveInputStreamToFile(InputStream inputStream, String filePath) throws Exception {
        File dwFile = new File(filePath);
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(dwFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = inputStream.read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new OdpsException("\u65e0\u6cd5\u8bfb\u53d6\u5185\u5bb9\u3002", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringFromFile(String fileName) throws ODPSConsoleException {
        String string;
        FileInputStream fis = null;
        try {
            File file = new File(fileName);
            fis = new FileInputStream(file);
            string = com.aliyun.odps.commons.util.IOUtils.readStreamAsString((InputStream)fis);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ODPSConsoleException("File not exist");
                catch (IOException e2) {
                    throw new ODPSConsoleException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return string;
    }

    public static String expandUserHomeInPath(String path) {
        if (path.matches("^~(/|$).*")) {
            return path.replaceFirst("~", System.getProperty("user.home"));
        }
        return path;
    }
}

