/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output.state;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.output.state.InstanceState;
import com.aliyun.openservices.odps.console.output.state.InstanceStateContext;
import com.aliyun.openservices.odps.console.utils.statemachine.State;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class InstanceSuccess
extends InstanceState {
    private static final long MAX_SUMMARY_SIZE = 0x4000000L;

    @Override
    public State run(InstanceStateContext context) throws OdpsException {
        if (context.getExecutionContext().isLiteMode()) {
            return State.END;
        }
        try {
            Instance.TaskSummary taskSummary = InstanceSuccess.getTaskSummaryV1(context.getOdps(), context.getInstance(), context.getTaskStatus().getName(), context.getExecutionContext().getOutputWriter());
            context.setSummary(taskSummary);
            this.reportSummary(taskSummary, context.getExecutionContext().getOutputWriter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return State.END;
    }

    private void reportSummary(Instance.TaskSummary taskSummary, DefaultOutputWriter writer) {
        try {
            if (taskSummary == null || StringUtils.isBlank((String)taskSummary.getSummaryText())) {
                return;
            }
            String summary = taskSummary.getSummaryText().trim();
            writer.writeError("Summary:");
            writer.writeError(summary);
        }
        catch (Exception e) {
            writer.writeError("can not get summary. " + e.getMessage());
        }
    }

    public static Instance.TaskSummary getTaskSummaryV1(Odps odps, Instance i, String taskName, DefaultOutputWriter outputWriter) throws Exception {
        RestClient client = odps.getRestClient();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("summary", null);
        params.put("taskname", taskName);
        String queryString = "/projects/" + i.getProject() + "/instances/" + i.getId();
        Response result = client.request(queryString, "GET", params, null, null);
        String contentLength = result.getHeader("Content-Length");
        if (StringUtils.isNotEmpty((String)contentLength) && Long.parseLong(contentLength) > 0x4000000L) {
            outputWriter.writeError("WARNING: The instance summary is too large, printing the summary is ignored. If you would like to view the summary, please check the logview.");
            return new Instance.TaskSummary();
        }
        Instance.TaskSummary summary = null;
        Item item = (Item)new GsonBuilder().disableHtmlEscaping().create().fromJson(new String(result.getBody()), Item.class);
        if (item.mapReduce != null && !StringUtils.isBlank((String)item.mapReduce.summary)) {
            summary = new Instance.TaskSummary();
            Field textFiled = summary.getClass().getDeclaredField("text");
            textFiled.setAccessible(true);
            textFiled.set(summary, item.mapReduce.summary);
        }
        return summary;
    }

    static class Item {
        public MapReduce mapReduce;

        Item() {
        }
    }

    static class MapReduce {
        String summary;

        MapReduce() {
        }
    }
}

