/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output.state;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.output.state.InstanceProgressReporter;
import com.aliyun.openservices.odps.console.output.state.InstanceState;
import com.aliyun.openservices.odps.console.output.state.InstanceStateContext;
import com.aliyun.openservices.odps.console.output.state.InstanceTerminated;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.SignalUtil;
import com.aliyun.openservices.odps.console.utils.statemachine.State;
import java.util.concurrent.TimeUnit;
import org.jline.reader.UserInterruptException;
import sun.misc.SignalHandler;

public class InstanceRunning
extends InstanceState {
    private static final long STATUS_QUERY_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private long lastUpdate;
    private long firstFailed = -1L;
    private ReporterThread reporter = null;

    private void sleep() {
        long minPeriod = InstanceStateContext.STATUS_QUERY_INTERVAL;
        long costMillis = System.currentTimeMillis() - this.lastUpdate;
        if (costMillis < minPeriod) {
            try {
                Thread.sleep(minPeriod - costMillis);
            }
            catch (InterruptedException e) {
                throw new UserInterruptException("interrupted while thread sleep");
            }
        }
    }

    @Override
    public State run(InstanceStateContext context) throws OdpsException {
        try {
            this.reporter = new ReporterThread(context);
            this.reporter.setDaemon(true);
            this.reporter.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (context.getExecutionContext().isInteractiveMode()) {
            SignalHandler instanceRunningIntSignalHandler = SignalUtil.getInstanceRunningIntSignalHandler(Thread.currentThread());
            SignalUtil.registerSignalHandler("INT", instanceRunningIntSignalHandler);
        }
        try {
            this.polling(context);
        }
        finally {
            if (context.getExecutionContext().isInteractiveMode()) {
                SignalHandler defaultIntSignalHandler = SignalUtil.getDefaultIntSignalHandler(Thread.currentThread());
                SignalUtil.registerSignalHandler("INT", defaultIntSignalHandler);
            }
            this.stopReporter();
        }
        return new InstanceTerminated();
    }

    private void polling(InstanceStateContext context) {
        while (true) {
            Instance.Status status;
            block4: {
                ODPSConsoleUtils.checkThreadInterrupted();
                this.lastUpdate = System.currentTimeMillis();
                status = null;
                try {
                    status = context.getInstance().getStatus(true);
                    this.firstFailed = -1L;
                }
                catch (ReloadException e) {
                    if (this.firstFailed != -1L && System.currentTimeMillis() - this.firstFailed >= STATUS_QUERY_TIMEOUT) {
                        throw e;
                    }
                    context.getExecutionContext().getOutputWriter().writeDebug("Get instance status error: " + e.getMessage());
                    if (this.firstFailed != -1L) break block4;
                    this.firstFailed = System.currentTimeMillis();
                }
            }
            if (status == Instance.Status.TERMINATED) break;
            this.sleep();
        }
        context.setInstanceTerminate();
    }

    private void stopReporter() {
        if (this.reporter != null) {
            try {
                this.reporter.interrupt();
                this.reporter.join(InstanceStateContext.STATUS_QUERY_INTERVAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ReporterThread
    extends Thread {
        private InstanceStateContext context;

        public ReporterThread(InstanceStateContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                InstanceProgressReporter reporter = new InstanceProgressReporter(this.context);
                reporter.report();
            }
            catch (Exception e) {
                this.context.getExecutionContext().getOutputWriter().writeDebug(String.format("%s: %s, %s", "Instance progress reporter error", e.getMessage(), StringUtils.stringifyException((Throwable)e)));
            }
        }
    }
}

