/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output.state;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.output.InPlaceUpdates;
import com.aliyun.openservices.odps.console.output.state.InstanceStateContext;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fusesource.jansi.Ansi;

public class InstanceProgressReporter {
    private static final int NAME_COLUMN_WIDTH = 26;
    private static final int SEPARATOR_WIDTH = 94;
    private static final String SEPARATOR = new String(new char[94]).replace("\u0000", "-");
    private static final String HEADER_FORMAT = "%26s %13s  %5s  %9s  %7s  %7s  %6s";
    private static final String STAGE_FORMAT = "%-26s %13s  %5s  %9s  %7s  %7s  %6s";
    private static final String FOOTER_FORMAT = "%-15s  %-30s %-4s  %-25s";
    private static final String HEADER = String.format("%26s %13s  %5s  %9s  %7s  %7s  %6s", "STAGES", "STATUS", "TOTAL", "COMPLETED", "RUNNING", "PENDING", "BACKUP");
    private static final NumberFormat secondsFormat = new DecimalFormat("#0.00");
    private static final PrintStream out = System.err;
    private static final int progressBarChars = 30;
    private int count = 0;
    private boolean isWarned = false;
    private String taskName;
    private Set<String> completedStageNames = new HashSet<String>();
    private InstanceStateContext context;
    private boolean queueing = true;
    List<Instance.StageProgress> stages = null;

    public InstanceProgressReporter(InstanceStateContext context) {
        this.context = context;
    }

    public void report() {
        this.reportWarnings();
        this.printQueueingMessage();
        while (!this.context.isInstanceTerminate()) {
            try {
                this.taskName = this.context.getRunningTaskName();
                if (!StringUtils.isNullOrEmpty((String)this.taskName)) {
                    this.stages = this.context.getInstance().getTaskProgress(this.taskName);
                    if (this.queueing) {
                        this.reportQueueing();
                    }
                    if (this.stages != null && !this.stages.isEmpty()) {
                        this.context.setTaskProgress(this.stages);
                        this.reportProgress();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ODPSConsoleUtils.checkThreadInterrupted();
        }
    }

    private void reportWarnings() {
        if (!this.isWarned) {
            try {
                this.printSqlWarnings(this.taskName);
            }
            catch (OdpsException odpsException) {
                // empty catch block
            }
            this.isWarned = true;
        }
    }

    private void reportQueueing() throws OdpsException {
        if (this.stages != null && !this.stages.isEmpty()) {
            this.context.setRepositionLines(0);
            this.queueing = false;
            return;
        }
        this.printQueueingMessage();
    }

    private void printSqlWarnings(String taskName) throws OdpsException {
        List warnings = SQLTask.getSqlWarning((Instance)this.context.getInstance(), (String)taskName);
        if (warnings != null && !warnings.isEmpty()) {
            if (InPlaceUpdates.isUnixTerminal() && this.context.getRepositionLines() > 0) {
                InPlaceUpdates.rePositionCursor(out, this.context.getRepositionLines());
                InPlaceUpdates.reprintLine(out, "SQL Warnings:");
            } else {
                this.context.getExecutionContext().getOutputWriter().writeError("SQL Warnings:");
            }
            for (String warning : warnings) {
                this.context.getExecutionContext().getOutputWriter().writeError(warning);
            }
            this.context.setRepositionLines(0);
        }
    }

    private void printQueueingMessage() {
        if (InPlaceUpdates.isUnixTerminal()) {
            int line = this.context.getRepositionLines();
            if (line > 0) {
                InPlaceUpdates.rePositionCursor(out, line);
            }
            String dots = new String(new char[this.count++ % 5 + 1]).replace("\u0000", ".");
            String message = "Job Queueing" + dots;
            InPlaceUpdates.reprintLine(out, message);
            this.context.setRepositionLines(1);
        } else {
            this.context.getExecutionContext().getOutputWriter().writeError("Job Queueing...");
        }
    }

    private void reportProgress() throws OdpsException {
        this.printProgress(false);
    }

    public void printProgress(boolean isTerminate) {
        if (this.context.getTaskProgress() == null || this.context.getTaskProgress().isEmpty()) {
            return;
        }
        List<Instance.StageProgress> stageProgresses = this.context.getTaskProgress();
        if (InPlaceUpdates.isUnixTerminal()) {
            this.printProgressesInPlace(stageProgresses, isTerminate);
        } else {
            this.context.getExecutionContext().getOutputWriter().writeError(this.getProgressFormattedString(stageProgresses, isTerminate));
        }
        this.context.setProgressReportFinish(this.completedStageNames.size() == stageProgresses.size());
    }

    private String getProgressFormattedString(List<Instance.StageProgress> stages, boolean forceComplete) {
        StringBuilder result = new StringBuilder();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = sim.format(new Date());
        result.append(dateString + ' ');
        for (Instance.StageProgress stage : stages) {
            int runningWorkers = forceComplete ? 0 : stage.getRunningWorkers();
            int terminateWorkers = forceComplete ? stage.getTotalWorkers() : stage.getTerminatedWorkers();
            Instance.StageProgress.Status status = forceComplete ? Instance.StageProgress.Status.TERMINATED : this.getStatus(stage);
            result.append(String.format("%s:%s/%s/%s%s%s", stage.getName(), runningWorkers, terminateWorkers, stage.getTotalWorkers(), stage.getBackupWorkers() > 0 ? "(+" + stage.getBackupWorkers() + " backups)" : "", status == null ? "\t" : "[" + status + "]\t"));
            if (status != Instance.StageProgress.Status.TERMINATED || this.completedStageNames.contains(stage.getName())) continue;
            this.completedStageNames.add(stage.getName());
        }
        return result.toString();
    }

    private Instance.StageProgress.Status getStatus(Instance.StageProgress stage) {
        try {
            return stage.getStatus();
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    private void printProgressesInPlace(List<Instance.StageProgress> stageprogresses, boolean forceComplete) {
        StringBuilder reportBuffer = new StringBuilder();
        int sumComplete = 0;
        int sumTotal = 0;
        int idx = 0;
        int maxProgress = stageprogresses.size();
        int lines = this.context.getRepositionLines();
        if (lines > 0) {
            InPlaceUpdates.rePositionCursor(out, lines);
            InPlaceUpdates.resetForward(out);
            lines = 0;
        }
        InPlaceUpdates.reprintLine(out, SEPARATOR);
        ++lines;
        InPlaceUpdates.reprintLineWithColorAsBold(out, HEADER, Ansi.Color.CYAN);
        ++lines;
        for (Instance.StageProgress progress : stageprogresses) {
            ++idx;
            String name = progress.getName();
            int backup = progress.getBackupWorkers();
            int total = progress.getTotalWorkers();
            int all = backup + total;
            int running = forceComplete ? 0 : progress.getRunningWorkers();
            int completed = forceComplete ? all : progress.getTerminatedWorkers();
            int pending = all - completed - running;
            Instance.StageProgress.Status status = forceComplete ? Instance.StageProgress.Status.TERMINATED : this.getStatus(progress);
            String statusString = status != null ? status.toString() : "NULL";
            String nameWithProgress = this.getNameWithProgress(name, completed, total);
            String vertexStr = String.format(STAGE_FORMAT, nameWithProgress, statusString, total, completed, running, pending, backup);
            sumComplete += completed;
            sumTotal += total;
            if (status == Instance.StageProgress.Status.TERMINATED && !this.completedStageNames.contains(name)) {
                this.completedStageNames.add(name);
            }
            reportBuffer.append(vertexStr);
            if (idx == maxProgress) continue;
            reportBuffer.append("\n");
        }
        lines += InPlaceUpdates.reprintMultiLine(out, reportBuffer.toString());
        InPlaceUpdates.reprintLine(out, SEPARATOR);
        ++lines;
        float progress = sumTotal == 0 ? 0.0f : (float)sumComplete / (float)sumTotal;
        String footer = this.getFooter(stageprogresses.size(), this.completedStageNames.size(), progress, this.context.getInstanceStartTime());
        InPlaceUpdates.reprintLineWithColorAsBold(out, footer, Ansi.Color.RED);
        ++lines;
        InPlaceUpdates.reprintLine(out, SEPARATOR);
        this.context.setRepositionLines(++lines);
    }

    private String getFooter(int keySize, int completedSize, float progress, long startTime) {
        String verticesSummary = String.format("STAGES: %02d/%02d", completedSize, keySize);
        String progressBar = this.getInPlaceProgressBar(progress);
        int progressPercent = (int)(progress * 100.0f);
        String progressStr = "" + progressPercent + "%";
        float et = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        String elapsedTime = "ELAPSED TIME: " + secondsFormat.format(et) + " s";
        return String.format(FOOTER_FORMAT, verticesSummary, progressBar, progressStr, elapsedTime);
    }

    private String getInPlaceProgressBar(float percent) {
        int i;
        StringBuilder bar = new StringBuilder("[");
        int remainingChars = 26;
        int completed = (int)((float)remainingChars * percent);
        int pending = remainingChars - completed;
        for (i = 0; i < completed; ++i) {
            bar.append("=");
        }
        bar.append(">>");
        for (i = 0; i < pending; ++i) {
            bar.append("-");
        }
        bar.append("]");
        return bar.toString();
    }

    private String getNameWithProgress(String s, int complete, int total) {
        String result = "";
        if (s != null) {
            float percent = total == 0 ? 0.0f : (float)complete / (float)total;
            int spaceRemaining = 26 - s.length() - 1;
            String trimmedVName = s;
            if (s.length() > 26) {
                trimmedVName = s.substring(0, 25);
                trimmedVName = trimmedVName + "..";
            }
            result = trimmedVName + " ";
            int toFill = (int)((float)spaceRemaining * percent);
            for (int i = 0; i < toFill; ++i) {
                result = result + ".";
            }
        }
        return result;
    }
}

