/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.account.Account;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.util.List;

public class LoginCommand
extends AbstractCommand {
    private static final String OPTION_USER = "-u";
    private static final String OPTION_PASSWORD = "-p";
    private static final String LONG_OPTION_ACCOUNT_PROVIDER = "--account-provider";
    private static final String LONG_OPTION_ACCESS_ID = "--access-id";
    private static final String LONG_OPTION_ACCESS_KEY = "--access-key";
    private static final String LONG_OPTION_STS_TOKEN = "--sts-token";
    private Account.AccountProvider accountProvider;
    private String accessId;
    private String accessKey;
    private String stsToken;

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setStsToken(String stsToken) {
        this.stsToken = stsToken;
    }

    public LoginCommand(Account.AccountProvider accountProvider, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.accountProvider = accountProvider;
    }

    public LoginCommand(String accessId, String accessKey, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.accountProvider = Account.AccountProvider.ALIYUN;
        this.accessId = accessId;
        this.accessKey = accessKey;
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        if (this.accessId != null) {
            this.getContext().setAccessId(this.accessId);
        }
        if (this.accessKey != null) {
            this.getContext().setAccessKey(this.accessKey);
        }
        if (this.accountProvider != null) {
            this.getContext().setAccountProvider(this.accountProvider);
        }
        if (this.stsToken != null) {
            this.getContext().setStsToken(this.stsToken);
        }
    }

    public static LoginCommand parse(List<String> optionList, ExecutionContext sessionContext) throws ODPSConsoleException {
        LoginCommand command;
        if (optionList.contains(OPTION_USER) && optionList.contains(OPTION_PASSWORD) && optionList.indexOf(OPTION_USER) + 1 < optionList.size() && optionList.indexOf(OPTION_PASSWORD) + 1 < optionList.size()) {
            String uPara = optionList.get(optionList.indexOf(OPTION_USER) + 1);
            String pPara = optionList.get(optionList.indexOf(OPTION_PASSWORD) + 1);
            if (uPara.startsWith("-") || pPara.startsWith("-")) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. ");
            }
            command = new LoginCommand(uPara, pPara, null, sessionContext);
            optionList.remove(optionList.indexOf(OPTION_USER));
            optionList.remove(optionList.indexOf(OPTION_PASSWORD));
            optionList.remove(optionList.indexOf(uPara));
            optionList.remove(optionList.indexOf(pPara));
        } else {
            String accountProviderStr = ODPSConsoleUtils.shiftOption(optionList, LONG_OPTION_ACCOUNT_PROVIDER);
            if (accountProviderStr == null) {
                return null;
            }
            Account.AccountProvider accountProvider = Account.AccountProvider.valueOf((String)accountProviderStr.toUpperCase());
            command = new LoginCommand(accountProvider, null, sessionContext);
            switch (accountProvider) {
                case ALIYUN: {
                    String accessId = ODPSConsoleUtils.shiftOption(optionList, LONG_OPTION_ACCESS_ID);
                    String accessKey = ODPSConsoleUtils.shiftOption(optionList, LONG_OPTION_ACCESS_KEY);
                    if (accessId == null || accessKey == null) {
                        String errMsg = "Aliyun account requires accessKeyId and accessKeySecret.";
                        throw new ODPSConsoleException(errMsg);
                    }
                    command.setAccessId(accessId);
                    command.setAccessKey(accessKey);
                    break;
                }
                case STS: {
                    String accessId = ODPSConsoleUtils.shiftOption(optionList, LONG_OPTION_ACCESS_ID);
                    String accessKey = ODPSConsoleUtils.shiftOption(optionList, LONG_OPTION_ACCESS_KEY);
                    String stsToken = ODPSConsoleUtils.shiftOption(optionList, LONG_OPTION_STS_TOKEN);
                    if (accessId == null || accessKey == null || stsToken == null) {
                        String errMsg = "STS account requires accessKeyId, accessKeySecret and STS token";
                        throw new ODPSConsoleException(errMsg);
                    }
                    command.setAccessId(accessId);
                    command.setAccessKey(accessKey);
                    command.setStsToken(stsToken);
                    break;
                }
                default: {
                    throw new ODPSConsoleException("Unsupported account provider.");
                }
            }
        }
        return command;
    }
}

