/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.OdpsConnectionFactory;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractCommand {
    private ExecutionContext context;
    private String commandText;
    int commandStep = -1;
    public static final String[] HELP_TAGS = new String[0];

    public int getCommandStep() {
        return this.commandStep;
    }

    public void setCommandStep(int commandStep) {
        this.commandStep = commandStep;
    }

    public AbstractCommand(String commandText, ExecutionContext context) {
        this.context = context;
        this.commandText = commandText;
    }

    protected abstract void run() throws OdpsException, ODPSConsoleException;

    public void execute() throws OdpsException, ODPSConsoleException {
        block6: {
            String clzName = this.getClass().getSimpleName();
            String hook = ExecutionContext.commandBeforeHook.get(clzName);
            if (hook != null) {
                if (this.getContext().isDebug()) {
                    this.getWriter().writeError("before hook of command " + clzName + ": " + hook);
                }
                try {
                    Constructor<? extends AbstractCommand> c = CommandParserUtils.getClassFromPlugin(hook).getConstructor(String.class, ExecutionContext.class);
                    AbstractCommand cmd = c.newInstance(this.getCommandText(), this.getContext());
                    if (this.getContext().isDebug()) {
                        this.getWriter().writeError("invoking hook: " + hook);
                    }
                    cmd.execute();
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    if (!this.getContext().isDebug()) break block6;
                    e.printStackTrace();
                }
            }
        }
        if (this.getContext().isDebug()) {
            this.getWriter().writeError("invoking command: " + this.getClass().getName());
        }
        this.run();
    }

    public ExecutionContext getContext() {
        assert (this.context != null);
        return this.context;
    }

    public String getCommandText() {
        return this.commandText;
    }

    public DefaultOutputWriter getWriter() {
        ExecutionContext context = this.getContext();
        return context.getOutputWriter();
    }

    public String getCurrentProject() throws ODPSConsoleException {
        ExecutionContext context = this.getContext();
        if (context == null) {
            throw new ODPSConsoleException("ExecutionContext not be set! ");
        }
        String project = context.getProjectName();
        if (project == null || "".equals(project.trim())) {
            throw new ODPSConsoleException("Project not be set! ");
        }
        return project;
    }

    public Odps getCurrentOdps() throws ODPSConsoleException {
        return OdpsConnectionFactory.createOdps(this.getContext());
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    public static void printUsage(PrintStream stream) {
        stream.println("This command have no help info");
    }
}

