/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ODPSConsole {
    public static void main(String[] args) throws ODPSConsoleException {
        String[] commandArgs = CommandParserUtils.getCommandArgs(args);
        ArrayList<String> options = new ArrayList<String>();
        String config = ODPSConsole.prepareOptions(commandArgs, options);
        ExecutionContext sessionContext = ExecutionContext.load(config);
        ODPSConsole.checkSDKEnviron();
        DefaultOutputWriter writer = sessionContext.getOutputWriter();
        writer.writeDebug("ODPSConsole Start");
        try {
            System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
            AbstractCommand oa = CommandParserUtils.parseOptions(config == null ? commandArgs : options.toArray(new String[0]), sessionContext);
            oa.execute();
        }
        catch (OdpsException e) {
            writer.writeError("FAILED: " + e.getMessage());
            if (StringUtils.isNullOrEmpty((String)e.getMessage())) {
                writer.writeError(StringUtils.stringifyException((Throwable)e));
            }
            writer.writeDebug(e);
            System.exit(1);
        }
        catch (ODPSConsoleException e) {
            writer.writeError("FAILED: " + e.getMessage());
            if (StringUtils.isNullOrEmpty((String)e.getMessage())) {
                writer.writeError(StringUtils.stringifyException((Throwable)e));
            }
            writer.writeDebug(e);
            System.exit(e.getExitCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        sessionContext.getOutputWriter().writeDebug("ODPSConsole End");
        System.exit(0);
    }

    private static void checkSDKEnviron() {
        String classpath = System.getProperty("java.class.path");
        String[] classpathEntries = classpath.split(File.pathSeparator);
        long count = 0L;
        for (String line : classpathEntries) {
            if (!line.contains("odps-sdk-core") || line.contains("odps-sdk-core-internal")) continue;
            ++count;
        }
        if (count > 1L) {
            System.err.println("WARNING: detected sdk conflict in console lib folder. Please install console in a fresh new folder.");
        }
    }

    protected static String prepareOptions(String[] args, List<String> options) {
        String config = null;
        for (String option : args) {
            if (option.indexOf("--config") == 0) {
                String[] configOptions = option.split("=", 2);
                if (configOptions.length == 2) {
                    config = configOptions[1];
                    continue;
                }
                System.err.println("FAILED: pls set config correctly.");
                System.exit(1);
                continue;
            }
            options.add(option);
        }
        return config;
    }
}

