/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.aggregators;

import com.aliyun.odps.graph.Aggregator;
import com.aliyun.odps.graph.WorkerContext;
import com.aliyun.odps.graph.aggregators.LongAvgValue;
import com.aliyun.odps.io.LongWritable;
import java.io.IOException;

public class LongAvgAggregator
extends Aggregator<LongAvgValue> {
    @Override
    public LongAvgValue createInitialValue(WorkerContext context) throws IOException {
        return new LongAvgValue();
    }

    @Override
    public void aggregate(LongAvgValue value, Object lw) {
        value.sum.set(value.sum.get() + ((LongWritable)lw).get());
        value.count.set(value.count.get() + 1L);
    }

    @Override
    public void merge(LongAvgValue value, LongAvgValue partial) {
        value.sum.set(value.sum.get() + partial.sum.get());
        value.count.set(value.count.get() + partial.count.get());
    }

    @Override
    public boolean terminate(WorkerContext context, LongAvgValue value) throws IOException {
        if (value.count.get() > 0L) {
            value.avg.set(value.sum.get() / value.count.get());
        }
        return false;
    }
}

