/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph;

import com.aliyun.odps.graph.ComputingVertexResolver;
import com.aliyun.odps.graph.Edge;
import com.aliyun.odps.graph.Vertex;
import com.aliyun.odps.graph.VertexChanges;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableComparable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DefaultComputingVertexResolver<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable>
extends ComputingVertexResolver<I, V, E, M> {
    @Override
    public Vertex<I, V, E, M> resolveExistVertexMutations(I vertexId, Vertex<I, V, E, M> vertex, VertexChanges<I, V, E, M> vertexChanges) throws IOException {
        if (this.hasVertexAdditions(vertexChanges)) {
            throw new IOException("ODPS-0730001: And vertex(Id: '" + vertexId + "') that already exists");
        }
        this.addEdges(vertexId, vertex, vertexChanges);
        this.removeEdges(vertexId, vertex, vertexChanges);
        vertex = this.removeVertexIfDesired(vertexId, vertex, vertexChanges);
        return vertex;
    }

    @Override
    public Vertex<I, V, E, M> resolveNotExistVertexMutations(I vertexId, VertexChanges<I, V, E, M> vertexChanges, boolean hasMessages) throws IOException {
        Vertex<I, V, E, M> vertex = this.addVertexIfDesired(vertexId, vertexChanges);
        this.addEdges(vertexId, vertex, vertexChanges);
        this.removeEdges(vertexId, vertex, vertexChanges);
        vertex = this.removeVertexIfDesired(vertexId, vertex, vertexChanges);
        if (vertex == null && hasMessages) {
            throw new IOException("ODPS-0730001: Send messages to vertex(Id: '" + vertexId + "') that is not exist");
        }
        return vertex;
    }

    protected void removeEdges(I vertexId, Vertex<I, V, E, M> vertex, VertexChanges<I, V, E, M> vertexChanges) throws IOException {
        if (this.hasEdgeRemovals(vertexChanges)) {
            if (vertex == null) {
                throw new IOException("ODPS-0730001: Remove edge from vertex(Id: '" + vertexId + "') that does not exist");
            }
            if (!vertex.hasEdges()) {
                throw new IOException("ODPS-0730001: Remove edge from vertex(Id: '" + vertexId + "') that does not has edges");
            }
            for (WritableComparable removedDestVertex : vertexChanges.getRemovedEdgeList()) {
                boolean found = false;
                List<Edge<I, E>> edgeList = vertex.getEdges();
                Iterator<Edge<I, E>> edges = edgeList.iterator();
                while (edges.hasNext()) {
                    Edge<I, E> edge = edges.next();
                    if (!edge.getDestVertexId().equals(removedDestVertex)) continue;
                    edges.remove();
                    found = true;
                }
                if (found) continue;
                throw new IOException("ODPS-0730001:Remove edge(DestVertexId: '" + removedDestVertex + "') that does not exist for " + vertex);
            }
        }
    }

    protected Vertex<I, V, E, M> removeVertexIfDesired(I vertexId, Vertex<I, V, E, M> vertex, VertexChanges<I, V, E, M> vertexChanges) throws IOException {
        if (this.hasVertexRemovals(vertexChanges)) {
            if (vertex == null) {
                throw new IOException("ODPS-0730001: Remove vertex(Id: '" + vertexId + "') that does not exist");
            }
            vertex = null;
        }
        return vertex;
    }

    protected Vertex<I, V, E, M> addVertexIfDesired(I vertexId, VertexChanges<I, V, E, M> vertexChanges) throws IOException {
        Vertex<I, V, E, M> vertex = null;
        if (this.hasVertexAdditions(vertexChanges)) {
            if (vertexChanges.getAddedVertexList().size() > 1) {
                throw new IOException("ODPS-0730001: Add duplicate vertices for id: '" + vertexId + "'");
            }
            vertex = vertexChanges.getAddedVertexList().get(0);
        }
        return vertex;
    }

    protected void addEdges(I vertexId, Vertex<I, V, E, M> vertex, VertexChanges<I, V, E, M> vertexChanges) throws IOException {
        HashSet<I> destVertexId = new HashSet<I>();
        if (vertex != null && vertex.hasEdges()) {
            for (Edge<I, E> edge : vertex.getEdges()) {
                if (destVertexId.contains(edge.getDestVertexId())) {
                    throw new IOException("ODPS-0730001: Duplicate edges for vertex, from '" + vertex.getId() + "' to '" + edge.getDestVertexId() + "'");
                }
                destVertexId.add(edge.getDestVertexId());
            }
        }
        if (this.hasEdgeAdditions(vertexChanges)) {
            if (vertex == null) {
                throw new IOException("ODPS-0730001: Add edge to vertex(Id: '" + vertexId + "') that does not exist");
            }
            for (Edge<I, E> edge : vertexChanges.getAddedEdgeList()) {
                if (destVertexId.contains(edge.getDestVertexId())) {
                    throw new IOException("ODPS-0730001: Add duplicate edges for vertex, from '" + vertex.getId() + "' to '" + edge.getDestVertexId() + "'");
                }
                destVertexId.add(edge.getDestVertexId());
                vertex.addEdge(edge.getDestVertexId(), edge.getValue());
            }
        }
    }

    protected boolean hasVertexRemovals(VertexChanges<I, V, E, M> changes) {
        return changes != null && changes.getRemovedVertexCount() > 0;
    }

    protected boolean hasVertexAdditions(VertexChanges<I, V, E, M> changes) {
        return changes != null && changes.getAddedVertexList() != null && !changes.getAddedVertexList().isEmpty();
    }

    protected boolean hasEdgeAdditions(VertexChanges<I, V, E, M> changes) {
        return changes != null && changes.getAddedEdgeList() != null && !changes.getAddedEdgeList().isEmpty();
    }

    protected boolean hasEdgeRemovals(VertexChanges<I, V, E, M> changes) {
        return changes != null && changes.getRemovedEdgeList() != null && !changes.getRemovedEdgeList().isEmpty();
    }
}

