/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AOpContext;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public class S3AReadOpContext
extends S3AOpContext {
    private final Path path;
    private final S3AInputPolicy inputPolicy;
    private final ChangeDetectionPolicy changeDetectionPolicy;
    private final long readahead;
    private final AuditSpan auditSpan;

    public S3AReadOpContext(Path path, boolean isS3GuardEnabled, Invoker invoker, @Nullable Invoker s3guardInvoker, @Nullable FileSystem.Statistics stats, S3AStatisticsContext instrumentation, FileStatus dstFileStatus, S3AInputPolicy inputPolicy, ChangeDetectionPolicy changeDetectionPolicy, long readahead, AuditSpan auditSpan) {
        super(isS3GuardEnabled, invoker, s3guardInvoker, stats, instrumentation, dstFileStatus);
        this.path = Preconditions.checkNotNull(path);
        this.auditSpan = auditSpan;
        Preconditions.checkArgument(readahead >= 0L, "invalid readahead %d", readahead);
        this.inputPolicy = Preconditions.checkNotNull(inputPolicy);
        this.changeDetectionPolicy = Preconditions.checkNotNull(changeDetectionPolicy);
        this.readahead = readahead;
    }

    public Invoker getReadInvoker() {
        if (this.isS3GuardEnabled) {
            return this.s3guardInvoker;
        }
        return this.invoker;
    }

    public Path getPath() {
        return this.path;
    }

    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    public ChangeDetectionPolicy getChangeDetectionPolicy() {
        return this.changeDetectionPolicy;
    }

    public long getReadahead() {
        return this.readahead;
    }

    public AuditSpan getAuditSpan() {
        return this.auditSpan;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("S3AReadOpContext{");
        sb.append("path=").append(this.path);
        sb.append(", inputPolicy=").append((Object)this.inputPolicy);
        sb.append(", readahead=").append(this.readahead);
        sb.append(", changeDetectionPolicy=").append(this.changeDetectionPolicy);
        sb.append('}');
        return sb.toString();
    }
}

