/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.reuse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.abilities.source.FilterPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ProjectPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ReadingMetadataSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.abilities.source.WatermarkPushDownSpec;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Option;

public class ScanReuserUtils {
    private ScanReuserUtils() {
    }

    public static int indexOf(int[][] projectedFields, int[] fieldIndices) {
        for (int i = 0; i < projectedFields.length; ++i) {
            int[] nested = projectedFields[i];
            if (!Arrays.equals(nested, fieldIndices)) continue;
            return i;
        }
        throw new TableException(String.format("Field index path %s is not found in all projected field index paths %s. This should not happen.", new Object[]{fieldIndices, projectedFields}));
    }

    public static List<SourceAbilitySpec> abilitySpecsWithoutEscaped(TableSourceTable table) {
        SourceAbilitySpec[] specs;
        ArrayList<SourceAbilitySpec> ret = new ArrayList<SourceAbilitySpec>();
        for (SourceAbilitySpec spec : specs = table.abilitySpecs()) {
            if (ScanReuserUtils.isEscapeDigest(spec)) continue;
            ret.add(spec);
        }
        return ret;
    }

    private static boolean isIgnoreDigest(SourceAbilitySpec spec) {
        if (spec instanceof FilterPushDownSpec) {
            FilterPushDownSpec filterPushDownSpec = (FilterPushDownSpec)spec;
            return filterPushDownSpec.getPredicates().isEmpty();
        }
        return false;
    }

    public static boolean isEscapeDigest(SourceAbilitySpec spec) {
        return spec instanceof ProjectPushDownSpec || spec instanceof ReadingMetadataSpec || spec instanceof WatermarkPushDownSpec;
    }

    private static List<String> extraDigestsWithoutEscapedAndIgnored(TableSourceTable table) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> digests = table.getSpecDigests();
        SourceAbilitySpec[] specs = table.abilitySpecs();
        for (int i = 0; i < specs.length; ++i) {
            SourceAbilitySpec spec = specs[i];
            if (ScanReuserUtils.isEscapeDigest(spec) || ScanReuserUtils.isIgnoreDigest(spec)) continue;
            ret.add(digests.get(i));
        }
        return ret;
    }

    private static List<String> extraDigestsWithoutIgnored(TableSourceTable table) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> digests = table.getSpecDigests();
        SourceAbilitySpec[] specs = table.abilitySpecs();
        for (int i = 0; i < specs.length; ++i) {
            SourceAbilitySpec spec = specs[i];
            if (ScanReuserUtils.isIgnoreDigest(spec)) continue;
            ret.add(digests.get(i));
        }
        return ret;
    }

    public static boolean containsRexNodeSpecAfterProjection(CommonPhysicalTableSourceScan table) {
        SourceAbilitySpec[] specs = table.tableSourceTable().abilitySpecs();
        boolean hasProjection = false;
        for (SourceAbilitySpec spec : specs) {
            if (spec instanceof ProjectPushDownSpec || spec instanceof ReadingMetadataSpec) {
                hasProjection = true;
                continue;
            }
            if (!hasProjection || !spec.needAdjustFieldReferenceAfterProjection() || spec instanceof WatermarkPushDownSpec) continue;
            return true;
        }
        return false;
    }

    public static Optional<WatermarkPushDownSpec> getAdjustedWatermarkSpec(TableSourceTable table, RowType oldSourceType, RowType newSourceType) {
        for (SourceAbilitySpec spec : table.abilitySpecs()) {
            if (spec instanceof WatermarkPushDownSpec) {
                return Optional.of(ScanReuserUtils.adjustWatermarkIndex(table.contextResolvedTable().getResolvedSchema(), oldSourceType, newSourceType, (WatermarkPushDownSpec)spec));
            }
            if (!spec.getProducedType().isPresent()) continue;
            oldSourceType = spec.getProducedType().get();
        }
        return Optional.empty();
    }

    private static WatermarkPushDownSpec adjustWatermarkIndex(ResolvedSchema tableSchema, RowType oldSourceType, RowType newSourceType, WatermarkPushDownSpec spec) {
        String rowtimeColumn;
        List newFieldNames = newSourceType.getFieldNames();
        if (newFieldNames.contains(rowtimeColumn = ((WatermarkSpec)tableSchema.getWatermarkSpecs().get(0)).getRowtimeAttribute())) {
            ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
            for (int i = 0; i < newSourceType.getFieldCount(); ++i) {
                String name = (String)newFieldNames.get(i);
                LogicalType type = newSourceType.getTypeAt(i);
                if (name.equals(rowtimeColumn)) {
                    type = new TimestampType(type.isNullable(), TimestampKind.ROWTIME, 3);
                }
                fields.add(new RowType.RowField(name, type));
            }
            newSourceType = new RowType(fields);
        }
        RexNode newExpr = ScanReuserUtils.adjustRexNodeIndex(oldSourceType, newSourceType, Collections.singletonList(spec.getWatermarkExpr())).get(0);
        return spec.copy(newExpr, newSourceType);
    }

    private static List<RexNode> adjustRexNodeIndex(RowType oldSourceType, RowType newSourceType, List<RexNode> rexNodes) {
        final List oldFieldNames = oldSourceType.getFieldNames();
        final List newFieldNames = newSourceType.getFieldNames();
        RexShuttle shuttle = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                String name = (String)oldFieldNames.get(inputRef.getIndex());
                int newIndex = newFieldNames.indexOf(name);
                return new RexInputRef(newIndex, inputRef.getType());
            }
        };
        return rexNodes.stream().map(node -> node.accept(shuttle)).collect(Collectors.toList());
    }

    public static Calc createCalcForScan(RelNode input, RexProgram program) {
        return input instanceof StreamPhysicalTableSourceScan ? new StreamPhysicalCalc(input.getCluster(), input.getTraitSet(), input, program, program.getOutputRowType()) : new BatchPhysicalCalc(input.getCluster(), input.getTraitSet(), input, program, program.getOutputRowType());
    }

    /*
     * Exception decompiling
     */
    public static int[][] projectedFields(TableSourceTable source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> metadataKeys(TableSourceTable source) {
        ResolvedSchema schema = source.contextResolvedTable().getResolvedSchema();
        ReadingMetadataSpec meta = ScanReuserUtils.getAbilitySpec(source.abilitySpecs(), ReadingMetadataSpec.class);
        return meta == null ? DynamicSourceUtils.createRequiredMetadataColumns(schema, source.tableSource()).stream().map(col -> col.getMetadataKey().orElse(col.getName())).collect(Collectors.toList()) : meta.getMetadataKeys();
    }

    /*
     * Exception decompiling
     */
    public static int[][] concatProjectedFields(ResolvedSchema schema, RowType originType, int[][] physicalFields, List<String> metaKeys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean reusableWithoutAdjust(List<? extends RelNode> reusableNodes) {
        String digest = null;
        for (RelNode relNode : reusableNodes) {
            String currentDigest = ScanReuserUtils.getDigest((CommonPhysicalTableSourceScan)relNode, false);
            if (digest == null) {
                digest = currentDigest;
                continue;
            }
            if (digest.equals(currentDigest)) continue;
            return false;
        }
        return true;
    }

    public static String getDigest(CommonPhysicalTableSourceScan scan, boolean withoutEscape) {
        Option<String> snapshot;
        TableSourceTable table = scan.tableSourceTable();
        ArrayList<String> digest = new ArrayList<String>();
        digest.addAll(table.getNames());
        if (!scan.getInputs().isEmpty()) {
            digest.add("input=[" + scan.getInputs().stream().map(RelNode::getDigest).collect(Collectors.joining(",")) + "]");
        }
        if (withoutEscape) {
            digest.addAll(ScanReuserUtils.extraDigestsWithoutEscapedAndIgnored(table));
        } else {
            digest.addAll(ScanReuserUtils.extraDigestsWithoutIgnored(table));
        }
        if (!scan.getHints().isEmpty()) {
            digest.add("hints=[" + scan.hintsDigest() + "]");
        }
        if ((snapshot = scan.extractSnapshotVersion()).isDefined()) {
            digest.add("version=" + (String)snapshot.getOrElse(() -> ""));
        }
        return ((Object)digest).toString();
    }

    public static <T extends SourceAbilitySpec> T getAbilitySpec(SourceAbilitySpec[] abilitySpecs, Class<T> specClass) {
        return (T)((SourceAbilitySpec)Arrays.stream(abilitySpecs).filter(spec -> spec.getClass().equals(specClass)).findFirst().orElse(null));
    }

    public static CommonPhysicalTableSourceScan pickScanWithWatermark(List<CommonPhysicalTableSourceScan> scans) {
        Predicate<CommonPhysicalTableSourceScan> containsWatermark = scan -> Arrays.stream(scan.tableSourceTable().abilitySpecs()).anyMatch(spec -> spec instanceof WatermarkPushDownSpec);
        return scans.stream().filter(containsWatermark).findFirst().orElse(scans.get(0));
    }

    private static /* synthetic */ int[][] lambda$concatProjectedFields$6(int x$0) {
        return new int[x$0][];
    }

    private static /* synthetic */ int[][] lambda$projectedFields$2(int x$0) {
        return new int[x$0][];
    }
}

