/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsStatisticReport;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.plan.abilities.source.FilterPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.PartitionPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.utils.DefaultRelShuttle;
import org.apache.flink.table.planner.utils.CatalogTableStatisticsConverter;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class FlinkRecomputeStatisticsProgram
implements FlinkOptimizeProgram<BatchOptimizeContext> {
    @Override
    public RelNode optimize(RelNode root, BatchOptimizeContext context) {
        DefaultRelShuttle shuttle = new DefaultRelShuttle(){

            @Override
            public RelNode visit(TableScan scan) {
                if (scan instanceof LogicalTableScan) {
                    return FlinkRecomputeStatisticsProgram.this.recomputeStatistics((LogicalTableScan)scan);
                }
                return super.visit(scan);
            }
        };
        return shuttle.visit(root);
    }

    private LogicalTableScan recomputeStatistics(LogicalTableScan scan) {
        RelOptTable scanTable = scan.getTable();
        if (!(scanTable instanceof TableSourceTable)) {
            return scan;
        }
        FlinkContext context = ShortcutUtils.unwrapContext(scan);
        TableSourceTable table = (TableSourceTable)scanTable;
        boolean reportStatEnabled = (Boolean)context.getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_SOURCE_REPORT_STATISTICS_ENABLED) != false && table.tableSource() instanceof SupportsStatisticReport;
        SourceAbilitySpec[] specs = table.abilitySpecs();
        PartitionPushDownSpec partitionPushDownSpec = this.getSpec(specs, PartitionPushDownSpec.class);
        FilterPushDownSpec filterPushDownSpec = this.getSpec(specs, FilterPushDownSpec.class);
        TableStats newTableStat = this.recomputeStatistics(table, partitionPushDownSpec, filterPushDownSpec, reportStatEnabled);
        FlinkStatistic newStatistic = FlinkStatistic.builder().statistic(table.getStatistic()).tableStats(newTableStat).build();
        TableSourceTable newTable = table.copy(newStatistic);
        return new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), scan.getHints(), newTable);
    }

    private TableStats recomputeStatistics(TableSourceTable table, PartitionPushDownSpec partitionPushDownSpec, FilterPushDownSpec filterPushDownSpec, boolean reportStatEnabled) {
        TableStats origTableStats = table.getStatistic().getTableStats();
        DynamicTableSource tableSource = table.tableSource();
        if (filterPushDownSpec != null && !filterPushDownSpec.isAllPredicatesRetained()) {
            return reportStatEnabled ? ((SupportsStatisticReport)tableSource).reportStatistics() : null;
        }
        if (partitionPushDownSpec != null) {
            TableStats newTableStat = this.getPartitionsTableStats(table, partitionPushDownSpec);
            if (reportStatEnabled && this.isUnknownTableStats(newTableStat)) {
                return ((SupportsStatisticReport)tableSource).reportStatistics();
            }
            return newTableStat;
        }
        if (this.isPartitionedTable(table) && this.isUnknownTableStats(origTableStats)) {
            origTableStats = this.getPartitionsTableStats(table, null);
        }
        if (reportStatEnabled && this.isUnknownTableStats(origTableStats)) {
            return ((SupportsStatisticReport)tableSource).reportStatistics();
        }
        return origTableStats;
    }

    private boolean isPartitionedTable(TableSourceTable table) {
        return ((ResolvedCatalogTable)table.contextResolvedTable().getResolvedTable()).isPartitioned();
    }

    private boolean isUnknownTableStats(TableStats stats) {
        return stats == null || stats.getRowCount() < 0L && stats.getColumnStats().isEmpty();
    }

    private TableStats getPartitionsTableStats(TableSourceTable table, @Nullable PartitionPushDownSpec partitionPushDownSpec) {
        if (table.contextResolvedTable().isPermanent()) {
            ObjectIdentifier identifier = table.contextResolvedTable().getIdentifier();
            ObjectPath tablePath = identifier.toObjectPath();
            Optional optionalCatalog = table.contextResolvedTable().getCatalog();
            if (!optionalCatalog.isPresent()) {
                return TableStats.UNKNOWN;
            }
            Catalog catalog = (Catalog)optionalCatalog.get();
            ArrayList<Map<String, String>> partitionList = new ArrayList();
            if (partitionPushDownSpec == null) {
                try {
                    List catalogPartitionSpecs = catalog.listPartitions(tablePath);
                    for (CatalogPartitionSpec partitionSpec : catalogPartitionSpecs) {
                        partitionList.add(partitionSpec.getPartitionSpec());
                    }
                }
                catch (TableNotExistException | TableNotPartitionedException e) {
                    throw new TableException("Table not exists!", e);
                }
            } else {
                partitionList = partitionPushDownSpec.getPartitions();
            }
            Optional<TableStats> optionalTableStats = this.getPartitionStats(catalog, table.contextResolvedTable().getIdentifier().toObjectPath(), partitionList);
            return optionalTableStats.orElse(TableStats.UNKNOWN);
        }
        return TableStats.UNKNOWN;
    }

    private Optional<TableStats> getPartitionStats(Catalog catalog, ObjectPath tablePath, List<Map<String, String>> partition) {
        try {
            List<CatalogPartitionSpec> partitionSpecs = partition.stream().map(CatalogPartitionSpec::new).collect(Collectors.toList());
            return Optional.of(CatalogTableStatisticsConverter.convertToAccumulatedTableStates(catalog.bulkGetPartitionStatistics(tablePath, partitionSpecs), catalog.bulkGetPartitionColumnStatistics(tablePath, partitionSpecs), FlinkRecomputeStatisticsProgram.getPartitionKeys(partitionSpecs)));
        }
        catch (PartitionNotExistException e) {
            return Optional.empty();
        }
    }

    private static Set<String> getPartitionKeys(List<CatalogPartitionSpec> catalogPartitionSpecs) {
        HashSet<String> partitionKeys = new HashSet<String>();
        for (CatalogPartitionSpec catalogPartitionSpec : catalogPartitionSpecs) {
            Map partitionSpec = catalogPartitionSpec.getPartitionSpec();
            partitionKeys.addAll(partitionSpec.keySet());
        }
        return partitionKeys;
    }

    private <T extends SourceAbilitySpec> T getSpec(SourceAbilitySpec[] specs, Class<T> specClass) {
        if (specs == null) {
            return null;
        }
        for (SourceAbilitySpec spec : specs) {
            if (!spec.getClass().equals(specClass)) continue;
            return (T)spec;
        }
        return null;
    }
}

