/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize.program;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.optimize.program.BatchOptimizeContext;
import org.apache.flink.table.planner.plan.optimize.program.FlinkOptimizeProgram;
import org.apache.flink.table.planner.plan.utils.DefaultRelShuttle;
import org.apache.flink.table.planner.utils.DynamicPartitionPruningUtils;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class FlinkDynamicPartitionPruningProgram
implements FlinkOptimizeProgram<BatchOptimizeContext> {
    @Override
    public RelNode optimize(RelNode root, BatchOptimizeContext context) {
        if (!((Boolean)ShortcutUtils.unwrapContext(root).getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_DYNAMIC_FILTERING_ENABLED)).booleanValue()) {
            return root;
        }
        DefaultRelShuttle shuttle = new DefaultRelShuttle(){

            @Override
            public RelNode visit(RelNode rel) {
                if (!(rel instanceof Join) || !DynamicPartitionPruningUtils.isSuitableJoin((Join)rel)) {
                    ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
                    for (RelNode input : rel.getInputs()) {
                        RelNode newInput = input.accept(this);
                        newInputs.add(newInput);
                    }
                    return rel.copy(rel.getTraitSet(), newInputs);
                }
                Join join = (Join)rel;
                JoinInfo joinInfo = join.analyzeCondition();
                RelNode leftSide = join.getLeft();
                RelNode rightSide = join.getRight();
                RelNode newJoin = join;
                boolean changed = false;
                if (DynamicPartitionPruningUtils.isDppDimSide(leftSide)) {
                    if (join.getJoinType() != JoinRelType.RIGHT) {
                        Tuple2<Boolean, RelNode> relTuple = DynamicPartitionPruningUtils.canConvertAndConvertDppFactSide(rightSide, joinInfo.rightKeys, leftSide, joinInfo.leftKeys);
                        changed = (Boolean)relTuple.f0;
                        newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(leftSide, ((RelNode)relTuple.f1).accept(this)));
                    }
                } else if (DynamicPartitionPruningUtils.isDppDimSide(rightSide) && join.getJoinType() != JoinRelType.LEFT) {
                    Tuple2<Boolean, RelNode> relTuple = DynamicPartitionPruningUtils.canConvertAndConvertDppFactSide(leftSide, joinInfo.leftKeys, rightSide, joinInfo.rightKeys);
                    changed = (Boolean)relTuple.f0;
                    newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(((RelNode)relTuple.f1).accept(this), rightSide));
                }
                if (changed) {
                    return newJoin;
                }
                return newJoin.copy(newJoin.getTraitSet(), (List)Arrays.asList(newJoin.getLeft().accept(this), newJoin.getRight().accept(this)));
            }
        };
        return shuttle.visit(root);
    }
}

