/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.LinkedHashMap;
import org.apache.flink.sql.parser.dql.SqlShowPartitions;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlShowPartitionsConverter
implements SqlNodeConverter<SqlShowPartitions> {
    @Override
    public Operation convertSqlNode(SqlShowPartitions sqlShowPartitions, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlShowPartitions.fullTableName());
        ObjectIdentifier tableIdentifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        LinkedHashMap<String, String> partitionKVs = sqlShowPartitions.getPartitionKVs();
        if (partitionKVs != null) {
            CatalogPartitionSpec partitionSpec = new CatalogPartitionSpec(partitionKVs);
            return new ShowPartitionsOperation(tableIdentifier, partitionSpec);
        }
        return new ShowPartitionsOperation(tableIdentifier, null);
    }
}

