/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

class MergeTableLikeUtil {
    private static final HashMap<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> defaultMergingStrategies = new HashMap();
    private final SqlValidator validator;
    private final Function<SqlNode, String> escapeExpression;
    private final DataTypeFactory dataTypeFactory;

    MergeTableLikeUtil(SqlValidator validator, Function<SqlNode, String> escapeExpression, DataTypeFactory dataTypeFactory) {
        this.validator = validator;
        this.escapeExpression = escapeExpression;
        this.dataTypeFactory = dataTypeFactory;
    }

    public Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> computeMergingStrategies(List<SqlTableLike.SqlTableLikeOption> mergingOptions) {
        HashMap<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> result = new HashMap<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy>(defaultMergingStrategies);
        Optional<SqlTableLike.SqlTableLikeOption> maybeAllOption = mergingOptions.stream().filter(option -> option.getFeatureOption() == SqlTableLike.FeatureOption.ALL).findFirst();
        maybeAllOption.ifPresent(allOption -> {
            SqlTableLike.MergingStrategy strategy = allOption.getMergingStrategy();
            for (SqlTableLike.FeatureOption featureOption : SqlTableLike.FeatureOption.values()) {
                if (featureOption == SqlTableLike.FeatureOption.ALL) continue;
                result.put(featureOption, strategy);
            }
        });
        for (SqlTableLike.SqlTableLikeOption mergingOption : mergingOptions) {
            result.put(mergingOption.getFeatureOption(), mergingOption.getMergingStrategy());
        }
        return result;
    }

    public Schema mergeTables(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema, List<SqlNode> derivedColumns, List<SqlWatermark> derivedWatermarkSpecs, SqlTableConstraint derivedPrimaryKey) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(mergingStrategies, sourceSchema, (FlinkTypeFactory)this.validator.getTypeFactory(), this.dataTypeFactory, this.validator, this.escapeExpression);
        schemaBuilder.appendDerivedColumns(mergingStrategies, derivedColumns);
        schemaBuilder.appendDerivedWatermarks(mergingStrategies, derivedWatermarkSpecs);
        schemaBuilder.appendDerivedPrimaryKey(derivedPrimaryKey);
        return schemaBuilder.build();
    }

    public List<String> mergePartitions(SqlTableLike.MergingStrategy mergingStrategy, List<String> sourcePartitions, List<String> derivedPartitions) {
        if (!derivedPartitions.isEmpty() && !sourcePartitions.isEmpty() && mergingStrategy != SqlTableLike.MergingStrategy.EXCLUDING) {
            throw new ValidationException("The base table already has partitions defined. You might want to specify EXCLUDING PARTITIONS.");
        }
        if (!derivedPartitions.isEmpty()) {
            return derivedPartitions;
        }
        return sourcePartitions;
    }

    public Map<String, String> mergeOptions(SqlTableLike.MergingStrategy mergingStrategy, Map<String, String> sourceOptions, Map<String, String> derivedOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (mergingStrategy != SqlTableLike.MergingStrategy.EXCLUDING) {
            options.putAll(sourceOptions);
        }
        derivedOptions.forEach((key, value) -> {
            if (mergingStrategy != SqlTableLike.MergingStrategy.OVERWRITING && options.containsKey(key)) {
                throw new ValidationException(String.format("There already exists an option ['%s' -> '%s']  in the base table. You might want to specify EXCLUDING OPTIONS or OVERWRITING OPTIONS.", key, options.get(key)));
            }
            options.put((String)key, (String)value);
        });
        return options;
    }

    static {
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.OPTIONS, SqlTableLike.MergingStrategy.OVERWRITING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.WATERMARKS, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.GENERATED, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.METADATA, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.CONSTRAINTS, SqlTableLike.MergingStrategy.INCLUDING);
        defaultMergingStrategies.put(SqlTableLike.FeatureOption.PARTITIONS, SqlTableLike.MergingStrategy.INCLUDING);
    }

    private static class SchemaBuilder {
        Map<String, Schema.UnresolvedColumn> columns = new LinkedHashMap<String, Schema.UnresolvedColumn>();
        Map<String, Schema.UnresolvedWatermarkSpec> watermarkSpecs = new HashMap<String, Schema.UnresolvedWatermarkSpec>();
        Schema.UnresolvedPrimaryKey primaryKey = null;
        Map<String, RelDataType> physicalFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        Map<String, RelDataType> metadataFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        Map<String, RelDataType> computedFieldNamesToTypes = new LinkedHashMap<String, RelDataType>();
        Function<SqlNode, String> escapeExpressions;
        FlinkTypeFactory typeFactory;
        SqlValidator sqlValidator;
        DataTypeFactory dataTypeFactory;

        SchemaBuilder(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema, FlinkTypeFactory typeFactory, DataTypeFactory dataTypeFactory, SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions) {
            this.typeFactory = typeFactory;
            this.dataTypeFactory = dataTypeFactory;
            this.sqlValidator = sqlValidator;
            this.escapeExpressions = escapeExpressions;
            this.populateColumnsFromSourceTable(mergingStrategies, sourceSchema);
            this.populateWatermarksFromSourceTable(mergingStrategies, sourceSchema);
            this.populatePrimaryKeyFromSourceTable(mergingStrategies, sourceSchema);
        }

        private void populateColumnsFromSourceTable(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema) {
            for (Schema.UnresolvedColumn sourceColumn : sourceSchema.getColumns()) {
                if (sourceColumn instanceof Schema.UnresolvedPhysicalColumn) {
                    LogicalType columnType = this.dataTypeFactory.createDataType(((Schema.UnresolvedPhysicalColumn)sourceColumn).getDataType()).getLogicalType();
                    this.physicalFieldNamesToTypes.put(sourceColumn.getName(), this.typeFactory.createFieldTypeFromLogicalType(columnType));
                    this.columns.put(sourceColumn.getName(), sourceColumn);
                    continue;
                }
                if (sourceColumn instanceof Schema.UnresolvedComputedColumn) {
                    if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.GENERATED) == SqlTableLike.MergingStrategy.EXCLUDING) continue;
                    this.columns.put(sourceColumn.getName(), sourceColumn);
                    continue;
                }
                if (!(sourceColumn instanceof Schema.UnresolvedMetadataColumn) || mergingStrategies.get((Object)SqlTableLike.FeatureOption.METADATA) == SqlTableLike.MergingStrategy.EXCLUDING) continue;
                this.columns.put(sourceColumn.getName(), sourceColumn);
            }
        }

        private void populateWatermarksFromSourceTable(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema) {
            for (Schema.UnresolvedWatermarkSpec sourceWatermarkSpec : sourceSchema.getWatermarkSpecs()) {
                if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.WATERMARKS) == SqlTableLike.MergingStrategy.EXCLUDING) continue;
                this.watermarkSpecs.put(sourceWatermarkSpec.getColumnName(), sourceWatermarkSpec);
            }
        }

        private void populatePrimaryKeyFromSourceTable(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, Schema sourceSchema) {
            if (sourceSchema.getPrimaryKey().isPresent() && mergingStrategies.get((Object)SqlTableLike.FeatureOption.CONSTRAINTS) == SqlTableLike.MergingStrategy.INCLUDING) {
                this.primaryKey = (Schema.UnresolvedPrimaryKey)sourceSchema.getPrimaryKey().get();
            }
        }

        private void appendDerivedPrimaryKey(@Nullable SqlTableConstraint derivedPrimaryKey) {
            if (derivedPrimaryKey != null && this.primaryKey != null) {
                throw new ValidationException("The base table already has a primary key. You might want to specify EXCLUDING CONSTRAINTS.");
            }
            if (derivedPrimaryKey != null) {
                ArrayList<String> primaryKeyColumns = new ArrayList<String>();
                for (SqlNode primaryKeyNode : derivedPrimaryKey.getColumns()) {
                    String primaryKey = ((SqlIdentifier)primaryKeyNode).getSimple();
                    if (!this.columns.containsKey(primaryKey)) {
                        throw new ValidationException(String.format("Primary key column '%s' is not defined in the schema at %s", primaryKey, primaryKeyNode.getParserPosition()));
                    }
                    if (!(this.columns.get(primaryKey) instanceof Schema.UnresolvedPhysicalColumn)) {
                        throw new ValidationException(String.format("Could not create a PRIMARY KEY with column '%s' at %s.\nA PRIMARY KEY constraint must be declared on physical columns.", primaryKey, primaryKeyNode.getParserPosition()));
                    }
                    primaryKeyColumns.add(primaryKey);
                }
                this.primaryKey = new Schema.UnresolvedPrimaryKey(derivedPrimaryKey.getConstraintName().orElseGet(() -> "PK_" + primaryKeyColumns.hashCode()), primaryKeyColumns);
            }
        }

        private void appendDerivedWatermarks(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, List<SqlWatermark> derivedWatermarkSpecs) {
            for (SqlWatermark derivedWatermarkSpec : derivedWatermarkSpecs) {
                SqlIdentifier eventTimeColumnName = derivedWatermarkSpec.getEventTimeColumnName();
                LinkedHashMap<String, RelDataType> nameToTypeMap = new LinkedHashMap<String, RelDataType>();
                nameToTypeMap.putAll(this.physicalFieldNamesToTypes);
                nameToTypeMap.putAll(this.metadataFieldNamesToTypes);
                nameToTypeMap.putAll(this.computedFieldNamesToTypes);
                this.verifyRowtimeAttribute(mergingStrategies, eventTimeColumnName, nameToTypeMap);
                String rowtimeAttribute = eventTimeColumnName.toString();
                SqlNode expression = derivedWatermarkSpec.getWatermarkStrategy();
                SqlNode validated = this.sqlValidator.validateParameterizedExpression(expression, nameToTypeMap);
                this.watermarkSpecs.put(rowtimeAttribute, new Schema.UnresolvedWatermarkSpec(rowtimeAttribute, (Expression)new SqlCallExpression(this.escapeExpressions.apply(validated))));
            }
        }

        private void verifyRowtimeAttribute(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, SqlIdentifier eventTimeColumnName, Map<String, RelDataType> allFieldsTypes) {
            String fullRowtimeExpression = eventTimeColumnName.toString();
            boolean specAlreadyExists = this.watermarkSpecs.containsKey(fullRowtimeExpression);
            if (specAlreadyExists && mergingStrategies.get((Object)SqlTableLike.FeatureOption.WATERMARKS) != SqlTableLike.MergingStrategy.OVERWRITING) {
                throw new ValidationException(String.format("There already exists a watermark spec for column '%s' in the base table. You might want to specify EXCLUDING WATERMARKS or OVERWRITING WATERMARKS.", fullRowtimeExpression));
            }
            ImmutableList<String> components = eventTimeColumnName.names;
            if (!allFieldsTypes.containsKey(components.get(0))) {
                throw new ValidationException(String.format("The rowtime attribute field '%s' is not defined in the table schema, at %s\nAvailable fields: [%s]", fullRowtimeExpression, eventTimeColumnName.getParserPosition(), allFieldsTypes.keySet().stream().collect(Collectors.joining("', '", "'", "'"))));
            }
            if (components.size() > 1) {
                RelDataType componentType = allFieldsTypes.get(components.get(0));
                for (int i = 1; i < components.size(); ++i) {
                    RelDataTypeField field = componentType.getField((String)components.get(i), true, false);
                    if (field == null) {
                        throw new ValidationException(String.format("The rowtime attribute field '%s' is not defined in the table schema, at %s\nNested field '%s' was not found in a composite type: %s.", fullRowtimeExpression, eventTimeColumnName.getComponent(i).getParserPosition(), components.get(i), FlinkTypeFactory.toLogicalType(allFieldsTypes.get(components.get(0)))));
                    }
                    componentType = field.getType();
                }
            }
        }

        private void appendDerivedColumns(Map<SqlTableLike.FeatureOption, SqlTableLike.MergingStrategy> mergingStrategies, List<SqlNode> derivedColumns) {
            this.collectPhysicalFieldsTypes(derivedColumns);
            for (SqlNode derivedColumn : derivedColumns) {
                Schema.UnresolvedPhysicalColumn column;
                String name = ((SqlTableColumn)derivedColumn).getName().getSimple();
                String comment = ((SqlTableColumn)derivedColumn).getComment().map(c -> ((SqlLiteral)c).getValueAs(String.class)).orElse(null);
                if (derivedColumn instanceof SqlTableColumn.SqlRegularColumn) {
                    LogicalType logicalType = FlinkTypeFactory.toLogicalType(this.physicalFieldNamesToTypes.get(name));
                    column = new Schema.UnresolvedPhysicalColumn(name, (AbstractDataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType), comment);
                } else if (derivedColumn instanceof SqlTableColumn.SqlComputedColumn) {
                    SqlTableColumn.SqlComputedColumn computedColumn = (SqlTableColumn.SqlComputedColumn)derivedColumn;
                    if (this.physicalFieldNamesToTypes.containsKey(name)) {
                        throw new ValidationException(String.format("A column named '%s' already exists in the table. Duplicate columns exist in the compute column and regular column. ", name));
                    }
                    if (this.columns.containsKey(name)) {
                        if (!(this.columns.get(name) instanceof Schema.UnresolvedComputedColumn)) {
                            throw new ValidationException(String.format("A column named '%s' already exists in the base table. Computed columns can only overwrite other computed columns.", name));
                        }
                        if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.GENERATED) != SqlTableLike.MergingStrategy.OVERWRITING) {
                            throw new ValidationException(String.format("A generated column named '%s' already exists in the base table. You might want to specify EXCLUDING GENERATED or OVERWRITING GENERATED.", name));
                        }
                    }
                    HashMap<String, RelDataType> accessibleFieldNamesToTypes = new HashMap<String, RelDataType>();
                    accessibleFieldNamesToTypes.putAll(this.physicalFieldNamesToTypes);
                    accessibleFieldNamesToTypes.putAll(this.metadataFieldNamesToTypes);
                    SqlNode validatedExpr = this.sqlValidator.validateParameterizedExpression(computedColumn.getExpr(), accessibleFieldNamesToTypes);
                    RelDataType validatedType = this.sqlValidator.getValidatedNodeType(validatedExpr);
                    column = new Schema.UnresolvedComputedColumn(name, (Expression)new SqlCallExpression(this.escapeExpressions.apply(validatedExpr)), comment);
                    this.computedFieldNamesToTypes.put(name, validatedType);
                } else if (derivedColumn instanceof SqlTableColumn.SqlMetadataColumn) {
                    SqlDataTypeSpec type;
                    SqlTableColumn.SqlMetadataColumn metadataColumn = (SqlTableColumn.SqlMetadataColumn)derivedColumn;
                    if (this.physicalFieldNamesToTypes.containsKey(name)) {
                        throw new ValidationException(String.format("A column named '%s' already exists in the table. Duplicate columns exist in the metadata column and regular column. ", name));
                    }
                    if (this.columns.containsKey(name)) {
                        if (!(this.columns.get(name) instanceof Schema.UnresolvedMetadataColumn)) {
                            throw new ValidationException(String.format("A column named '%s' already exists in the base table. Metadata columns can only overwrite other metadata columns.", name));
                        }
                        if (mergingStrategies.get((Object)SqlTableLike.FeatureOption.METADATA) != SqlTableLike.MergingStrategy.OVERWRITING) {
                            throw new ValidationException(String.format("A metadata column named '%s' already exists in the base table. You might want to specify EXCLUDING METADATA or OVERWRITING METADATA.", name));
                        }
                    }
                    boolean nullable = (type = metadataColumn.getType()).getNullable() == null || type.getNullable() != false;
                    RelDataType relType = type.deriveType(this.sqlValidator, nullable);
                    column = new Schema.UnresolvedMetadataColumn(name, (AbstractDataType)TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(relType)), (String)metadataColumn.getMetadataAlias().orElse(null), metadataColumn.isVirtual(), comment);
                    this.metadataFieldNamesToTypes.put(name, relType);
                } else {
                    throw new ValidationException("Unsupported column type: " + derivedColumn);
                }
                this.columns.put(column.getName(), (Schema.UnresolvedColumn)column);
            }
        }

        private void collectPhysicalFieldsTypes(List<SqlNode> derivedColumns) {
            for (SqlNode derivedColumn : derivedColumns) {
                SqlDataTypeSpec type;
                if (!(derivedColumn instanceof SqlTableColumn.SqlRegularColumn)) continue;
                SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)derivedColumn;
                String name = regularColumn.getName().getSimple();
                if (this.columns.containsKey(name)) {
                    throw new ValidationException(String.format("A column named '%s' already exists in the base table.", name));
                }
                boolean nullable = (type = regularColumn.getType()).getNullable() == null || type.getNullable() != false;
                RelDataType relType = type.deriveType(this.sqlValidator, nullable);
                RelDataType oldType = this.physicalFieldNamesToTypes.put(name, relType);
                if (oldType == null) continue;
                throw new ValidationException(String.format("A regular Column named '%s' already exists in the table.", name));
            }
        }

        public Schema build() {
            Schema.Builder resultBuilder = Schema.newBuilder();
            resultBuilder.fromColumns(new ArrayList<Schema.UnresolvedColumn>(this.columns.values()));
            for (Schema.UnresolvedWatermarkSpec watermarkSpec : this.watermarkSpecs.values()) {
                resultBuilder.watermark(watermarkSpec.getColumnName(), watermarkSpec.getWatermarkExpression());
            }
            if (this.primaryKey != null) {
                resultBuilder.primaryKeyNamed(this.primaryKey.getConstraintName(), this.primaryKey.getColumnNames().toArray(new String[0]));
            }
            return resultBuilder.build();
        }
    }
}

