/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.functions.casting.AbstractNullAwareCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.BinaryToBinaryCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

class RawToBinaryCastRule
extends AbstractNullAwareCodeGeneratorCastRule<Object, byte[]> {
    static final RawToBinaryCastRule INSTANCE = new RawToBinaryCastRule();

    private RawToBinaryCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.RAW).target(LogicalTypeFamily.BINARY_STRING).build());
    }

    @Override
    public boolean canFail(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return true;
    }

    @Override
    protected String generateCodeBlockInternal(CodeGeneratorCastRule.Context context, String inputTerm, String returnVariable, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        int targetLength = LogicalTypeChecks.getLength((LogicalType)targetLogicalType);
        String typeSerializer = context.declareTypeSerializer(inputLogicalType);
        String deserializedByteArrayTerm = CodeGenUtils.newName("deserializedByteArray");
        if (context.legacyBehaviour() || !BinaryToBinaryCastRule.couldTrim(targetLength) && !BinaryToBinaryCastRule.couldPad(targetLogicalType, targetLength)) {
            return new CastRuleUtils.CodeWriter().assignStmt(returnVariable, CastRuleUtils.methodCall(inputTerm, "toBytes", typeSerializer)).toString();
        }
        return new CastRuleUtils.CodeWriter().declStmt(byte[].class, deserializedByteArrayTerm, CastRuleUtils.methodCall(inputTerm, "toBytes", typeSerializer)).ifStmt(CastRuleUtils.arrayLength(deserializedByteArrayTerm) + " <= " + targetLength, thenWriter -> {
            if (BinaryToBinaryCastRule.couldPad(targetLogicalType, targetLength)) {
                BinaryToBinaryCastRule.trimOrPadByteArray(returnVariable, targetLength, deserializedByteArrayTerm, thenWriter);
            } else {
                thenWriter.assignStmt(returnVariable, deserializedByteArrayTerm);
            }
        }, elseWriter -> BinaryToBinaryCastRule.trimOrPadByteArray(returnVariable, targetLength, deserializedByteArrayTerm, elseWriter)).toString();
    }
}

