/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.time.ZoneId;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.utils.CastExecutor;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public interface CastRule<IN, OUT> {
    public CastRulePredicate getPredicateDefinition();

    public CastExecutor<IN, OUT> create(Context var1, LogicalType var2, LogicalType var3);

    default public boolean canFail(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return false;
    }

    public static interface Context {
        public boolean isPrinting();

        @Deprecated
        public boolean legacyBehaviour();

        public ZoneId getSessionZoneId();

        public ClassLoader getClassLoader();

        public static Context create(final boolean isPrinting, final boolean legacyBehaviour, final ZoneId zoneId, final ClassLoader classLoader) {
            return new Context(){

                @Override
                public boolean isPrinting() {
                    return isPrinting;
                }

                @Override
                public boolean legacyBehaviour() {
                    return legacyBehaviour;
                }

                @Override
                public ZoneId getSessionZoneId() {
                    return zoneId;
                }

                @Override
                public ClassLoader getClassLoader() {
                    return classLoader;
                }
            };
        }
    }
}

